/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.listeners;

import dev.xdpxi.xdsutils.databases.Economy;
import dev.xdpxi.xdsutils.utils.Color;
import dev.xdpxi.xdsutils.utils.Config;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Objects;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.PlayerJoinEvent;

public class JoinListener
implements Listener {
    @EventHandler
    public void onPlayerJoin(PlayerJoinEvent event) {
        if (!Config.config.getBoolean("enable_custom_join_message")) {
            return;
        }
        String playerName = event.getPlayer().getName();
        long lastPlayed = event.getPlayer().getLastPlayed();
        LocalDate lastPlayedDate = Instant.ofEpochMilli(lastPlayed).atZone(ZoneId.systemDefault()).toLocalDate();
        LocalDate today = LocalDate.now(ZoneId.systemDefault());
        String message = Objects.requireNonNull(Color.parse(Config.config.getString("join_message"))).replace("%player%", playerName);
        event.setJoinMessage(message);
        if (lastPlayedDate.equals(today.minusDays(1L))) {
            double reward = Config.config.getDouble("daily_balance");
            Economy.addBalance(event.getPlayer().getUniqueId(), reward);
            event.getPlayer().sendMessage(String.valueOf(ChatColor.YELLOW) + "You gained " + String.valueOf(ChatColor.GOLD) + "$" + reward + String.valueOf(ChatColor.YELLOW) + " for joining today. Join tomorrow to get more!");
        }
    }
}

