/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.utils;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.WebServer;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Config {
    public static FileConfiguration config;
    private static JavaPlugin plugin;

    public static void init(JavaPlugin plugin) {
        Config.plugin = plugin;
        plugin.saveDefaultConfig();
        Config.reload();
    }

    public static void reload() {
        plugin.reloadConfig();
        config = plugin.getConfig();
        Config.migrateWorldsToFolders();
        Config.ensureAnyoneCreateShops();
        if (config.getBoolean("enable_web")) {
            WebServer.stop();
            WebServer.startAsync();
        }
        if (Main.backupManager != null) {
            Main.backupManager.stopBackups();
            Main.backupManager.reload();
            Main.backupManager.startBackups();
        }
        List list = config.getStringList("disabled_items");
        Main.disabledItems.clear();
        for (String s : list) {
            Main.disabledItems.add(s.toLowerCase());
        }
        if (Main.disabledCommands != null) {
            Main.disabledCommands.clear();
        }
        Main.disabledCommands = config.getStringList("disabled_commands");
    }

    private static void ensureAnyoneCreateShops() {
        File configFile = new File(plugin.getDataFolder(), "config.yml");
        if (!configFile.exists()) {
            return;
        }
        try {
            String content = Files.readString(configFile.toPath());
            if (content.contains("anyone_create_shops:")) {
                return;
            }
            Log.info("'anyone_create_shops' not found in config.yml. Creating with default value: true");
            Main.getInstance().getConfig().set("anyone_create_shops", (Object)true);
            Main.getInstance().saveConfig();
            plugin.reloadConfig();
            config = plugin.getConfig();
        }
        catch (Exception e) {
            Log.warn("Error while migrating 'anyone_create_shops' from config.yml" + e.getMessage());
            e.printStackTrace();
        }
    }

    private static void migrateWorldsToFolders() {
        block14: {
            File configFile = new File(plugin.getDataFolder(), "config.yml");
            if (!configFile.exists()) {
                return;
            }
            try {
                String content = Files.readString(configFile.toPath());
                if (content.contains("folders:")) {
                    return;
                }
                if (!content.contains("worlds:")) {
                    return;
                }
                Log.info("Starting migration from 'worlds' to 'folders'");
                Pattern pattern = Pattern.compile("(?m)^worlds:\\s*\\n((?:[ \\t]*-\\s*.+\\n?)*)");
                Matcher matcher = pattern.matcher(content);
                if (matcher.find()) {
                    String worldsBlock = matcher.group(1).trim();
                    String[] lines = worldsBlock.split("\\r?\\n");
                    StringBuilder newBlock = new StringBuilder("folders:\n");
                    for (String line : lines) {
                        newBlock.append("  ").append(line.trim()).append("\n");
                    }
                    content = matcher.replaceFirst(newBlock.toString());
                    File backupFile = new File(plugin.getDataFolder(), "config_old.yml");
                    if (!backupFile.exists()) {
                        Files.copy(configFile.toPath(), backupFile.toPath(), new CopyOption[0]);
                    }
                    try (FileOutputStream out = new FileOutputStream(configFile, false);){
                        out.write(content.getBytes(StandardCharsets.UTF_8));
                    }
                    plugin.reloadConfig();
                    config = plugin.getConfig();
                    Log.info("Migrated from 'worlds' to 'folders' successfully!");
                    break block14;
                }
                Log.warn("Could not locate 'worlds' block in config.yml (regex mismatch).");
            }
            catch (Exception e) {
                Log.warn("Failed to migrate from 'worlds' to 'folders': " + e.getMessage());
                e.printStackTrace();
            }
        }
    }
}

