/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Backup {
    public final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final JavaPlugin plugin;
    private final File backupsRoot;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private final Map<String, Integer> folderIntervals = new HashMap<String, Integer>();
    public int totalBackups = 0;
    private boolean enabled;
    private int maxBackups;
    private int compressionLevel;
    private int maxSizeMB;
    private int backupTaskId = -1;

    public Backup(JavaPlugin pluginInstance) {
        this.plugin = pluginInstance;
        this.backupsRoot = new File(this.plugin.getDataFolder(), "backups");
    }

    public void reload() {
        this.enabled = Config.config.getBoolean("enable_backups", true);
        this.maxSizeMB = Config.config.getInt("max_size", 1024);
        this.maxBackups = Config.config.getInt("max_backups", 10);
        this.compressionLevel = Config.config.getInt("compression_level", 9);
        this.folderIntervals.clear();
        List folderList = Config.config.getMapList("folders");
        for (Map entry : folderList) {
            for (Map.Entry e : entry.entrySet()) {
                String folderPath = String.valueOf(e.getKey());
                int interval = Integer.parseInt(String.valueOf(e.getValue()));
                this.folderIntervals.put(folderPath, interval);
            }
        }
        this.updateTotalBackups();
    }

    public void startBackups() {
        if (!this.enabled) {
            return;
        }
        if (!this.backupsRoot.exists()) {
            this.backupsRoot.mkdirs();
        }
        this.stopBackups();
        if (this.folderIntervals.isEmpty()) {
            Log.warn("No folders configured for backup.");
            return;
        }
        int minInterval = this.folderIntervals.values().stream().min(Integer::compareTo).orElse(60);
        this.backupTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::createAllFolderBackups, 0L, (long)minInterval * 60L * 20L).getTaskId();
        Log.info("Scheduled backups for all folders every " + minInterval + " minutes.");
    }

    public void stopBackups() {
        if (this.backupTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.backupTaskId);
            this.backupTaskId = -1;
        }
        Log.info("Backup schedule stopped.");
    }

    public void runBackupNow() {
        if (this.isRunning.get()) {
            Log.info("A backup is already running. Skipping manual backup.");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::createAllFolderBackups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAllFolderBackups() {
        if (!this.isRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            ArrayList<Thread> threads = new ArrayList<Thread>();
            for (String folderPath : this.folderIntervals.keySet()) {
                Thread t = new Thread(() -> this.createBackup(folderPath));
                t.start();
                threads.add(t);
            }
            for (Thread t : threads) {
                try {
                    t.join();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
        catch (Exception e) {
            Log.error("Failed to create backups!");
            e.printStackTrace();
        }
        finally {
            this.isRunning.set(false);
            this.updateTotalBackups();
        }
    }

    private void createBackup(String folderPath) {
        try {
            File folder = new File(folderPath);
            if (!folder.exists()) {
                Log.warn("Folder not found: " + folderPath);
                return;
            }
            String safeFolderName = folderPath.replace(File.separatorChar, '_').replace('/', '_');
            File folderBackupFolder = new File(this.backupsRoot, safeFolderName);
            if (!folderBackupFolder.exists()) {
                folderBackupFolder.mkdirs();
            }
            String timestamp = this.dateFormat.format(new Date());
            File tempBackup = new File(folderBackupFolder, "backup_" + timestamp + ".zip.tmp");
            File finalBackup = new File(folderBackupFolder, "backup_" + timestamp + ".zip");
            Log.info("Creating backup for folder '" + folderPath + "'...");
            try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempBackup));){
                zos.setLevel(this.compressionLevel);
                this.zipFolder(folder.toPath(), folder.getName(), zos);
            }
            Files.move(tempBackup.toPath(), finalBackup.toPath(), StandardCopyOption.ATOMIC_MOVE);
            Log.info("Backup created: " + finalBackup.getName());
            this.enforceBackupLimits(folderBackupFolder);
        }
        catch (Exception e) {
            Log.error("Failed to back up folder: " + folderPath);
            e.printStackTrace();
        }
    }

    private void zipFolder(Path folder, String parentFolder, ZipOutputStream zos) throws IOException {
        List<Path> paths = Files.walk(folder, new FileVisitOption[0]).toList();
        int counter = 0;
        for (Path path : paths) {
            File file = path.toFile();
            String fileName = file.getName();
            if (fileName.equals("session.lock")) continue;
            if (file.isDirectory() && fileName.equalsIgnoreCase("backups")) {
                Log.info("Skipping backups folder: " + file.getAbsolutePath());
                continue;
            }
            String relativePath = folder.relativize(path).toString();
            Object zipEntryName = parentFolder == null || parentFolder.isEmpty() ? relativePath : parentFolder + "/" + relativePath;
            zipEntryName = ((String)zipEntryName).replace('\\', '/');
            if (file.isDirectory() && !((String)zipEntryName).endsWith("/")) {
                zipEntryName = (String)zipEntryName + "/";
            }
            try {
                zos.putNextEntry(new ZipEntry((String)zipEntryName));
                if (!file.isDirectory()) {
                    Files.copy(path, zos);
                }
                zos.closeEntry();
            }
            catch (IOException e) {
                Log.warn("Could not copy file: " + file.getAbsolutePath());
            }
            if (++counter % 100 != 0) continue;
            Log.info("Processed " + counter + " files for folder " + parentFolder);
        }
    }

    private void enforceBackupLimits(File folderBackupFolder) {
        boolean unlimitedSize;
        File[] files = folderBackupFolder.listFiles((dir, name) -> name.endsWith(".zip"));
        if (files == null || files.length == 0) {
            return;
        }
        Arrays.sort(files, Comparator.comparingLong(File::lastModified));
        boolean unlimitedCount = this.maxBackups <= 0;
        boolean bl = unlimitedSize = this.maxSizeMB <= 0;
        if (unlimitedCount && unlimitedSize) {
            return;
        }
        long totalSizeMB = Arrays.stream(files).mapToLong(f -> f.length() / 0x100000L).sum();
        int currentCount = files.length;
        for (int index = 0; (!unlimitedCount && currentCount > this.maxBackups || !unlimitedSize && totalSizeMB > (long)this.maxSizeMB) && index < files.length; ++index) {
            File file = files[index];
            long fileSizeMB = file.length() / 0x100000L;
            if (file.delete()) {
                Log.info("Deleted old backup: " + file.getName());
                totalSizeMB -= fileSizeMB;
                --currentCount;
                continue;
            }
            Log.warn("Could not delete old backup: " + file.getName());
        }
    }

    public void updateTotalBackups() {
        this.totalBackups = 0;
        for (String folderPath : this.folderIntervals.keySet()) {
            File[] files;
            String safeFolderName = folderPath.replace(File.separatorChar, '_').replace('/', '_');
            File folderBackupFolder = new File(this.backupsRoot, safeFolderName);
            if (!folderBackupFolder.exists() || (files = folderBackupFolder.listFiles((dir, name) -> name.endsWith(".zip"))) == null) continue;
            this.totalBackups += files.length;
        }
    }
}

