/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import com.sun.management.OperatingSystemMXBean;
import com.sun.net.httpserver.HttpServer;
import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.Server;
import org.bukkit.World;

public class WebServer {
    private static final Object LOCK = new Object();
    private static HttpServer server;
    private static boolean running;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAsync() {
        Object object = LOCK;
        synchronized (object) {
            if (running) {
                Log.warn("WebServer is already starting or running!");
                return;
            }
            running = true;
        }
        new Thread(() -> {
            Object object;
            try {
                WebServer.start();
                object = LOCK;
            }
            catch (IOException e) {
                Object object2;
                try {
                    Log.error("Failed to start WebServer: " + String.valueOf(e));
                    object2 = LOCK;
                }
                catch (Throwable throwable) {
                    Object object3 = LOCK;
                    synchronized (object3) {
                        running = server != null;
                    }
                    throw throwable;
                }
                synchronized (object2) {
                    running = server != null;
                }
            }
            synchronized (object) {
                running = server != null;
            }
        }, "WebServer-Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            int basePort;
            if (server != null) {
                Log.warn("WebServer is already running!");
                return;
            }
            int port = basePort = Config.config.getInt("port");
            boolean bound = false;
            while (!bound && port < 65535) {
                try {
                    server = HttpServer.create(new InetSocketAddress(port), 0);
                    bound = true;
                }
                catch (IOException e) {
                    Log.warn("Port " + port + " is in use, trying " + (port + 1));
                    ++port;
                }
            }
            if (!bound) {
                Log.error("No available ports from " + basePort + " to 65535.");
                server = null;
                return;
            }
            Log.info("Server started at http://localhost:" + port);
            WebServer.registerContexts(server);
            server.setExecutor(null);
            server.start();
        }
    }

    private static void registerContexts(HttpServer srv) {
        srv.createContext("/", exchange -> {
            InputStream is = WebServer.class.getResourceAsStream("/index.html");
            if (is == null) {
                String error = "index.html not found in resources!";
                exchange.sendResponseHeaders(404, error.length());
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(error.getBytes());
                }
                return;
            }
            byte[] response = is.readAllBytes();
            exchange.getResponseHeaders().add("Content-Type", "text/html; charset=utf-8");
            exchange.sendResponseHeaders(200, response.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response);
            }
        });
        srv.createContext("/api/", exchange -> {
            exchange.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
            try {
                int players = Bukkit.getOnlinePlayers().size();
                int maxPlayers = Bukkit.getMaxPlayers();
                long ramUsed = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
                long ramMax = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
                double cpuLoad = WebServer.getProcessCpuLoad() * 100.0;
                double tps = WebServer.getTPS();
                double mspt = tps > 0.0 ? 1000.0 / tps : 50.0;
                long uptimeMs = ManagementFactory.getRuntimeMXBean().getUptime();
                String uptime = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(uptimeMs));
                String serverVersion = Bukkit.getVersion();
                List worlds = Bukkit.getWorlds();
                String worldName = worlds.isEmpty() ? "Unknown" : ((World)worlds.get(0)).getName();
                String defaultGameMode = "Unknown";
                try {
                    defaultGameMode = Bukkit.getDefaultGameMode().name();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                String difficulty = "Unknown";
                try {
                    difficulty = worlds.isEmpty() ? "Unknown" : ((World)worlds.get(0)).getDifficulty().name();
                }
                catch (Exception exception) {
                    // empty catch block
                }
                Main.backupManager.updateTotalBackups();
                int backups = Main.backupManager.totalBackups;
                String json = String.format("{\"players\": %d,\"max_players\": %d,\"tps\": %.2f,\"mspt\": %.2f,\"ram_used_mb\": %d,\"ram_max_mb\": %d,\"cpu_percent\": %.2f,\"uptime\": \"%s\",\"server_version\": \"%s\",\"world_name\": \"%s\",\"default_game_mode\": \"%s\",\"difficulty\": \"%s\",\"backups\": %d}", players, maxPlayers, tps, mspt, ramUsed, ramMax, cpuLoad, WebServer.escapeJson(uptime), WebServer.escapeJson(serverVersion), WebServer.escapeJson(worldName), WebServer.escapeJson(defaultGameMode), WebServer.escapeJson(difficulty), backups);
                byte[] response = json.getBytes(StandardCharsets.UTF_8);
                exchange.sendResponseHeaders(200, response.length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(response);
                }
            }
            catch (Exception e) {
                Log.error("Error while building /api/ response: " + e.getMessage());
                String errorJson = "{\"error\":\"internal\"}";
                byte[] response = errorJson.getBytes(StandardCharsets.UTF_8);
                exchange.sendResponseHeaders(500, response.length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(response);
                }
            }
        });
    }

    public static void stop() {
        if (server != null) {
            server.stop(0);
            Log.info("WebServer stopped.");
            server = null;
        } else {
            Log.warn("WebServer is not running.");
        }
    }

    private static double getProcessCpuLoad() {
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            double load = osBean.getProcessCpuLoad();
            if (Double.isNaN(load) || load < 0.0) {
                return 0.0;
            }
            return load;
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private static double getTPS() {
        try {
            Object[] arr;
            Server server = Bukkit.getServer();
            Method m = server.getClass().getMethod("getTPS", new Class[0]);
            Object tpsObj = m.invoke((Object)server, new Object[0]);
            if (tpsObj instanceof double[]) {
                double[] arr2 = (double[])tpsObj;
                if (arr2.length > 0) {
                    return arr2[0];
                }
            } else if (tpsObj instanceof Object[] && (arr = (Object[])tpsObj).length > 0 && arr[0] instanceof Number) {
                return ((Number)arr[0]).doubleValue();
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 20.0;
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    public static boolean verify(String code) {
        return false;
    }

    static {
        running = false;
    }
}

