/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record Mute(Main plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!command.getName().equalsIgnoreCase("mute")) {
            return false;
        }
        if (!sender.hasPermission("xdsutils.mute") && !sender.isOp()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "You don't have permission!");
            return true;
        }
        if (args.length == 0) {
            Main.chatDisabled = !Main.chatDisabled;
            Bukkit.broadcastMessage((String)(Main.chatDisabled ? String.valueOf(ChatColor.RED) + "Chat has been disabled by an administrator!" : String.valueOf(ChatColor.GREEN) + "Chat has been enabled!"));
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return true;
        }
        String name = target.getName().toLowerCase();
        if (Main.mutedPlayers.contains(name)) {
            Main.mutedPlayers.remove(name);
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + target.getName() + " has been unmuted.");
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + "You have been unmuted.");
        } else {
            Main.mutedPlayers.add(name);
            sender.sendMessage(String.valueOf(ChatColor.RED) + target.getName() + " has been muted.");
            target.sendMessage(String.valueOf(ChatColor.RED) + "You have been muted.");
        }
        return true;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("mute")) {
            return null;
        }
        if (args.length == 1) {
            String partial = args[0].toLowerCase();
            ArrayList<String> matches = new ArrayList<String>();
            for (Player player : Bukkit.getOnlinePlayers()) {
                String name = player.getName();
                if (!name.toLowerCase().startsWith(partial)) continue;
                matches.add(name);
            }
            return matches;
        }
        return new ArrayList<String>();
    }
}

