/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Economy;
import dev.xdpxi.xdsutils.utils.Log;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.jetbrains.annotations.NotNull;

public record Shop(Main plugin) implements CommandExecutor,
TabCompleter,
Listener
{
    private static void openShop(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.GREEN) + "Shop"));
        List shopItems = Config.config.getMapList("shop_items");
        for (Map map : shopItems) {
            for (Object key : map.keySet()) {
                String itemKey = key.toString();
                Map data = (Map)map.get(key);
                int cost = (Integer)data.get("cost");
                int amount = (Integer)data.get("amount");
                int slot = (Integer)data.get("slot");
                Material material = Material.matchMaterial((String)itemKey.replace("minecraft:", ""));
                if (material == null) continue;
                ItemStack item = new ItemStack(material, amount);
                ItemMeta meta = item.getItemMeta();
                assert (meta != null);
                meta.setDisplayName(String.valueOf(ChatColor.GRAY) + Shop.formatMaterialName(material.name()));
                ArrayList<CallSite> lore = new ArrayList<CallSite>();
                String line1 = String.valueOf(ChatColor.YELLOW) + "Cost: " + String.valueOf(ChatColor.GOLD) + "$" + cost;
                String line2 = String.valueOf(ChatColor.GREEN) + "[LEFT CLICK] Buy";
                String line3 = String.valueOf(ChatColor.RED) + "[RIGHT CLICK] Sell";
                int longest = Math.max(Math.max(ChatColor.stripColor((String)line1).length(), ChatColor.stripColor((String)line2).length()), ChatColor.stripColor((String)line3).length());
                String separator = String.valueOf(ChatColor.DARK_GRAY) + "=".repeat(longest);
                lore.add((CallSite)((Object)separator));
                lore.add((CallSite)((Object)line1));
                lore.add((CallSite)((Object)separator));
                lore.add((CallSite)((Object)line2));
                lore.add((CallSite)((Object)line3));
                lore.add((CallSite)((Object)separator));
                meta.setLore(lore);
                item.setItemMeta(meta);
                inv.setItem(slot, item);
            }
        }
        player.openInventory(inv);
    }

    private static String formatMaterialName(String name) {
        String[] parts = name.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String part : parts) {
            formatted.append(part.charAt(0)).append(part.substring(1).toLowerCase()).append(" ");
        }
        return formatted.toString().trim();
    }

    private static boolean createShop(Player player, String shopName) {
        Log.info("Creating shop " + shopName + " for " + player.getName());
        return true;
    }

    private static boolean editShop(Player player, String shopName) {
        Log.info("Editing shop " + shopName + " for " + player.getName());
        return true;
    }

    private static boolean viewShop(Player player, String shopName) {
        Log.info("Viewing shop " + shopName + " for " + player.getName());
        return true;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!Config.config.getBoolean("enable_shop")) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            Shop.openShop(player);
            Log.info("Viewing shop for " + player.getName());
            return true;
        }
        return switch (args[0].toLowerCase()) {
            case "create" -> Shop.createShop(player, args[1]);
            case "edit" -> Shop.editShop(player, args[1]);
            default -> Shop.viewShop(player, args[1]);
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("shop")) {
            return null;
        }
        if (!Config.config.getBoolean("enable_shop")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("xdsutils.economy.createshop") || sender.isOp()) {
                completions.add("create");
            }
            if (sender.hasPermission("xdsutils.economy.editshop") || sender.isOp()) {
                completions.add("edit");
            }
            return completions;
        }
        if (args[0].equalsIgnoreCase("create") && args.length == 2) {
            completions.add("<name>");
        } else if (args[0].equalsIgnoreCase("edit") && args.length == 2) {
            completions.add("<name>");
        } else if (args[0].equalsIgnoreCase("view") && args.length == 2) {
            completions.add("<name>");
        } else if (sender.hasPermission("xdsutils.economy.admin") || sender.isOp()) {
            String partial = args[0].toLowerCase();
            for (Player player : Bukkit.getOnlinePlayers()) {
                String name = player.getName();
                if (!name.toLowerCase().startsWith(partial) || !sender.hasPermission("xdsutils.economy.admin") && !sender.isOp()) continue;
                completions.add(name);
            }
        }
        if (!(args.length != 3 || args[0].equalsIgnoreCase("edit") || args[0].equalsIgnoreCase("create") || args[0].equalsIgnoreCase("view") || !sender.hasPermission("xdsutils.economy.admin") && !sender.isOp())) {
            completions.add("<amount>");
        }
        return completions;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (event.getClickedInventory() == null) {
            return;
        }
        event.getView().getTitle();
        if (!ChatColor.stripColor((String)event.getView().getTitle()).equalsIgnoreCase("Shop")) {
            return;
        }
        if (!Config.config.getBoolean("enable_shop")) {
            return;
        }
        event.setCancelled(true);
        Player player = (Player)event.getWhoClicked();
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String materialName = clicked.getType().name().toLowerCase();
        List shopItems = Config.config.getMapList("shop_items");
        for (Map map : shopItems) {
            for (Object key : map.keySet()) {
                String itemKey = key.toString().replace("minecraft:", "");
                if (!itemKey.equalsIgnoreCase(materialName)) continue;
                Map data = (Map)map.get(key);
                int cost = (Integer)data.get("cost");
                int amount = (Integer)data.get("amount");
                UUID uuid = player.getUniqueId();
                double balance = Economy.getBalance(uuid);
                if (event.isLeftClick()) {
                    if (balance < (double)cost) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough money!");
                        return;
                    }
                    ItemStack item = new ItemStack(clicked.getType(), amount);
                    player.getInventory().addItem(new ItemStack[]{item});
                    Economy.setBalance(uuid, balance - (double)cost);
                    player.sendMessage(String.valueOf(ChatColor.GREEN) + "Bought " + amount + " " + itemKey + " for " + cost);
                    Log.info("Bought " + amount + " " + itemKey + " for " + cost + " from " + player.getName());
                    continue;
                }
                if (!event.isRightClick()) continue;
                if (player.getInventory().contains(clicked.getType(), amount)) {
                    player.getInventory().removeItem(new ItemStack[]{new ItemStack(clicked.getType(), amount)});
                    Economy.setBalance(uuid, balance + (double)cost);
                    player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Sold " + amount + " " + itemKey + " for " + cost);
                    Log.info("Sold " + amount + " " + itemKey + " for " + cost + " to " + player.getName());
                    continue;
                }
                player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have any " + itemKey + " to sell!");
            }
        }
    }
}

