/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Backup {
    public final AtomicBoolean isRunning = new AtomicBoolean(false);
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private final JavaPlugin plugin;
    private final File backupsRoot;
    public int totalBackups = 0;
    private boolean enabled;
    private List<String> worlds;
    private int maxSize;
    private int maxBackups;
    private int compressionLevel;
    private int interval;
    private int backupTaskId = -1;

    public Backup(JavaPlugin pluginInstance) {
        this.plugin = pluginInstance;
        this.backupsRoot = new File(this.plugin.getDataFolder(), "backups");
    }

    public void reload() {
        this.enabled = Config.config.getBoolean("enable_backups", true);
        this.worlds = Config.config.getStringList("worlds");
        this.maxSize = Config.config.getInt("max_size", 1024);
        this.maxBackups = Config.config.getInt("max_backups", 10);
        this.compressionLevel = Config.config.getInt("compression_level", 9);
        this.interval = Config.config.getInt("backup_interval", 120);
        this.updateTotalBackups();
    }

    public void startBackups() {
        if (!this.enabled) {
            return;
        }
        if (!this.backupsRoot.exists()) {
            this.backupsRoot.mkdirs();
        }
        this.backupTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, Main.backupManager::createBackup, 0L, (long)this.interval * 60L * 20L).getTaskId();
        Bukkit.getLogger().info("[Backup] Backup schedule started.");
    }

    public void stopBackups() {
        if (this.backupTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.backupTaskId);
            this.backupTaskId = -1;
            Bukkit.getLogger().info("[Backup] Backup schedule stopped.");
        }
    }

    public void runBackupNow() {
        if (this.isRunning.get()) {
            Bukkit.getLogger().info("[Backup] A backup is already running. Skipping manual backup.");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, Main.backupManager::createBackup);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createBackup() {
        if (!this.isRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            for (String worldName : this.worlds) {
                File worldFolder = new File(worldName);
                if (!worldFolder.exists()) continue;
                File worldBackupFolder = new File(this.backupsRoot, worldName);
                if (!worldBackupFolder.exists()) {
                    worldBackupFolder.mkdirs();
                }
                String timestamp = this.dateFormat.format(new Date());
                File backupZip = new File(worldBackupFolder, "backup_" + timestamp + ".zip");
                try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(backupZip));){
                    zos.setLevel(this.compressionLevel);
                    this.zipFolder(worldFolder.toPath(), worldFolder.getName(), zos);
                }
                Bukkit.getLogger().info("[Backup] Backup created for world '" + worldName + "': " + backupZip.getName());
                this.enforceBackupLimits(worldBackupFolder);
            }
        }
        catch (Exception e) {
            Bukkit.getLogger().severe("[Backup] Failed to create backup!");
            e.printStackTrace();
        }
        finally {
            this.isRunning.set(false);
        }
    }

    private void zipFolder(Path folder, String parentFolder, ZipOutputStream zos) throws IOException {
        Files.walk(folder, new FileVisitOption[0]).forEach(path -> {
            block7: {
                File file = path.toFile();
                if (file.getName().equals("session.lock")) {
                    return;
                }
                String zipEntryName = parentFolder + File.separator + String.valueOf(folder.relativize((Path)path));
                try {
                    if (file.isDirectory()) {
                        if (!zipEntryName.endsWith("/")) {
                            zipEntryName = zipEntryName + "/";
                        }
                        zos.putNextEntry(new ZipEntry(zipEntryName));
                        zos.closeEntry();
                        break block7;
                    }
                    zos.putNextEntry(new ZipEntry(zipEntryName));
                    try {
                        Files.copy(path, zos);
                    }
                    catch (IOException e) {
                        this.plugin.getLogger().warning("[Backup] Could not copy file (locked?): " + file.getAbsolutePath());
                    }
                    zos.closeEntry();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    private void enforceBackupLimits(File worldBackupFolder) {
        File[] files = worldBackupFolder.listFiles((dir, name) -> name.endsWith(".zip"));
        if (files == null) {
            return;
        }
        Arrays.sort(files, Comparator.comparingLong(File::lastModified).reversed());
        long totalSizeMB = 0L;
        for (File file : files) {
            totalSizeMB += file.length() / 0x100000L;
        }
        for (int i = files.length - 1; i >= 0; --i) {
            if (i < this.maxBackups && totalSizeMB <= (long)this.maxSize) continue;
            totalSizeMB -= files[i].length() / 0x100000L;
            files[i].delete();
        }
    }

    public void updateTotalBackups() {
        File overworldBackupFolder = new File(this.backupsRoot, "world");
        if (!overworldBackupFolder.exists()) {
            this.totalBackups = 0;
            return;
        }
        File[] files = overworldBackupFolder.listFiles((dir, name) -> name.endsWith(".zip"));
        this.totalBackups = files != null ? files.length : 0;
    }
}

