/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.WebServer;
import dev.xdpxi.xdsutils.utils.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public record XDsUtils(Main plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length == 0) {
            return false;
        }
        return switch (args[0].toLowerCase()) {
            case "reload" -> this.reloadConfig(sender);
            case "backup" -> {
                if (args.length > 1) {
                    switch (args[1].toLowerCase()) {
                        case "status": {
                            yield this.backupStatus(sender);
                        }
                    }
                    yield this.backupServer(sender);
                }
                yield this.backupServer(sender);
            }
            case "web" -> this.webVerify(sender, args);
            case "disabled" -> {
                if (args.length > 1) {
                    switch (args[1].toLowerCase()) {
                        case "items": {
                            yield this.disabledItemsCommand(sender, args);
                        }
                        case "commands": {
                            yield this.disabledCommandsCommand(sender, args);
                        }
                    }
                    yield this.backupServer(sender);
                }
                yield this.backupServer(sender);
            }
            default -> false;
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (sender.hasPermission("xdsutils.reload") || sender.isOp()) {
                completions.add("reload");
            }
            if (sender.hasPermission("xdsutils.backup")) {
                completions.add("backup");
            }
            if (sender.hasPermission("xdsutils.web") || sender.isOp()) {
                completions.add("web");
            }
            if (sender.hasPermission("xdsutils.disabled.items") || sender.hasPermission("xdsutils.disabled.commands") || sender.isOp()) {
                completions.add("disabled");
            }
            return completions;
        }
        if (args.length == 2) {
            if (args[0].equalsIgnoreCase("backup") && sender.hasPermission("xdsutils.backup")) {
                completions.add("status");
            }
            if (args[0].equalsIgnoreCase("web") && (sender.hasPermission("xdsutils.web") || sender.isOp())) {
                completions.add("<code>");
            }
            if (args[0].equalsIgnoreCase("disabled")) {
                if (sender.hasPermission("xdsutils.disabled.items") || sender.isOp()) {
                    completions.add("items");
                }
                if (sender.hasPermission("xdsutils.disabled.commands") || sender.isOp()) {
                    completions.add("commands");
                }
            }
            return completions;
        }
        return completions;
    }

    private boolean hasPermission(CommandSender sender, String permission, Boolean op) {
        if (sender.hasPermission(permission) || op.booleanValue() && sender.isOp()) {
            return false;
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "You do not have permission to perform this action!");
        return true;
    }

    private boolean reloadConfig(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.reload", true)) {
            return true;
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, Config::reload);
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Configuration reloaded successfully!");
        return true;
    }

    private boolean backupServer(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.backup", false)) {
            return true;
        }
        if (Main.backupManager.isRunning.get()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "A backup is already running. Please wait until it finishes.");
            return true;
        }
        Main.backupManager.runBackupNow();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Backup started successfully!");
        return true;
    }

    private boolean backupStatus(CommandSender sender) {
        if (this.hasPermission(sender, "xdsutils.backup", false)) {
            return true;
        }
        if (Main.backupManager.isRunning.get()) {
            sender.sendMessage(String.valueOf(ChatColor.GOLD) + "A backup is currently running.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "No backup is currently running.");
        return true;
    }

    private boolean webVerify(CommandSender sender, String[] args) {
        if (this.hasPermission(sender, "xdsutils.web", true)) {
            return true;
        }
        if (args.length < 2) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "/xdsutils web <code>");
            return true;
        }
        if (!WebServer.verify(args[1])) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Invalid verification code.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Verification successful!");
        return true;
    }

    private boolean disabledItemsCommand(CommandSender sender, String[] args) {
        if (this.hasPermission(sender, "xdsutils.disabled.items", true)) {
            return true;
        }
        if (Main.disabledItems.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "There are no disabled items.");
            return true;
        }
        String itemsList = Main.disabledItems.stream().sorted().collect(Collectors.joining(", "));
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Disabled items: " + String.valueOf(ChatColor.GRAY) + itemsList);
        return true;
    }

    private boolean disabledCommandsCommand(CommandSender sender, String[] args) {
        if (this.hasPermission(sender, "xdsutils.disabled.commands", true)) {
            return true;
        }
        if (Main.disabledCommands.isEmpty()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "There are no disabled commands.");
            return true;
        }
        String itemsList = Main.disabledCommands.stream().sorted().collect(Collectors.joining(", "));
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Disabled commands: " + String.valueOf(ChatColor.GRAY) + itemsList);
        return true;
    }
}

