/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.commands.Shop;
import dev.xdpxi.xdsutils.databases.Bounties;
import dev.xdpxi.xdsutils.databases.Economy;
import dev.xdpxi.xdsutils.utils.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record Bounty(Main plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!Config.config.getBoolean("enable_bounties")) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your current bounty is " + String.valueOf(ChatColor.GOLD) + "$" + Bounties.getBounty(player.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
            return true;
        }
        return switch (args[0].toLowerCase()) {
            case "remove" -> this.removeBounty(player, args);
            case "add" -> this.addBounty(player, args);
            case "set" -> this.setBounty(player, args);
            case "get" -> this.getBounty(player, args);
            case "place" -> this.placeBounty(player, args);
            case "leaderboard" -> this.getBountyLeaderboard(player);
            default -> false;
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("bounty")) {
            return null;
        }
        if (!Config.config.getBoolean("enable_bounties")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (Shop.hasPermission(sender, true)) {
                completions.add("add");
                completions.add("set");
                completions.add("get");
                completions.add("remove");
            }
            completions.add("place");
            completions.add("leaderboard");
            return completions;
        }
        if (args.length == 2) {
            String partial = args[1].toLowerCase();
            for (Player player : Bukkit.getOnlinePlayers()) {
                String name = player.getName();
                if (!name.toLowerCase().startsWith(partial)) continue;
                completions.add(name);
            }
            return completions;
        }
        if (args.length == 3) {
            completions.add("<amount>");
        }
        return completions;
    }

    private boolean getBounty(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your current bounty is " + String.valueOf(ChatColor.GOLD) + "$" + Bounties.getBounty(player.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
            return true;
        }
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s bounty is " + String.valueOf(ChatColor.GOLD) + "$" + Bounties.getBounty(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean setBounty(Player player, String[] args) {
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /bounty set <player> <amount>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        Bounties.setBounty(target.getUniqueId(), Double.parseDouble(args[2]));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s bounty is now " + String.valueOf(ChatColor.GOLD) + "$" + Bounties.getBounty(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ". Your balance is now " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(player.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean addBounty(Player player, String[] args) {
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /bounty add <player> <amount>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        Bounties.addBounty(target.getUniqueId(), Double.parseDouble(args[2]));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s balance is now " + String.valueOf(ChatColor.GOLD) + "$" + Bounties.getBounty(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean placeBounty(Player player, String[] args) {
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /bounty place <player> <amount>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        if (Economy.getBalance(player.getUniqueId()) >= Double.parseDouble(args[2])) {
            Bounties.addBounty(target.getUniqueId(), Double.parseDouble(args[2]));
            Economy.removeBalance(player.getUniqueId(), Double.parseDouble(args[2]));
            target.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your bounty has been increased to " + String.valueOf(ChatColor.GOLD) + "$" + Bounties.getBounty(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s balance is now " + String.valueOf(ChatColor.GOLD) + "$" + Bounties.getBounty(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
            return true;
        }
        return true;
    }

    private boolean removeBounty(Player player, String[] args) {
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /bounty remove <player> <amount>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        Bounties.removeBounty(target.getUniqueId(), Double.parseDouble(args[2]));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s bounty is now " + String.valueOf(ChatColor.GOLD) + "$" + Bounties.getBounty(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean getBountyLeaderboard(Player player) {
        List<Map.Entry<UUID, Double>> leaderboard = Bounties.getLeaderboard();
        if (leaderboard.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No leaderboard data available.");
            return true;
        }
        String title = String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Top Bounties:";
        String separator = String.valueOf(ChatColor.DARK_GRAY) + "=======================";
        player.sendMessage(separator);
        player.sendMessage(title);
        player.sendMessage(separator);
        int rank = 1;
        for (Map.Entry<UUID, Double> entry : leaderboard) {
            String name;
            if (rank > 5) break;
            UUID uuid = entry.getKey();
            double balance = entry.getValue();
            Player onlinePlayer = Bukkit.getPlayer((UUID)uuid);
            if (onlinePlayer != null) {
                name = onlinePlayer.getName();
            } else {
                name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                if (name == null) {
                    name = "Unknown";
                }
            }
            String formattedBalance = String.format("%,.2f", balance);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + rank + ". " + name + String.valueOf(ChatColor.GRAY) + " - " + String.valueOf(ChatColor.GOLD) + "$" + formattedBalance);
            ++rank;
        }
        player.sendMessage(separator);
        return true;
    }
}

