/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.inventory.InventoryCloseEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public record Inv(Main plugin) implements CommandExecutor,
Listener
{
    private static final String TITLE = String.valueOf(ChatColor.GOLD) + "Inventory View";

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!(sender instanceof Player)) {
            sender.sendMessage("Only players can use this command!");
            return true;
        }
        Player viewer = (Player)sender;
        if (!viewer.hasPermission("xdsutils.inv") || !viewer.isOp()) {
            viewer.sendMessage(String.valueOf(ChatColor.RED) + "No permission!");
            return true;
        }
        if (args.length != 1) {
            viewer.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /inv <playername>");
            return true;
        }
        Player target = Bukkit.getPlayer((String)args[0]);
        if (target == null) {
            viewer.sendMessage(String.valueOf(ChatColor.RED) + "Player not found!");
            return true;
        }
        this.openInventory(viewer, target);
        return true;
    }

    private void openInventory(Player viewer, Player target) {
        int i;
        Inventory gui = Bukkit.createInventory(null, (int)45, (String)TITLE);
        for (i = 0; i < 27; ++i) {
            gui.setItem(i, target.getInventory().getItem(i + 9));
        }
        for (i = 0; i < 9; ++i) {
            gui.setItem(27 + i, target.getInventory().getItem(i));
        }
        gui.setItem(36, target.getInventory().getHelmet());
        gui.setItem(37, target.getInventory().getChestplate());
        gui.setItem(38, target.getInventory().getLeggings());
        gui.setItem(39, target.getInventory().getBoots());
        gui.setItem(40, target.getInventory().getItemInOffHand());
        viewer.openInventory(gui);
        viewer.setMetadata("inv_target", (MetadataValue)new FixedMetadataValue((Plugin)this.plugin, (Object)target.getUniqueId().toString()));
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        if (!event.getView().getTitle().equals(TITLE)) {
            return;
        }
        Player viewer = (Player)event.getWhoClicked();
        if (!viewer.hasMetadata("inv_target")) {
            return;
        }
        event.setCancelled(true);
    }

    @EventHandler
    public void onInventoryClose(InventoryCloseEvent event) {
        if (!event.getView().getTitle().equals(TITLE)) {
            return;
        }
        Player viewer = (Player)event.getPlayer();
        viewer.removeMetadata("inv_target", (Plugin)this.plugin);
    }
}

