/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.databases.Economy;
import dev.xdpxi.xdsutils.databases.Shops;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;
import org.bukkit.plugin.Plugin;
import org.jetbrains.annotations.NotNull;

public record Shop(Main plugin) implements CommandExecutor,
TabCompleter,
Listener
{
    private static final Map<UUID, PendingEdit> pendingEdits = new HashMap<UUID, PendingEdit>();
    private static final int SHOP_SIZE = 54;
    private static final Map<UUID, Long> lastShopAction = new HashMap<UUID, Long>();
    private static final long SHOP_ACTION_COOLDOWN = 50L;

    public static boolean hasPermission(CommandSender sender, boolean admin) {
        if (admin) {
            return sender.hasPermission("xdsutils.economy.admin") || sender.isOp();
        }
        return sender.hasPermission("xdsutils.economy.admin") || sender.isOp() || Config.config.getBoolean("anyone_create_shops");
    }

    private static boolean createShop(Player player, String shopName) {
        if (!Shop.hasPermission((CommandSender)player, false)) {
            return true;
        }
        Shops.createShop(shopName, player.getUniqueId());
        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Shop " + shopName + " created!");
        Log.info(player.getName() + " created shop " + shopName);
        return true;
    }

    private static boolean deleteShop(Player player, String shopName) {
        if (!Shop.hasPermission((CommandSender)player, false)) {
            return true;
        }
        Map<String, UUID> allShops = Shops.getAllShops();
        if (!allShops.containsKey(shopName.toLowerCase())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "That shop does not exist.");
            return false;
        }
        if (!allShops.get(shopName.toLowerCase()).equals(player.getUniqueId()) && !Shop.hasPermission((CommandSender)player, true)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not own this shop!");
            return false;
        }
        Map<Integer, Shops.ShopItem> items = Shops.getShopItems(shopName);
        for (Shops.ShopItem stack : items.values()) {
            Material mat = Material.matchMaterial((String)stack.itemName());
            if (mat == null) continue;
            player.getInventory().addItem(new ItemStack[]{new ItemStack(mat, stack.amount())});
        }
        Shops.deleteShop(shopName);
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Shop " + shopName + " has been deleted and all items returned.");
        Log.info(player.getName() + " deleted shop " + shopName);
        return true;
    }

    private static void openServerShop(Player player) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.GREEN) + "Shop"));
        List shopItems = Config.config.getMapList("shop_items");
        for (Map map : shopItems) {
            for (Object key : map.keySet()) {
                Material mat = Material.matchMaterial((String)key.toString().replace("minecraft:", ""));
                if (mat == null) continue;
                Map data = (Map)map.get(key);
                int amount = data.getOrDefault("amount", 1);
                int cost = data.getOrDefault("cost", 0);
                Object slotObj = data.get("slot");
                int slot = -1;
                if (slotObj instanceof Number) {
                    slot = ((Number)slotObj).intValue();
                } else if (slotObj instanceof String) {
                    try {
                        slot = Integer.parseInt((String)slotObj);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                if (slot < 0 || slot >= 54) continue;
                ItemStack item = Shop.createItemStack(mat, amount, String.valueOf(ChatColor.GRAY) + Shop.formatMaterialName(mat.name()), Arrays.asList(String.valueOf(ChatColor.DARK_GRAY) + "====================", String.valueOf(ChatColor.YELLOW) + "Cost: " + String.valueOf(ChatColor.GOLD) + "$" + cost, String.valueOf(ChatColor.DARK_GRAY) + "====================", String.valueOf(ChatColor.GREEN) + "[LEFT CLICK] Buy", String.valueOf(ChatColor.RED) + "[RIGHT CLICK] Sell", String.valueOf(ChatColor.DARK_GRAY) + "===================="));
                inv.setItem(slot, item);
            }
        }
        player.openInventory(inv);
    }

    private static void openPlayerShop(Player player, String shopName) {
        Map<Integer, Shops.ShopItem> items = Shops.getShopItems(shopName);
        if (items.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "That shop has no items for sale.");
            return;
        }
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.GREEN) + shopName));
        int slot = 0;
        for (Map.Entry<Integer, Shops.ShopItem> entry : items.entrySet()) {
            if (slot >= 54) break;
            Shops.ShopItem stack = entry.getValue();
            Material mat = Material.matchMaterial((String)stack.itemName());
            if (mat == null) continue;
            ItemStack item = Shop.createItemStack(mat, stack.amount(), String.valueOf(ChatColor.GRAY) + Shop.formatMaterialName(mat.name()), Arrays.asList(String.valueOf(ChatColor.DARK_GRAY) + "====================", String.valueOf(ChatColor.YELLOW) + "Cost: " + String.valueOf(ChatColor.GOLD) + "$" + stack.price(), String.valueOf(ChatColor.GRAY) + "ID: " + String.valueOf(entry.getKey()), String.valueOf(ChatColor.DARK_GRAY) + "====================", String.valueOf(ChatColor.GREEN) + "[LEFT CLICK] Buy 1", String.valueOf(ChatColor.DARK_GRAY) + "===================="));
            inv.setItem(slot++, item);
        }
        player.openInventory(inv);
    }

    private static boolean editShop(Player player, String shopName) {
        if (!Shop.hasPermission((CommandSender)player, false)) {
            return true;
        }
        Map<String, UUID> allShops = Shops.getAllShops();
        if (!allShops.containsKey(shopName.toLowerCase())) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "That shop does not exist.");
            return false;
        }
        if (!allShops.get(shopName.toLowerCase()).equals(player.getUniqueId()) && !Shop.hasPermission((CommandSender)player, true)) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You do not own this shop!");
            return false;
        }
        Shop.openShopEditor(player, shopName);
        return true;
    }

    private static void openShopEditor(Player player, String shopName) {
        Inventory inv = Bukkit.createInventory(null, (int)54, (String)(String.valueOf(ChatColor.BLUE) + "Editing: " + shopName));
        Map<Integer, Shops.ShopItem> items = Shops.getShopItems(shopName);
        int slot = 0;
        for (Map.Entry<Integer, Shops.ShopItem> entry : items.entrySet()) {
            if (slot >= 54) break;
            Shops.ShopItem stack = entry.getValue();
            Material mat = Material.matchMaterial((String)stack.itemName());
            if (mat == null) continue;
            ItemStack item = Shop.createItemStack(mat, stack.amount(), String.valueOf(ChatColor.GRAY) + Shop.formatMaterialName(mat.name()), Arrays.asList(String.valueOf(ChatColor.DARK_GRAY) + "===========================", String.valueOf(ChatColor.YELLOW) + "Cost: " + String.valueOf(ChatColor.GOLD) + "$" + stack.price(), String.valueOf(ChatColor.GRAY) + "ID: " + String.valueOf(entry.getKey()), String.valueOf(ChatColor.DARK_GRAY) + "===========================", String.valueOf(ChatColor.GREEN) + "[LEFT CLICK] Change Price", String.valueOf(ChatColor.RED) + "[RIGHT CLICK] Remove Item", String.valueOf(ChatColor.DARK_GRAY) + "==========================="));
            inv.setItem(slot++, item);
        }
        player.openInventory(inv);
    }

    private static ItemStack createItemStack(Material mat, int amount, String displayName, List<String> lore) {
        ItemStack item = new ItemStack(mat, amount);
        ItemMeta meta = item.getItemMeta();
        if (meta != null) {
            meta.setDisplayName(displayName);
            meta.setLore(lore);
            item.setItemMeta(meta);
        }
        return item;
    }

    private static String formatMaterialName(String name) {
        String[] parts = name.split("_");
        StringBuilder formatted = new StringBuilder();
        for (String part : parts) {
            formatted.append(part.charAt(0)).append(part.substring(1).toLowerCase()).append(" ");
        }
        return formatted.toString().trim();
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!Config.config.getBoolean("enable_shop")) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            Shop.openServerShop(player);
            Log.info("Viewing server shop for " + player.getName());
            return true;
        }
        if (args.length < 2 && !args[0].equalsIgnoreCase("view")) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /shop <create|edit|delete|view> [name]");
            return true;
        }
        switch (args[0].toLowerCase()) {
            case "create": {
                Shop.createShop(player, args[1]);
                break;
            }
            case "edit": {
                Shop.editShop(player, args[1]);
                break;
            }
            case "delete": {
                Shop.deleteShop(player, args[1]);
                break;
            }
            case "view": {
                if (args.length == 1) {
                    Shop.openServerShop(player);
                    break;
                }
                Shop.openPlayerShop(player, args[1]);
                break;
            }
            default: {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Unknown subcommand.");
            }
        }
        return true;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        HumanEntity humanEntity = event.getWhoClicked();
        if (!(humanEntity instanceof Player)) {
            return;
        }
        Player player = (Player)humanEntity;
        ItemStack clicked = event.getCurrentItem();
        if (clicked == null || clicked.getType() == Material.AIR) {
            return;
        }
        String title = ChatColor.stripColor((String)event.getView().getTitle()).trim();
        String safeTitle = title.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
        if (title.startsWith("Editing: ")) {
            event.setCancelled(true);
            this.handleShopEditorClick(player, clicked, title.replace("Editing: ", ""), event);
            return;
        }
        Map<String, UUID> shops = Shops.getAllShops();
        if (shops.containsKey(safeTitle)) {
            event.setCancelled(true);
            this.handlePlayerShopClick(player, clicked, safeTitle, event);
            return;
        }
        if (title.equalsIgnoreCase("Shop")) {
            event.setCancelled(true);
            this.handleServerShopClick(player, clicked, event);
        }
    }

    private void handleShopEditorClick(Player player, ItemStack clicked, String shopName, InventoryClickEvent event) {
        Map<Integer, Shops.ShopItem> items = Shops.getShopItems(shopName);
        if (event.getClickedInventory() == player.getInventory()) {
            if (items.size() >= 54) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your shop is full!");
                return;
            }
            Shops.addItem(shopName, clicked.getType().name(), clicked.getAmount(), 10.0);
            player.getInventory().removeItem(new ItemStack[]{clicked});
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Shop.editShop(player, shopName));
            return;
        }
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            return;
        }
        int stackId = meta.getLore().stream().filter(line -> ChatColor.stripColor((String)line).startsWith("ID: ")).mapToInt(line -> Integer.parseInt(ChatColor.stripColor((String)line).replace("ID: ", "").trim())).findFirst().orElse(-1);
        if (stackId == -1) {
            return;
        }
        if (event.isLeftClick()) {
            player.closeInventory();
            player.sendMessage(String.valueOf(ChatColor.AQUA) + "Type new price for " + Shop.formatMaterialName(clicked.getType().name()) + " in chat:");
            pendingEdits.put(player.getUniqueId(), new PendingEdit(shopName, stackId));
        } else if (event.isRightClick()) {
            Shops.deleteItem(shopName, stackId);
            player.getInventory().addItem(new ItemStack[]{new ItemStack(clicked.getType(), clicked.getAmount())});
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Shop.editShop(player, shopName));
        }
    }

    private void handlePlayerShopClick(Player player, ItemStack clicked, String shopName, InventoryClickEvent event) {
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (lastShopAction.containsKey(uuid) && now - lastShopAction.get(uuid) < 50L) {
            return;
        }
        lastShopAction.put(uuid, now);
        double balance = Economy.getBalance(player.getUniqueId());
        ItemMeta meta = clicked.getItemMeta();
        if (meta == null || meta.getLore() == null) {
            return;
        }
        int stackId = meta.getLore().stream().filter(line -> ChatColor.stripColor((String)line).startsWith("ID: ")).mapToInt(line -> Integer.parseInt(ChatColor.stripColor((String)line).replace("ID: ", "").trim())).findFirst().orElse(-1);
        if (stackId == -1) {
            return;
        }
        Shops.ShopItem shopItem = Shops.getShopItems(shopName).get(stackId);
        if (shopItem == null) {
            return;
        }
        if (balance < shopItem.price()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough money!");
            return;
        }
        if (event.isLeftClick()) {
            if (!this.hasInventorySpace(player)) {
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your inventory is full!");
                return;
            }
            ItemStack buyItem = new ItemStack(Objects.requireNonNull(Material.matchMaterial((String)shopItem.itemName())), 1);
            player.getInventory().addItem(new ItemStack[]{buyItem});
            Shops.removeOneFromStack(shopName, stackId);
            Economy.removeBalance(player.getUniqueId(), shopItem.price());
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Bought 1x " + Shop.formatMaterialName(shopItem.itemName()) + " for $" + shopItem.price());
            Log.info(player.getName() + " bought 1x " + Shop.formatMaterialName(shopItem.itemName()) + " from shop " + shopName);
            UUID owner = Shops.getShopOwnerUUID(shopName);
            if (owner != null) {
                Economy.addBalance(owner, shopItem.price());
                Player ownerPlayer = Bukkit.getPlayer((UUID)owner);
                if (ownerPlayer != null) {
                    ownerPlayer.sendMessage(String.valueOf(ChatColor.GREEN) + player.getName() + " has bought 1x " + Shop.formatMaterialName(shopItem.itemName()) + " for $" + shopItem.price());
                }
            }
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> {
                Shops.ShopItem updated = Shops.getShopItems(shopName).get(stackId);
                if (updated == null || updated.amount() <= 0) {
                    event.getInventory().setItem(event.getSlot(), null);
                } else {
                    ItemStack newDisplayItem = new ItemStack(clicked.getType(), updated.amount());
                    ItemMeta itemMeta = clicked.getItemMeta();
                    newDisplayItem.setItemMeta(itemMeta);
                    event.getInventory().setItem(event.getSlot(), newDisplayItem);
                }
                player.updateInventory();
            });
        }
    }

    private void handleServerShopClick(Player player, ItemStack clicked, InventoryClickEvent event) {
        UUID uuid = player.getUniqueId();
        long now = System.currentTimeMillis();
        if (lastShopAction.containsKey(uuid) && now - lastShopAction.get(uuid) < 50L) {
            return;
        }
        lastShopAction.put(uuid, now);
        double balance = Economy.getBalance(player.getUniqueId());
        List shopItems = Config.config.getMapList("shop_items");
        for (Map map : shopItems) {
            for (Object key : map.keySet()) {
                Material mat = Material.matchMaterial((String)key.toString().replace("minecraft:", ""));
                if (mat == null || mat != clicked.getType()) continue;
                Map data = (Map)map.get(key);
                int cost = (Integer)data.get("cost");
                int amount = (Integer)data.get("amount");
                if (event.isLeftClick()) {
                    if (!this.hasInventorySpace(player)) {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "Your inventory is full!");
                        return;
                    }
                    if (balance >= (double)cost) {
                        player.getInventory().addItem(new ItemStack[]{new ItemStack(mat, amount)});
                        Economy.removeBalance(player.getUniqueId(), cost);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Bought " + amount + " " + Shop.formatMaterialName(mat.name()) + " for $" + cost);
                        Log.info("Player " + player.getName() + " bought " + amount + "x " + mat.name() + " for $" + cost);
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough money!");
                    }
                } else if (event.isRightClick()) {
                    if (player.getInventory().containsAtLeast(new ItemStack(mat), amount)) {
                        player.getInventory().removeItem(new ItemStack[]{new ItemStack(clicked.getType(), amount)});
                        Economy.addBalance(player.getUniqueId(), cost);
                        player.sendMessage(String.valueOf(ChatColor.GREEN) + "Sold " + amount + " " + Shop.formatMaterialName(mat.name()) + " for $" + cost);
                        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Shop.openServerShop(player));
                        Log.info("Player " + player.getName() + " sold " + amount + "x " + mat.name() + " for $" + cost);
                    } else {
                        player.sendMessage(String.valueOf(ChatColor.RED) + "You don't have enough of that item!");
                        return;
                    }
                }
                return;
            }
        }
    }

    private boolean hasInventorySpace(Player player) {
        return player.getInventory().firstEmpty() != -1;
    }

    @EventHandler
    public void onChat(AsyncPlayerChatEvent event) {
        Player player = event.getPlayer();
        PendingEdit edit = pendingEdits.remove(player.getUniqueId());
        if (edit == null) {
            return;
        }
        event.setCancelled(true);
        try {
            double price = Double.parseDouble(event.getMessage());
            if (price < 0.0) {
                throw new NumberFormatException();
            }
            Shops.setItemPrice(edit.shopName, edit.stackId, price);
            player.sendMessage(String.valueOf(ChatColor.GREEN) + "Set price to $" + price);
        }
        catch (NumberFormatException e) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Invalid price. Must be positive number.");
        }
        Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> Shop.editShop(player, edit.shopName));
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("shop") || !Config.config.getBoolean("enable_shop")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (Shop.hasPermission(sender, false)) {
                completions.addAll(Arrays.asList("create", "edit", "delete"));
            }
            completions.add("view");
            return completions;
        }
        if (args.length == 2 && sender instanceof Player) {
            Player player = (Player)sender;
            Map<String, UUID> allShops = Shops.getAllShops();
            String partial = args[1].toLowerCase();
            for (Map.Entry<String, UUID> entry : allShops.entrySet()) {
                String shopName = entry.getKey();
                UUID owner = entry.getValue();
                if ((args[0].equalsIgnoreCase("edit") || args[0].equalsIgnoreCase("delete")) && (owner.equals(player.getUniqueId()) || player.isOp())) {
                    if (!shopName.toLowerCase().startsWith(partial)) continue;
                    completions.add(shopName);
                    continue;
                }
                if (!args[0].equalsIgnoreCase("view") || !shopName.toLowerCase().startsWith(partial)) continue;
                completions.add(shopName);
            }
        }
        return completions;
    }

    private static class PendingEdit {
        String shopName;
        int stackId;

        PendingEdit(String shopName, int stackId) {
            this.shopName = shopName;
            this.stackId = stackId;
        }
    }
}

