/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.databases;

import dev.xdpxi.xdsutils.Main;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class Shops {
    private static Connection connection;

    public static void init() {
        try {
            File dbFile = new File(Main.getInstance().getDataFolder(), "shops.db");
            if (!dbFile.getParentFile().exists()) {
                dbFile.getParentFile().mkdirs();
            }
            connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            try (Statement stmt = connection.createStatement();){
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS shop_registry (shop_name TEXT PRIMARY KEY,owner_uuid TEXT NOT NULL);");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void createShop(String shopName, UUID ownerUuid) {
        if (connection == null) {
            Shops.init();
        }
        try (Statement stmt = connection.createStatement();){
            String safeTableName = Shops.sanitizeName(shopName);
            stmt.executeUpdate("CREATE TABLE IF NOT EXISTS shop_" + safeTableName + " (stack_id INTEGER PRIMARY KEY AUTOINCREMENT,item TEXT NOT NULL,amount INTEGER NOT NULL,price REAL NOT NULL);");
            String sql = "INSERT OR IGNORE INTO shop_registry (shop_name, owner_uuid) VALUES (?, ?)";
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                ps.setString(1, safeTableName);
                ps.setString(2, ownerUuid.toString());
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void addItem(String shopName, String item, int amount, double price) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Shops.sanitizeName(shopName);
        String sql = "INSERT INTO shop_" + safeTableName + " (item, amount, price) VALUES (?, ?, ?)";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, item);
            ps.setInt(2, amount);
            ps.setDouble(3, price);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void removeOneFromStack(String shopName, int stackId) {
        PreparedStatement ps;
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Shops.sanitizeName(shopName);
        try {
            ps = connection.prepareStatement("UPDATE shop_" + safeTableName + " SET amount = amount - 1 WHERE stack_id = ?");
            try {
                ps.setInt(1, stackId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        try {
            ps = connection.prepareStatement("DELETE FROM shop_" + safeTableName + " WHERE stack_id = ? AND amount <= 0");
            try {
                ps.setInt(1, stackId);
                ps.executeUpdate();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void setItemPrice(String shopName, int stackId, double price) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Shops.sanitizeName(shopName);
        String sql = "UPDATE shop_" + safeTableName + " SET price = ? WHERE stack_id = ?";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setDouble(1, price);
            ps.setInt(2, stackId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteItem(String shopName, int stackId) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Shops.sanitizeName(shopName);
        String sql = "DELETE FROM shop_" + safeTableName + " WHERE stack_id = ?";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setInt(1, stackId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static Map<Integer, ShopItem> getShopItems(String shopName) {
        if (connection == null) {
            Shops.init();
        }
        LinkedHashMap<Integer, ShopItem> items = new LinkedHashMap<Integer, ShopItem>();
        String safeTableName = Shops.sanitizeName(shopName);
        String sql = "SELECT stack_id, item, amount, price FROM shop_" + safeTableName;
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                items.put(rs.getInt("stack_id"), new ShopItem(rs.getString("item"), rs.getInt("amount"), rs.getDouble("price")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return items;
    }

    public static Map<String, UUID> getAllShops() {
        if (connection == null) {
            Shops.init();
        }
        LinkedHashMap<String, UUID> shops = new LinkedHashMap<String, UUID>();
        String sql = "SELECT shop_name, owner_uuid FROM shop_registry";
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                shops.put(rs.getString("shop_name"), UUID.fromString(rs.getString("owner_uuid")));
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return shops;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static UUID getShopOwnerUUID(String shopName) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Shops.sanitizeName(shopName);
        String sql = "SELECT owner_uuid FROM shop_registry WHERE shop_name = ?";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, safeTableName);
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                UUID uUID = UUID.fromString(rs.getString("owner_uuid"));
                return uUID;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    private static String sanitizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
    }

    public static void deleteShop(String shopName) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Shops.sanitizeName(shopName);
        try (Statement stmt = connection.createStatement();){
            stmt.executeUpdate("DROP TABLE IF EXISTS shop_" + safeTableName);
            String sql = "DELETE FROM shop_registry WHERE shop_name = ?";
            try (PreparedStatement ps = connection.prepareStatement(sql);){
                ps.setString(1, safeTableName);
                ps.executeUpdate();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void close() {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public record ShopItem(String itemName, int amount, double price) {
    }
}

