/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.sun.management.OperatingSystemMXBean;
import com.sun.net.httpserver.HttpServer;
import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.management.ManagementFactory;
import java.lang.reflect.Method;
import java.net.InetSocketAddress;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;

public class WebServer {
    private static final Object LOCK = new Object();
    private static final Charset UTF8 = StandardCharsets.UTF_8;
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();
    private static HttpServer server;
    private static boolean running;
    private static volatile byte[] cachedIndexHtml;
    private static volatile String cachedApiJson;
    private static Method tpsMethod;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void startAsync() {
        Object object = LOCK;
        synchronized (object) {
            if (running) {
                Log.warn("WebServer is already starting or running!");
                return;
            }
            running = true;
        }
        new Thread(() -> {
            Object object;
            try {
                WebServer.start();
                object = LOCK;
            }
            catch (IOException e) {
                Object object2;
                try {
                    Log.error("Failed to start WebServer: " + String.valueOf(e));
                    object2 = LOCK;
                }
                catch (Throwable throwable) {
                    Object object3 = LOCK;
                    synchronized (object3) {
                        running = server != null;
                    }
                    throw throwable;
                }
                synchronized (object2) {
                    running = server != null;
                }
            }
            synchronized (object) {
                running = server != null;
            }
        }, "WebServer-Thread").start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void start() throws IOException {
        Object object = LOCK;
        synchronized (object) {
            int basePort;
            if (server != null) {
                Log.warn("WebServer is already running!");
                return;
            }
            int port = basePort = Config.config.getInt("port");
            boolean bound = false;
            while (!bound && port < 65535) {
                try {
                    server = HttpServer.create(new InetSocketAddress(port), 0);
                    bound = true;
                }
                catch (IOException e) {
                    Log.warn("Port " + port + " is in use, trying " + (port + 1));
                    ++port;
                }
            }
            if (!bound) {
                Log.error("No available ports from " + basePort + " to 65535.");
                server = null;
                return;
            }
            Log.info("WebServer started at http://localhost:" + port);
            WebServer.registerContexts(server);
            int threads = Math.max(4, Runtime.getRuntime().availableProcessors());
            server.setExecutor(Executors.newFixedThreadPool(threads));
            server.start();
            WebServer.startMetricsUpdater();
        }
    }

    private static void registerContexts(HttpServer srv) {
        try (InputStream is = WebServer.class.getResourceAsStream("/index.html");){
            if (is != null) {
                cachedIndexHtml = is.readAllBytes();
            } else {
                Log.warn("index.html not found in resources!");
            }
        }
        catch (IOException e) {
            Log.error("Failed to cache index.html: " + e.getMessage());
        }
        srv.createContext("/", exchange -> {
            if (cachedIndexHtml == null) {
                String error = "index.html not found!";
                exchange.sendResponseHeaders(404, error.length());
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(error.getBytes(UTF8));
                }
                return;
            }
            exchange.getResponseHeaders().add("Content-Type", "text/html; charset=utf-8");
            exchange.getResponseHeaders().add("Connection", "keep-alive");
            exchange.sendResponseHeaders(200, cachedIndexHtml.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(cachedIndexHtml);
            }
        });
        srv.createContext("/api/", exchange -> {
            exchange.getResponseHeaders().add("Content-Type", "application/json; charset=utf-8");
            exchange.getResponseHeaders().add("Connection", "keep-alive");
            byte[] response = cachedApiJson.getBytes(UTF8);
            exchange.sendResponseHeaders(200, response.length);
            try (OutputStream os = exchange.getResponseBody();){
                os.write(response);
            }
        });
    }

    private static void startMetricsUpdater() {
        Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)Main.getInstance(), () -> {
            try {
                cachedApiJson = WebServer.buildApiJson();
            }
            catch (Exception e) {
                Log.error("Error updating cached API JSON: " + e.getMessage());
            }
        }, 0L, 20L);
    }

    private static String buildApiJson() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        int players = Bukkit.getOnlinePlayers().size();
        int maxPlayers = Bukkit.getMaxPlayers();
        long ramUsed = (Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory()) / 1024L / 1024L;
        long ramMax = Runtime.getRuntime().maxMemory() / 1024L / 1024L;
        double cpuLoad = WebServer.getProcessCpuLoad() * 100.0;
        double tps = WebServer.getTPS();
        double mspt = tps > 0.0 ? 1000.0 / tps : 50.0;
        long uptimeMs = ManagementFactory.getRuntimeMXBean().getUptime();
        String uptime = String.valueOf(TimeUnit.MILLISECONDS.toSeconds(uptimeMs));
        String serverVersion = Bukkit.getVersion();
        List worlds = Bukkit.getWorlds();
        String worldName = worlds.isEmpty() ? "Unknown" : ((World)worlds.get(0)).getName();
        String defaultGameMode = "Unknown";
        try {
            defaultGameMode = Bukkit.getDefaultGameMode().name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        String difficulty = "Unknown";
        try {
            difficulty = worlds.isEmpty() ? "Unknown" : ((World)worlds.get(0)).getDifficulty().name();
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            Main.backupManager.updateTotalBackups();
        }
        catch (Exception exception) {
            // empty catch block
        }
        int backups = Main.backupManager.totalBackups;
        data.put("players", players);
        data.put("max_players", maxPlayers);
        data.put("tps", tps);
        data.put("mspt", mspt);
        data.put("ram_used_mb", ramUsed);
        data.put("ram_max_mb", ramMax);
        data.put("cpu_percent", cpuLoad);
        data.put("uptime", uptime);
        data.put("server_version", serverVersion);
        data.put("world_name", worldName);
        data.put("default_game_mode", defaultGameMode);
        data.put("difficulty", difficulty);
        data.put("backups", backups);
        return GSON.toJson(data);
    }

    public static void stop() {
        if (server != null) {
            server.stop(1);
            Log.info("WebServer stopped gracefully.");
            server = null;
            running = false;
        } else {
            Log.warn("WebServer is not running.");
        }
    }

    private static double getProcessCpuLoad() {
        try {
            OperatingSystemMXBean osBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
            double load = osBean.getProcessCpuLoad();
            if (Double.isNaN(load) || load < 0.0) {
                return 0.0;
            }
            return load;
        }
        catch (Throwable t) {
            return 0.0;
        }
    }

    private static double getTPS() {
        try {
            if (tpsMethod != null) {
                Object object;
                Object[] arr;
                Object tpsObj = tpsMethod.invoke((Object)Bukkit.getServer(), new Object[0]);
                if (tpsObj instanceof double[]) {
                    double[] arr2 = (double[])tpsObj;
                    return arr2[0];
                }
                if (tpsObj instanceof Object[] && (arr = (Object[])tpsObj).length > 0 && (object = arr[0]) instanceof Number) {
                    Number n = (Number)object;
                    return n.doubleValue();
                }
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return 20.0;
    }

    private static String escapeJson(String s) {
        if (s == null) {
            return "";
        }
        return s.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r");
    }

    public static boolean verify(String code) {
        return false;
    }

    static {
        running = false;
        cachedApiJson = "{}";
        try {
            tpsMethod = Bukkit.getServer().getClass().getMethod("getTPS", new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            // empty catch block
        }
    }
}

