/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.databases;

import dev.xdpxi.xdsutils.utils.Database;
import java.sql.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Bounties {
    private static Connection connection;

    public static void init() {
        connection = Database.initDatabase("bounties.db", "CREATE TABLE IF NOT EXISTS bounties (uuid TEXT PRIMARY KEY,bounty REAL DEFAULT 0);");
    }

    public static double getBounty(UUID uuid) {
        if (connection == null) {
            Bounties.init();
        }
        return Database.querySingleValue(connection, "SELECT bounty FROM bounties WHERE uuid = ?", new Object[]{uuid.toString()}, "bounty", 0.0, Double.class);
    }

    public static void setBounty(UUID uuid, double newBounty) {
        if (connection == null) {
            Bounties.init();
        }
        Database.upsert(connection, "bounties", "uuid", "bounty", uuid.toString(), newBounty);
    }

    public static void addBounty(UUID uuid, double amount) {
        Bounties.setBounty(uuid, Bounties.getBounty(uuid) + amount);
    }

    public static void removeBounty(UUID uuid, double amount) {
        Bounties.setBounty(uuid, Math.max(0.0, Bounties.getBounty(uuid) - amount));
    }

    public static List<Map.Entry<UUID, Double>> getLeaderboard() {
        if (connection == null) {
            Bounties.init();
        }
        ArrayList<Map.Entry<UUID, Double>> leaderboard = new ArrayList<Map.Entry<UUID, Double>>();
        Database.executeQuery(connection, "SELECT uuid, bounty FROM bounties ORDER BY bounty DESC", rs -> {
            try {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                double bounty = rs.getDouble("bounty");
                leaderboard.add(new AbstractMap.SimpleEntry<UUID, Double>(uuid, bounty));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return leaderboard;
    }

    public static void close() {
        Database.closeConnection(connection);
    }
}

