/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.databases;

import dev.xdpxi.xdsutils.utils.Database;
import java.sql.Connection;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Economy {
    private static Connection connection;

    public static void init() {
        connection = Database.initDatabase("economy.db", "CREATE TABLE IF NOT EXISTS balances (uuid TEXT PRIMARY KEY,balance REAL DEFAULT 0);");
    }

    public static double getBalance(UUID uuid) {
        if (connection == null) {
            Economy.init();
        }
        return Database.querySingleValue(connection, "SELECT balance FROM balances WHERE uuid = ?", new Object[]{uuid.toString()}, "balance", 0.0, Double.class);
    }

    public static void setBalance(UUID uuid, double newBalance) {
        if (connection == null) {
            Economy.init();
        }
        Database.upsert(connection, "balances", "uuid", "balance", uuid.toString(), newBalance);
    }

    public static void addBalance(UUID uuid, double amount) {
        Economy.setBalance(uuid, Economy.getBalance(uuid) + amount);
    }

    public static void removeBalance(UUID uuid, double amount) {
        Economy.setBalance(uuid, Math.max(0.0, Economy.getBalance(uuid) - amount));
    }

    public static List<Map.Entry<UUID, Double>> getLeaderboard() {
        if (connection == null) {
            Economy.init();
        }
        ArrayList<Map.Entry<UUID, Double>> leaderboard = new ArrayList<Map.Entry<UUID, Double>>();
        Database.executeQuery(connection, "SELECT uuid, balance FROM balances ORDER BY balance DESC", rs -> {
            try {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                double balance = rs.getDouble("balance");
                leaderboard.add(new AbstractMap.SimpleEntry<UUID, Double>(uuid, balance));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return leaderboard;
    }

    public static void close() {
        Database.closeConnection(connection);
    }
}

