/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.databases;

import dev.xdpxi.xdsutils.utils.Database;
import java.sql.Connection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.UUID;

public class Shops {
    private static Connection connection;

    public static void init() {
        connection = Database.initDatabase("shops.db", "CREATE TABLE IF NOT EXISTS shop_registry (shop_name TEXT PRIMARY KEY,owner_uuid TEXT NOT NULL);");
    }

    public static void createShop(String shopName, UUID ownerUuid) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Database.sanitizeName(shopName);
        String createTableSQL = "CREATE TABLE IF NOT EXISTS shop_" + safeTableName + " (stack_id INTEGER PRIMARY KEY AUTOINCREMENT,item TEXT NOT NULL,amount INTEGER NOT NULL,price REAL NOT NULL);";
        Database.executeUpdate(connection, createTableSQL, new Object[0]);
        Database.executeUpdate(connection, "INSERT OR IGNORE INTO shop_registry (shop_name, owner_uuid) VALUES (?, ?)", safeTableName, ownerUuid.toString());
    }

    public static void addItem(String shopName, String item, int amount, double price) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Database.sanitizeName(shopName);
        Database.executeUpdate(connection, "INSERT INTO shop_" + safeTableName + " (item, amount, price) VALUES (?, ?, ?)", item, amount, price);
    }

    public static void removeOneFromStack(String shopName, int stackId) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Database.sanitizeName(shopName);
        Database.executeUpdate(connection, "UPDATE shop_" + safeTableName + " SET amount = amount - 1 WHERE stack_id = ?", stackId);
        Database.executeUpdate(connection, "DELETE FROM shop_" + safeTableName + " WHERE stack_id = ? AND amount <= 0", stackId);
    }

    public static void setItemPrice(String shopName, int stackId, double price) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Database.sanitizeName(shopName);
        Database.executeUpdate(connection, "UPDATE shop_" + safeTableName + " SET price = ? WHERE stack_id = ?", price, stackId);
    }

    public static void deleteItem(String shopName, int stackId) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Database.sanitizeName(shopName);
        Database.executeUpdate(connection, "DELETE FROM shop_" + safeTableName + " WHERE stack_id = ?", stackId);
    }

    public static Map<Integer, ShopItem> getShopItems(String shopName) {
        if (connection == null) {
            Shops.init();
        }
        LinkedHashMap<Integer, ShopItem> items = new LinkedHashMap<Integer, ShopItem>();
        String safeTableName = Database.sanitizeName(shopName);
        Database.executeQuery(connection, "SELECT stack_id, item, amount, price FROM shop_" + safeTableName, rs -> {
            try {
                items.put(rs.getInt("stack_id"), new ShopItem(rs.getString("item"), rs.getInt("amount"), rs.getDouble("price")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return items;
    }

    public static Map<String, UUID> getAllShops() {
        if (connection == null) {
            Shops.init();
        }
        LinkedHashMap<String, UUID> shops = new LinkedHashMap<String, UUID>();
        Database.executeQuery(connection, "SELECT shop_name, owner_uuid FROM shop_registry", rs -> {
            try {
                shops.put(rs.getString("shop_name"), UUID.fromString(rs.getString("owner_uuid")));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        });
        return shops;
    }

    public static UUID getShopOwnerUUID(String shopName) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Database.sanitizeName(shopName);
        String ownerUuidStr = Database.querySingleValue(connection, "SELECT owner_uuid FROM shop_registry WHERE shop_name = ?", new Object[]{safeTableName}, "owner_uuid", null, String.class);
        return ownerUuidStr != null ? UUID.fromString(ownerUuidStr) : null;
    }

    public static void deleteShop(String shopName) {
        if (connection == null) {
            Shops.init();
        }
        String safeTableName = Database.sanitizeName(shopName);
        Database.executeUpdate(connection, "DROP TABLE IF EXISTS shop_" + safeTableName, new Object[0]);
        Database.executeUpdate(connection, "DELETE FROM shop_registry WHERE shop_name = ?", safeTableName);
    }

    public static void close() {
        Database.closeConnection(connection);
    }

    public record ShopItem(String itemName, int amount, double price) {
    }
}

