/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.listeners;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Color;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class PlayerChatListener
implements Listener {
    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        String format;
        Player player = event.getPlayer();
        String playerName = player.getName();
        String playerMessage = event.getMessage();
        if (Main.chatDisabled) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "Chat is currently disabled!");
            return;
        }
        if (Main.mutedPlayers.contains(playerName.toLowerCase())) {
            event.setCancelled(true);
            player.sendMessage(String.valueOf(ChatColor.RED) + "You are muted and cannot chat!");
            return;
        }
        boolean chatCensoringEnabled = Config.config.getBoolean("enable_chat_censoring");
        if (chatCensoringEnabled) {
            ArrayList<CallSite> regexPatterns = new ArrayList<CallSite>();
            List words = Config.config.getStringList("censored_words");
            for (String word : words) {
                regexPatterns.add((CallSite)((Object)("\\b" + Pattern.quote(word) + "\\b")));
            }
            List patterns = Config.config.getStringList("censor_regex_patterns");
            regexPatterns.addAll(patterns);
            int censorMethod = Config.config.getInt("censor_method");
            boolean shouldCancel = false;
            for (String string : regexPatterns) {
                Pattern pattern = Pattern.compile(string, 2);
                Matcher matcher = pattern.matcher(playerMessage);
                if (!matcher.find()) continue;
                Log.warn("Player " + playerName + " tried to send a message containing a censored word: " + string);
                player.sendMessage(String.valueOf(ChatColor.RED) + "Your message was censored!");
                switch (censorMethod) {
                    case 1: {
                        playerMessage = matcher.replaceAll(match -> "*".repeat(match.group().length()));
                        break;
                    }
                    case 2: {
                        playerMessage = matcher.replaceAll("");
                        break;
                    }
                    case 3: {
                        shouldCancel = true;
                    }
                }
            }
            if (shouldCancel) {
                event.setCancelled(true);
                return;
            }
        }
        event.setMessage(playerMessage);
        boolean customFormatEnabled = Config.config.getBoolean("enable_custom_message_format");
        if (customFormatEnabled && (format = Color.parse(Config.config.getString("custom_message_format"))) != null) {
            format = format.replace("%player%", "%s").replace("%message%", "%s");
            event.setFormat(format);
        }
    }
}

