/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.listeners;

import dev.xdpxi.xdsutils.databases.Bounties;
import dev.xdpxi.xdsutils.databases.Economy;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.projectiles.ProjectileSource;
import org.jetbrains.annotations.Nullable;

public class PlayerDeathListener
implements Listener {
    @Nullable
    private static Player getPlayer(Player victim) {
        Projectile projectile;
        ProjectileSource projectileSource;
        Entity damageSource;
        Player killer = null;
        EntityDamageEvent entityDamageEvent = victim.getLastDamageCause();
        if (entityDamageEvent instanceof EntityDamageByEntityEvent) {
            EntityDamageByEntityEvent entityEvent = (EntityDamageByEntityEvent)entityDamageEvent;
            v0 = entityEvent.getDamager();
        } else {
            v0 = damageSource = null;
        }
        if (damageSource instanceof Player) {
            killer = (Player)damageSource;
        } else if (damageSource instanceof Projectile && (projectileSource = (projectile = (Projectile)damageSource).getShooter()) instanceof Player) {
            Player shooter;
            killer = shooter = (Player)projectileSource;
        }
        return killer;
    }

    @EventHandler
    public void onPlayerDeath(PlayerDeathEvent event) {
        Player victim = event.getEntity();
        Player killer = PlayerDeathListener.getPlayer(victim);
        if (killer != null && !killer.equals((Object)victim)) {
            victim.sendMessage(String.valueOf(ChatColor.RED) + "You were killed by " + String.valueOf(ChatColor.DARK_RED) + killer.getName() + String.valueOf(ChatColor.RED) + "!");
            killer.sendMessage(String.valueOf(ChatColor.RED) + "You killed " + String.valueOf(ChatColor.DARK_RED) + victim.getName() + String.valueOf(ChatColor.RED) + "!");
            if (Bounties.getBounty(victim.getUniqueId()) > 500.0) {
                double reward = Bounties.getBounty(victim.getUniqueId()) / 2.0;
                Bounties.addBounty(killer.getUniqueId(), reward);
                Economy.addBalance(killer.getUniqueId(), reward);
                killer.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your bounty has increased by " + String.valueOf(ChatColor.GOLD) + "$" + reward + String.valueOf(ChatColor.YELLOW) + " and you gained " + String.valueOf(ChatColor.GOLD) + "$" + reward + String.valueOf(ChatColor.YELLOW) + "!");
                Log.info("Player " + killer.getName() + " killed player " + victim.getName() + " with a bounty of " + Bounties.getBounty(victim.getUniqueId()) + " their bounty has increased to " + Bounties.getBounty(killer.getUniqueId()) + "!");
            } else {
                Bounties.addBounty(killer.getUniqueId(), Config.config.getDouble("kill_reward"));
                killer.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your bounty has increased by " + String.valueOf(ChatColor.GOLD) + "$" + Config.config.getDouble("kill_reward") + String.valueOf(ChatColor.YELLOW) + ".");
                Log.info("Player " + killer.getName() + " killed player " + victim.getName() + " their bounty has increased to " + Bounties.getBounty(killer.getUniqueId()) + "!");
            }
            Bounties.setBounty(victim.getUniqueId(), 0.0);
        }
    }
}

