/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.utils;

import dev.xdpxi.xdsutils.Main;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.function.Consumer;

public class Database {
    public static Connection initDatabase(String dbName, String createTableSQL) {
        try {
            File dbFile;
            File dbFolder = new File(Main.getInstance().getDataFolder(), "databases");
            if (!dbFolder.exists()) {
                dbFolder.mkdirs();
            }
            if (!(dbFile = new File(dbFolder, dbName)).getParentFile().exists()) {
                dbFile.getParentFile().mkdirs();
            }
            Connection conn = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            try (Statement stmt = conn.createStatement();){
                stmt.executeUpdate(createTableSQL);
            }
            return conn;
        }
        catch (SQLException e) {
            e.printStackTrace();
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static <T> T querySingleValue(Connection conn, String sql, Object[] params, String columnName, T defaultValue, Class<T> type) {
        if (conn == null) {
            return defaultValue;
        }
        try (PreparedStatement ps = conn.prepareStatement(sql);){
            Database.bindParameters(ps, params);
            ResultSet rs = ps.executeQuery();
            if (!rs.next()) return defaultValue;
            if (type == Double.class) {
                T t = type.cast(rs.getDouble(columnName));
                return t;
            }
            if (type == Integer.class) {
                T t = type.cast(rs.getInt(columnName));
                return t;
            }
            if (type != String.class) return defaultValue;
            T t = type.cast(rs.getString(columnName));
            return t;
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return defaultValue;
    }

    public static boolean executeUpdate(Connection conn, String sql, Object ... params) {
        boolean bl;
        block9: {
            if (conn == null) {
                return false;
            }
            PreparedStatement ps = conn.prepareStatement(sql);
            try {
                Database.bindParameters(ps, params);
                ps.executeUpdate();
                bl = true;
                if (ps == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (ps != null) {
                        try {
                            ps.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    e.printStackTrace();
                    return false;
                }
            }
            ps.close();
        }
        return bl;
    }

    public static void executeQuery(Connection conn, String sql, Consumer<ResultSet> rowHandler) {
        if (conn == null) {
            return;
        }
        try (Statement stmt = conn.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                rowHandler.accept(rs);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void bindParameters(PreparedStatement ps, Object ... params) throws SQLException {
        for (int i = 0; i < params.length; ++i) {
            Object param = params[i];
            if (param instanceof String) {
                ps.setString(i + 1, (String)param);
                continue;
            }
            if (param instanceof Integer) {
                ps.setInt(i + 1, (Integer)param);
                continue;
            }
            if (param instanceof Double) {
                ps.setDouble(i + 1, (Double)param);
                continue;
            }
            if (!(param instanceof Long)) continue;
            ps.setLong(i + 1, (Long)param);
        }
    }

    public static void closeConnection(Connection conn) {
        try {
            if (conn != null && !conn.isClosed()) {
                conn.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static boolean upsert(Connection conn, String table, String keyColumn, String valueColumn, String keyValue, double newValue) {
        String sql = String.format("INSERT INTO %s (%s, %s) VALUES (?, ?) ON CONFLICT(%s) DO UPDATE SET %s = excluded.%s", table, keyColumn, valueColumn, keyColumn, valueColumn, valueColumn);
        return Database.executeUpdate(conn, sql, keyValue, newValue);
    }

    public static String sanitizeName(String name) {
        return name.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase();
    }
}

