/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.databases;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Economy {
    private static Connection connection;

    public static void init() {
        try {
            File dbFile = new File(Main.getInstance().getDataFolder(), "economy.db");
            if (!dbFile.getParentFile().exists()) {
                dbFile.getParentFile().mkdirs();
            }
            connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            try (Statement stmt = connection.createStatement();){
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS balances (uuid TEXT PRIMARY KEY,balance REAL DEFAULT 0);");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double getBalance(UUID uuid) {
        PreparedStatement ps;
        block8: {
            if (connection == null) {
                Economy.init();
            }
            String sql = "SELECT balance FROM balances WHERE uuid = ?";
            try {
                double d;
                ps = connection.prepareStatement(sql);
                try {
                    ps.setString(1, uuid.toString());
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) break block8;
                    d = rs.getDouble("balance");
                    if (ps == null) return d;
                }
                catch (Throwable throwable) {
                    if (ps == null) throw throwable;
                    try {
                        ps.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ps.close();
                return d;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return 0.0;
            }
        }
        if (ps == null) return 0.0;
        ps.close();
        return 0.0;
    }

    public static void setBalance(UUID uuid, double newBalance) {
        if (connection == null) {
            Economy.init();
        }
        String sql = "INSERT INTO balances (uuid, balance) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET balance = excluded.balance;";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setDouble(2, newBalance);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void addBalance(UUID uuid, double amount) {
        Economy.setBalance(uuid, Economy.getBalance(uuid) + amount);
    }

    public static void removeBalance(UUID uuid, double amount) {
        Economy.setBalance(uuid, Math.max(0.0, Economy.getBalance(uuid) - amount));
    }

    public static List<Map.Entry<UUID, Double>> getLeaderboard() {
        if (connection == null) {
            Economy.init();
        }
        ArrayList<Map.Entry<UUID, Double>> leaderboard = new ArrayList<Map.Entry<UUID, Double>>();
        String sql = "SELECT uuid, balance FROM balances ORDER BY balance DESC";
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                double balance = rs.getDouble("balance");
                leaderboard.add(new AbstractMap.SimpleEntry<UUID, Double>(uuid, balance));
            }
        }
        catch (SQLException e) {
            Log.error(e.getMessage());
            e.printStackTrace();
        }
        return leaderboard;
    }

    public static void close() {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

