/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.listeners;

import dev.xdpxi.xdsutils.utils.Color;
import dev.xdpxi.xdsutils.utils.Config;
import dev.xdpxi.xdsutils.utils.Log;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.bukkit.ChatColor;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.player.AsyncPlayerChatEvent;

public class ChatListener
implements Listener {
    @EventHandler
    public void onPlayerChat(AsyncPlayerChatEvent event) {
        if (!Config.config.getBoolean("enable_messages")) {
            return;
        }
        String playerName = event.getPlayer().getName();
        String playerMessage = event.getMessage();
        boolean customFormatEnabled = Config.config.getBoolean("enable_custom_message_format");
        boolean chatCensoringEnabled = Config.config.getBoolean("enable_chat_censoring");
        if (chatCensoringEnabled) {
            List regexPatterns = Config.config.getStringList("censor_regex_patterns");
            int censorMethod = Config.config.getInt("censor_method");
            boolean shouldCancel = false;
            for (String patternStr : regexPatterns) {
                Pattern pattern = Pattern.compile(patternStr, 2);
                Matcher matcher = pattern.matcher(playerMessage);
                if (!matcher.find()) continue;
                Log.warn("Player " + playerName + " tried to send a message containing a censored word: " + patternStr);
                event.getPlayer().sendMessage(String.valueOf(ChatColor.RED) + "Your message was censored!");
                switch (censorMethod) {
                    case 1: {
                        playerMessage = matcher.replaceAll(match -> "*".repeat(match.group().length()));
                        break;
                    }
                    case 2: {
                        playerMessage = matcher.replaceAll("");
                        break;
                    }
                    case 3: {
                        shouldCancel = true;
                    }
                }
            }
            if (shouldCancel) {
                event.setCancelled(true);
                return;
            }
        }
        String format = Color.parse(Config.config.getString("custom_message_format"));
        assert (format != null);
        format = format.replace("%player%", "%s").replace("%message%", "%s");
        if (customFormatEnabled) {
            event.setFormat(format);
            event.setMessage(playerMessage);
        }
    }
}

