/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import dev.xdpxi.xdsutils.utils.Config;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Backup {
    private final JavaPlugin plugin;
    private final File backupsRoot;
    public final AtomicBoolean isRunning = new AtomicBoolean(false);
    private boolean enabled;
    private List<String> worlds;
    private final SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd_HH-mm-ss");
    private int maxBackups;
    private int compressionLevel;
    public int totalBackups = 0;
    private int backupTaskId = -1;
    private int maxSizeMB;
    private int intervalMinutes;

    public Backup(JavaPlugin pluginInstance) {
        this.plugin = pluginInstance;
        this.backupsRoot = new File(this.plugin.getDataFolder(), "backups");
    }

    public void reload() {
        this.enabled = Config.config.getBoolean("enable_backups", true);
        this.worlds = Config.config.getStringList("worlds");
        this.maxSizeMB = Config.config.getInt("max_size", 1024);
        this.maxBackups = Config.config.getInt("max_backups", 10);
        this.compressionLevel = Config.config.getInt("compression_level", 9);
        this.intervalMinutes = Config.config.getInt("backup_interval", 120);
        this.updateTotalBackups();
    }

    public void startBackups() {
        if (!this.enabled) {
            return;
        }
        if (!this.backupsRoot.exists()) {
            this.backupsRoot.mkdirs();
        }
        this.backupTaskId = Bukkit.getScheduler().runTaskTimerAsynchronously((Plugin)this.plugin, this::createAllWorldBackups, 0L, (long)this.intervalMinutes * 60L * 20L).getTaskId();
        Bukkit.getLogger().info("[Backup] Backup schedule started.");
    }

    public void stopBackups() {
        if (this.backupTaskId != -1) {
            Bukkit.getScheduler().cancelTask(this.backupTaskId);
            this.backupTaskId = -1;
            Bukkit.getLogger().info("[Backup] Backup schedule stopped.");
        }
    }

    public void runBackupNow() {
        if (this.isRunning.get()) {
            Bukkit.getLogger().info("[Backup] A backup is already running. Skipping manual backup.");
            return;
        }
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)this.plugin, this::createAllWorldBackups);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createAllWorldBackups() {
        if (!this.isRunning.compareAndSet(false, true)) {
            return;
        }
        try {
            for (String worldName : this.worlds) {
                File worldFolder = new File(worldName);
                if (!worldFolder.exists()) {
                    this.plugin.getLogger().warning("[Backup] World not found: " + worldName);
                    continue;
                }
                File worldBackupFolder = new File(this.backupsRoot, worldName);
                if (!worldBackupFolder.exists()) {
                    worldBackupFolder.mkdirs();
                }
                String timestamp = this.dateFormat.format(new Date());
                File tempBackup = new File(worldBackupFolder, "backup_" + timestamp + ".zip.tmp");
                File finalBackup = new File(worldBackupFolder, "backup_" + timestamp + ".zip");
                this.plugin.getLogger().info("[Backup] Creating backup for world '" + worldName + "'...");
                try (ZipOutputStream zos = new ZipOutputStream(new FileOutputStream(tempBackup));){
                    zos.setLevel(this.compressionLevel);
                    this.zipFolder(worldFolder.toPath(), worldFolder.getName(), zos);
                }
                Files.move(tempBackup.toPath(), finalBackup.toPath(), StandardCopyOption.ATOMIC_MOVE);
                this.plugin.getLogger().info("[Backup] Backup created: " + finalBackup.getName());
                this.enforceBackupLimits(worldBackupFolder);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("[Backup] Failed to create backup!");
            e.printStackTrace();
        }
        finally {
            this.isRunning.set(false);
            this.updateTotalBackups();
        }
    }

    private void zipFolder(Path folder, String parentFolder, ZipOutputStream zos) throws IOException {
        List<Path> paths = Files.walk(folder, new FileVisitOption[0]).toList();
        int counter = 0;
        for (Path path : paths) {
            File file = path.toFile();
            if (file.getName().equals("session.lock")) continue;
            String zipEntryName = parentFolder + File.separator + String.valueOf(folder.relativize(path));
            if (file.isDirectory() && !zipEntryName.endsWith("/")) {
                zipEntryName = zipEntryName + "/";
            }
            try {
                zos.putNextEntry(new ZipEntry(zipEntryName));
                if (!file.isDirectory()) {
                    Files.copy(path, zos);
                }
                zos.closeEntry();
            }
            catch (IOException e) {
                this.plugin.getLogger().warning("[Backup] Could not copy file: " + file.getAbsolutePath());
            }
            if (++counter % 100 != 0) continue;
            this.plugin.getLogger().info("[Backup] Processed " + counter + " files for world " + parentFolder);
        }
    }

    private void enforceBackupLimits(File worldBackupFolder) {
        File[] files = worldBackupFolder.listFiles((dir, name) -> name.endsWith(".zip"));
        if (files == null) {
            return;
        }
        Arrays.sort(files, Comparator.comparingLong(File::lastModified));
        long totalSizeMB = Arrays.stream(files).mapToLong(f -> f.length() / 0x100000L).sum();
        for (File file : files) {
            if (files.length <= this.maxBackups && totalSizeMB <= (long)this.maxSizeMB) break;
            totalSizeMB -= file.length() / 0x100000L;
            if (file.delete()) continue;
            this.plugin.getLogger().warning("[Backup] Could not delete old backup: " + file.getName());
        }
    }

    public void updateTotalBackups() {
        this.totalBackups = 0;
        for (String worldName : this.worlds) {
            File[] files;
            File worldBackupFolder = new File(this.backupsRoot, worldName);
            if (!worldBackupFolder.exists() || (files = worldBackupFolder.listFiles((dir, name) -> name.endsWith(".zip"))) == null) continue;
            this.totalBackups += files.length;
        }
    }
}

