/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.shaded.nanohttpd.util;

import dev.xdpxi.shaded.nanohttpd.NanoHTTPD;
import java.io.IOException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ServerRunner {
    private static final Logger LOG = Logger.getLogger(ServerRunner.class.getName());

    public static void executeInstance(NanoHTTPD server) {
        try {
            server.start(5000, false);
        }
        catch (IOException ioe) {
            System.err.println("Couldn't start server:\n" + ioe);
            System.exit(-1);
        }
        System.out.println("Server started, Hit Enter to stop.\n");
        try {
            System.in.read();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        server.stop();
        System.out.println("Server stopped.\n");
    }

    public static <T extends NanoHTTPD> void run(Class<T> serverClass) {
        try {
            ServerRunner.executeInstance((NanoHTTPD)serverClass.newInstance());
        }
        catch (Exception e) {
            LOG.log(Level.SEVERE, "Cound nor create server", e);
        }
    }
}

