/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsUtils;

import dev.xdpxi.xdsUtils.config.Manager;
import dev.xdpxi.xdsUtils.utils.Log;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.bukkit.Bukkit;
import org.bukkit.World;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Backup {
    public static void backupWorldAsync(File worldFolder, JavaPlugin plugin, int compressionLevel) {
        Bukkit.getScheduler().runTaskAsynchronously((Plugin)plugin, () -> {
            if (!worldFolder.exists() || !worldFolder.isDirectory()) {
                Log.warn("World folder does not exist: " + worldFolder.getAbsolutePath());
                return;
            }
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("dd-MM-yyyy_HH-mm");
            String formattedTime = now.format(formatter);
            File backupDir = new File(plugin.getDataFolder(), "backups/" + worldFolder.getName());
            if (!backupDir.exists()) {
                backupDir.mkdirs();
            }
            File zipFile = new File(backupDir, "backup_" + formattedTime + ".zip");
            try {
                List<Path> allFiles = Files.walk(worldFolder.toPath(), new FileVisitOption[0]).filter(path -> Files.isRegularFile(path, new LinkOption[0]) && !path.getFileName().toString().equalsIgnoreCase("session.lock")).toList();
                int totalFiles = allFiles.size();
                int[] filesProcessed = new int[]{0};
                int[] lastLoggedPercent = new int[]{0};
                try (FileOutputStream fos = new FileOutputStream(zipFile);
                     ZipOutputStream zos = new ZipOutputStream(fos);){
                    zos.setLevel(compressionLevel);
                    Log.info("Starting backup of world: " + worldFolder.getName());
                    for (Path file : allFiles) {
                        try {
                            Path relative = worldFolder.toPath().relativize(file);
                            ZipEntry entry = new ZipEntry(relative.toString().replace("\\", "/"));
                            zos.putNextEntry(entry);
                            Files.copy(file, zos);
                            zos.closeEntry();
                        }
                        catch (IOException e) {
                            Log.warn("Failed to zip file: " + String.valueOf(file) + " - " + e.getMessage());
                        }
                        filesProcessed[0] = filesProcessed[0] + 1;
                        int percent = (int)((double)filesProcessed[0] / (double)totalFiles * 100.0);
                        if (percent < lastLoggedPercent[0] + 10 && percent != 100) continue;
                        Log.info(worldFolder.getName() + " backup progress: " + percent + "%");
                        lastLoggedPercent[0] = percent;
                    }
                }
                Log.info("World " + worldFolder.getName() + " backed up to " + zipFile.getPath());
            }
            catch (IOException e) {
                Log.error("Failed to back up world " + worldFolder.getName() + ": " + e.getMessage());
            }
        });
    }

    public static void startBackupTask(JavaPlugin plugin, Manager configManager) {
        int intervalMinutes = configManager.getBackupConfig().getBackupInterval();
        int compressionLevel = configManager.getBackupConfig().getCompressionLevel();
        List<String> worldNames = configManager.getBackupConfig().getWorlds();
        long intervalTicks = (long)intervalMinutes * 60L * 20L;
        Bukkit.getScheduler().runTaskLater((Plugin)plugin, () -> {
            Log.info("Running initial backup after 1 minute...");
            for (String worldName : worldNames) {
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    Log.warn("World not found: " + worldName);
                    continue;
                }
                Backup.backupWorldAsync(world.getWorldFolder(), plugin, compressionLevel);
            }
        }, 1200L);
        Bukkit.getScheduler().runTaskTimer((Plugin)plugin, () -> {
            Log.info("Running scheduled backup...");
            for (String worldName : worldNames) {
                World world = Bukkit.getWorld((String)worldName);
                if (world == null) {
                    Log.warn("World not found: " + worldName);
                    continue;
                }
                Backup.backupWorldAsync(world.getWorldFolder(), plugin, compressionLevel);
            }
        }, intervalTicks, intervalTicks);
    }
}

