/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsUtils;

import dev.xdpxi.xdsUtils.Backup;
import dev.xdpxi.xdsUtils.config.Manager;
import dev.xdpxi.xdsUtils.utils.Log;
import dev.xdpxi.xdsUtils.utils.Metrics;
import dev.xdpxi.xdsUtils.web.WebServer;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Main
extends JavaPlugin {
    private WebServer webServer;

    public void onEnable() {
        Metrics metrics = new Metrics((Plugin)this, 26548);
        this.copyFolderResource();
        Manager configManager = new Manager(this);
        configManager.loadConfigs();
        if (configManager.getMainConfig().isEnabled()) {
            if (configManager.getWebConfig().isEnabled()) {
                try {
                    this.webServer = new WebServer(configManager.getWebConfig().getPort(), this.getDataFolder());
                }
                catch (Exception e) {
                    e.printStackTrace();
                    Log.error("Failed to start webserver!");
                }
            }
            if (configManager.getBackupConfig().isEnabled()) {
                Backup.startBackupTask(this, configManager);
            }
        }
    }

    public void onDisable() {
        if (this.webServer != null) {
            this.webServer.stopServer();
        }
    }

    private void copyFolderResource() {
        File dataFolder = this.getDataFolder();
        if (!dataFolder.exists() && !dataFolder.mkdirs()) {
            Log.error("Failed to create data folder: " + dataFolder.getAbsolutePath());
            return;
        }
        try {
            URL location = ((Object)((Object)this)).getClass().getProtectionDomain().getCodeSource().getLocation();
            if (location == null) {
                Log.error("Could not determine jar location");
                return;
            }
            File jarFile = new File(location.toURI());
            if (!jarFile.isFile() || !jarFile.getName().toLowerCase().endsWith(".jar")) {
                Log.warn("Not running from a JAR file, skipping resource copy");
                return;
            }
            try (JarFile jar = new JarFile(jarFile);){
                Enumeration<JarEntry> checkEntries = jar.entries();
                boolean hasFilesToCopy = false;
                while (checkEntries.hasMoreElements()) {
                    String relativePath;
                    JarEntry entry = checkEntries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("default/") || entry.isDirectory() || (relativePath = name.substring("default/".length())).isEmpty()) continue;
                    File outFile = new File(dataFolder, relativePath);
                    try {
                        if (!outFile.getCanonicalPath().startsWith(dataFolder.getCanonicalPath()) || outFile.exists()) continue;
                        hasFilesToCopy = true;
                    }
                    catch (IOException e) {
                        hasFilesToCopy = true;
                    }
                    break;
                }
                if (!hasFilesToCopy) {
                    Log.info("All files from default/ resource folder already exist, skipping copy operation");
                    return;
                }
                Enumeration<JarEntry> entries = jar.entries();
                int copiedFiles = 0;
                int skippedFiles = 0;
                while (entries.hasMoreElements()) {
                    String relativePath;
                    JarEntry entry = entries.nextElement();
                    String name = entry.getName();
                    if (!name.startsWith("default/") || entry.isDirectory() || (relativePath = name.substring("default/".length())).isEmpty()) continue;
                    File outFile = new File(dataFolder, relativePath);
                    if (!outFile.getCanonicalPath().startsWith(dataFolder.getCanonicalPath())) {
                        Log.warn("Skipping potentially unsafe path: " + relativePath);
                        continue;
                    }
                    if (outFile.exists()) {
                        Log.debug("File already exists, skipping: " + relativePath);
                        ++skippedFiles;
                        continue;
                    }
                    File parentDir = outFile.getParentFile();
                    if (parentDir != null && !parentDir.exists() && !parentDir.mkdirs()) {
                        Log.warn("Failed to create parent directory: " + parentDir.getAbsolutePath());
                        continue;
                    }
                    try {
                        InputStream in = jar.getInputStream(entry);
                        try (FileOutputStream out = new FileOutputStream(outFile);){
                            int bytesRead;
                            byte[] buffer = new byte[8192];
                            while ((bytesRead = in.read(buffer)) != -1) {
                                ((OutputStream)out).write(buffer, 0, bytesRead);
                            }
                            ++copiedFiles;
                            Log.debug("Copied: " + relativePath);
                        }
                        finally {
                            if (in == null) continue;
                            in.close();
                        }
                    }
                    catch (IOException e) {
                        Log.warn("Failed to copy file " + relativePath + ": " + e.getMessage());
                    }
                }
                String message = "Resource copy operation completed: " + copiedFiles + " files copied";
                if (skippedFiles > 0) {
                    message = message + ", " + skippedFiles + " files already existed";
                }
                Log.info(message);
            }
            catch (IOException e) {
                Log.error("Failed to read JAR file: " + e.getMessage());
                e.printStackTrace();
            }
        }
        catch (URISyntaxException e) {
            Log.error("Invalid JAR file URI: " + e.getMessage());
            e.printStackTrace();
        }
    }
}

