/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsUtils.config;

import java.util.Arrays;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;

public class Backup {
    private final boolean enabled;
    private final List<String> worlds;
    private final int maxSize;
    private final int maxBackups;
    private final int compressionLevel;
    private final int backupInterval;

    public Backup(FileConfiguration config) {
        this.enabled = config.getBoolean("enabled", true);
        this.worlds = config.getStringList("worlds");
        this.maxSize = config.getInt("max_size", 1024);
        this.maxBackups = config.getInt("max_backups", 10);
        this.compressionLevel = config.getInt("compression_level", 9);
        this.backupInterval = config.getInt("backup_interval", 60);
        if (this.worlds.isEmpty()) {
            this.worlds.addAll(Arrays.asList("world", "world_nether", "world_the_end"));
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public List<String> getWorlds() {
        return this.worlds;
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getMaxBackups() {
        return this.maxBackups;
    }

    public int getCompressionLevel() {
        return this.compressionLevel;
    }

    public int getBackupInterval() {
        return this.backupInterval;
    }

    public String toString() {
        return "BackupConfig{enabled=" + this.enabled + ", worlds=" + String.valueOf(this.worlds) + ", maxSize=" + this.maxSize + ", maxBackups=" + this.maxBackups + ", compressionLevel=" + this.compressionLevel + ", backupInterval=" + this.backupInterval + "}";
    }
}

