/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsUtils.config;

import dev.xdpxi.xdsUtils.config.Backup;
import dev.xdpxi.xdsUtils.config.Discord;
import dev.xdpxi.xdsUtils.config.Main;
import dev.xdpxi.xdsUtils.config.Web;
import java.io.File;
import java.io.IOException;
import java.util.logging.Logger;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class Manager {
    private final JavaPlugin plugin;
    private final Logger logger;
    private Backup backupConfig;
    private Main mainConfig;
    private Discord discordConfig;
    private Web webConfig;

    public Manager(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void loadConfigs() {
        try {
            this.backupConfig = new Backup(this.loadConfigFile("backup.yml"));
            this.mainConfig = new Main(this.loadConfigFile("config.yml"));
            this.discordConfig = new Discord(this.loadConfigFile("discord.yml"));
            this.webConfig = new Web(this.loadConfigFile("web.yml"));
            this.logger.info("All configuration files loaded successfully");
        }
        catch (Exception e) {
            this.logger.severe("Failed to load configuration files: " + e.getMessage());
            e.printStackTrace();
        }
    }

    public void reloadConfigs() {
        this.logger.info("Reloading configuration files...");
        this.loadConfigs();
    }

    private FileConfiguration loadConfigFile(String fileName) {
        File configFile = new File(this.plugin.getDataFolder(), fileName);
        if (!configFile.exists()) {
            this.logger.warning("Config file " + fileName + " not found, using default values");
            return new YamlConfiguration();
        }
        try {
            YamlConfiguration config = YamlConfiguration.loadConfiguration((File)configFile);
            this.logger.fine("Loaded config file: " + fileName);
            return config;
        }
        catch (Exception e) {
            this.logger.severe("Failed to load config file " + fileName + ": " + e.getMessage());
            return new YamlConfiguration();
        }
    }

    public void saveConfigFile(String fileName, FileConfiguration config) {
        File configFile = new File(this.plugin.getDataFolder(), fileName);
        try {
            config.save(configFile);
            this.logger.fine("Saved config file: " + fileName);
        }
        catch (IOException e) {
            this.logger.severe("Failed to save config file " + fileName + ": " + e.getMessage());
        }
    }

    public Backup getBackupConfig() {
        return this.backupConfig;
    }

    public Main getMainConfig() {
        return this.mainConfig;
    }

    public Discord getDiscordConfig() {
        return this.discordConfig;
    }

    public Web getWebConfig() {
        return this.webConfig;
    }
}

