/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsUtils.web;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import dev.xdpxi.shaded.nanohttpd.NanoHTTPD;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.bukkit.BanList;
import org.bukkit.Bukkit;
import org.bukkit.entity.Player;

public class ApiHandler {
    private static final Pattern BACKUP_PATTERN = Pattern.compile("backup_\\d{1,2}-\\d{1,2}-\\d{4}_\\d{2}-\\d{2}-\\d{2}-full\\.zip");
    private final File webRoot;
    private final File backupsDir;
    private final Gson gson = new GsonBuilder().setPrettyPrinting().create();

    public ApiHandler(File webRoot, File backupsDir) {
        this.webRoot = webRoot;
        this.backupsDir = backupsDir;
    }

    public static Map<String, String> parseBody(NanoHTTPD.IHTTPSession session) throws IOException, NanoHTTPD.ResponseException {
        HashMap<String, String> files = new HashMap<String, String>();
        session.parseBody(files);
        return session.getParms();
    }

    public NanoHTTPD.Response handleApi(NanoHTTPD.IHTTPSession session, String uri) {
        try {
            switch (uri) {
                case "/api/players": {
                    if (session.getMethod() == NanoHTTPD.Method.GET) {
                        return this.listPlayers();
                    }
                    if (session.getMethod() == NanoHTTPD.Method.POST) {
                        return this.handlePlayerAction(session);
                    }
                    break;
                }
                case "/api/backups": {
                    if (session.getMethod() == NanoHTTPD.Method.GET) {
                        return this.listBackups();
                    }
                    if (session.getMethod() == NanoHTTPD.Method.POST) {
                        return this.handleBackupAction(session);
                    }
                    break;
                }
                case "/api/files": {
                    if (session.getMethod() == NanoHTTPD.Method.GET) {
                        return this.listFiles(session);
                    }
                    if (session.getMethod() == NanoHTTPD.Method.POST) {
                        return this.handleFileAction(session);
                    }
                    break;
                }
                case "/api/resources": {
                    if (session.getMethod() == NanoHTTPD.Method.GET) {
                        return this.resources();
                    }
                    break;
                }
                default: {
                    return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "application/json", "{\"error\":\"Unknown API endpoint\"}");
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "application/json", "{\"error\":\"Internal Server Error\"}");
        }
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.METHOD_NOT_ALLOWED, "application/json", "{\"error\":\"Method Not Allowed\"}");
    }

    private NanoHTTPD.Response listPlayers() {
        List players = Bukkit.getOnlinePlayers().stream().map(p -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", p.getName());
            map.put("uuid", p.getUniqueId().toString());
            map.put("op", p.isOp());
            map.put("health", p.getHealth());
            map.put("maxHealth", p.getMaxHealth());
            return map;
        }).collect(Collectors.toList());
        String json = this.gson.toJson(players);
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", json);
    }

    private NanoHTTPD.Response handlePlayerAction(NanoHTTPD.IHTTPSession session) throws Exception {
        Map<String, String> body = ApiHandler.parseBody(session);
        String playerName = body.get("player");
        String action = body.get("action");
        if (playerName == null || action == null) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "application/json", "{\"error\":\"Missing parameters\"}");
        }
        Player player = Bukkit.getPlayerExact((String)playerName);
        if (player == null) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "application/json", "{\"error\":\"Player not online\"}");
        }
        switch (action.toLowerCase()) {
            case "kick": {
                player.kickPlayer("Kicked via Web Interface");
                break;
            }
            case "ban": {
                Bukkit.getBanList((BanList.Type)BanList.Type.NAME).addBan(player.getName(), "Banned via Web Interface", null, null);
                player.kickPlayer("Banned via Web Interface");
                break;
            }
            case "op": {
                player.setOp(true);
                break;
            }
            case "deop": {
                player.setOp(false);
                break;
            }
            default: {
                return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "application/json", "{\"error\":\"Unknown action\"}");
            }
        }
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", "{\"success\":true}");
    }

    private NanoHTTPD.Response listBackups() {
        if (!this.backupsDir.exists()) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "application/json", "{\"error\":\"No backups directory\"}");
        }
        File[] backups = this.backupsDir.listFiles((File dir, String name) -> BACKUP_PATTERN.matcher(name).matches());
        if (backups == null) {
            backups = new File[]{};
        }
        Arrays.sort(backups, Comparator.comparing(File::getName).reversed());
        List backupList = Arrays.stream(backups).map(f -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", f.getName());
            map.put("size", f.length());
            map.put("lastModified", f.lastModified());
            return map;
        }).collect(Collectors.toList());
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", this.gson.toJson(backupList));
    }

    private NanoHTTPD.Response handleBackupAction(NanoHTTPD.IHTTPSession session) throws Exception {
        Map<String, String> body = ApiHandler.parseBody(session);
        String backupName = body.get("backup");
        String action = body.get("action");
        if (backupName == null || action == null) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "application/json", "{\"error\":\"Missing parameters\"}");
        }
        File backupFile = new File(this.backupsDir, backupName);
        if (!backupFile.exists()) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "application/json", "{\"error\":\"Backup not found\"}");
        }
        return switch (action.toLowerCase()) {
            case "delete" -> {
                boolean deleted = backupFile.delete();
                yield NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", "{\"success\":" + deleted + "}");
            }
            case "restore" -> NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", "{\"success\":true, \"message\":\"Restore triggered (not implemented)\"}");
            default -> NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.BAD_REQUEST, "application/json", "{\"error\":\"Unknown action\"}");
        };
    }

    private NanoHTTPD.Response listFiles(NanoHTTPD.IHTTPSession session) throws Exception {
        File baseDir;
        File requested;
        Map<String, List<String>> params = session.getParameters();
        String path = "/";
        if (params.containsKey("path")) {
            path = params.get("path").get(0);
        }
        if (!(requested = new File(baseDir = this.webRoot.getParentFile(), URLDecoder.decode(path, StandardCharsets.UTF_8)).getCanonicalFile()).getPath().startsWith(baseDir.getCanonicalPath())) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.FORBIDDEN, "application/json", "{\"error\":\"Forbidden path\"}");
        }
        if (!requested.exists() || !requested.isDirectory()) {
            return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "application/json", "{\"error\":\"Directory not found\"}");
        }
        File[] files = requested.listFiles();
        if (files == null) {
            files = new File[]{};
        }
        List fileList = Arrays.stream(files).map(f -> {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("name", f.getName());
            map.put("directory", f.isDirectory());
            map.put("size", f.length());
            map.put("lastModified", f.lastModified());
            return map;
        }).collect(Collectors.toList());
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", this.gson.toJson(fileList));
    }

    private NanoHTTPD.Response handleFileAction(NanoHTTPD.IHTTPSession session) {
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_IMPLEMENTED, "application/json", "{\"error\":\"Not implemented\"}");
    }

    private NanoHTTPD.Response resources() {
        Runtime runtime = Runtime.getRuntime();
        int playerCount = Bukkit.getOnlinePlayers().size();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("cpuUsage", "N/A");
        map.put("ramTotalMB", runtime.totalMemory() / 1024L / 1024L);
        map.put("ramFreeMB", runtime.freeMemory() / 1024L / 1024L);
        map.put("ramUsedMB", (runtime.totalMemory() - runtime.freeMemory()) / 1024L / 1024L);
        map.put("playerCount", playerCount);
        map.put("networkTxBytes", "N/A");
        return NanoHTTPD.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, "application/json", this.gson.toJson(map));
    }
}

