/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsUtils.web;

import dev.xdpxi.shaded.nanohttpd.NanoHTTPD;
import dev.xdpxi.xdsUtils.web.ApiHandler;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URLDecoder;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.bukkit.Bukkit;

public class WebServer
extends NanoHTTPD {
    public static ApiHandler apiHandler = null;
    private final File webRoot;
    private final File backupsDir;

    public WebServer(int port, File pluginFolder) throws IOException {
        super(port);
        this.webRoot = new File(pluginFolder, "web");
        this.backupsDir = new File(pluginFolder, "backups/full");
        if (!this.webRoot.exists()) {
            this.webRoot.mkdirs();
        }
        if (!this.backupsDir.exists()) {
            this.backupsDir.mkdirs();
        }
        apiHandler = new ApiHandler(this.webRoot, this.backupsDir);
        this.start(5000, false);
        Bukkit.getLogger().info("[WebServer] Started on port " + port);
    }

    @Override
    public NanoHTTPD.Response serve(NanoHTTPD.IHTTPSession session) {
        try {
            String uri = URLDecoder.decode(session.getUri(), StandardCharsets.UTF_8);
            if (uri.startsWith("/api/")) {
                return apiHandler.handleApi(session, uri);
            }
            if (uri.equals("/") || uri.equals("/index.html")) {
                return this.serveFile(new File(this.webRoot, "index.html"));
            }
            if (uri.startsWith("/web/")) {
                File requested = new File(this.webRoot, uri.substring("/web/".length()));
                return this.serveFile(requested);
            }
            return WebServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "Not Found");
        }
        catch (Exception e) {
            e.printStackTrace();
            return WebServer.newFixedLengthResponse(NanoHTTPD.Response.Status.INTERNAL_ERROR, "text/plain", "Internal Server Error");
        }
    }

    private NanoHTTPD.Response serveFile(File file) throws IOException {
        if (!file.exists() || !file.isFile()) {
            return WebServer.newFixedLengthResponse(NanoHTTPD.Response.Status.NOT_FOUND, "text/plain", "File Not Found");
        }
        String mime = Files.probeContentType(file.toPath());
        if (mime == null) {
            mime = "application/octet-stream";
        }
        byte[] data = Files.readAllBytes(file.toPath());
        NanoHTTPD.Response res = WebServer.newFixedLengthResponse(NanoHTTPD.Response.Status.OK, mime, new ByteArrayInputStream(data), data.length);
        res.setChunkedTransfer(false);
        return res;
    }

    public void stopServer() {
        this.stop();
        Bukkit.getLogger().info("[WebServer] Stopped.");
    }
}

