/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.commands;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.commands.Shop;
import dev.xdpxi.xdsutils.databases.Economy;
import dev.xdpxi.xdsutils.utils.Config;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public record Balance(Main plugin) implements CommandExecutor,
TabCompleter
{
    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (!Config.config.getBoolean("enable_shop")) {
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Only players can use this command.");
            return true;
        }
        Player player = (Player)sender;
        if (args.length == 0) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your current balance is " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(player.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
            return true;
        }
        return switch (args[0].toLowerCase()) {
            case "remove" -> this.removeBalance(player, args);
            case "add" -> this.addBalance(player, args);
            case "set" -> this.setBalance(player, args);
            case "get" -> this.getBalance(player, args);
            case "transfer" -> this.transferBalance(player, args);
            case "leaderboard" -> this.getBalanceLeaderboard(player);
            default -> false;
        };
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (!command.getName().equalsIgnoreCase("balance")) {
            return null;
        }
        if (!Config.config.getBoolean("enable_shop")) {
            return null;
        }
        ArrayList<String> completions = new ArrayList<String>();
        if (args.length == 1) {
            if (Shop.hasPermission(sender, true)) {
                completions.add("add");
                completions.add("set");
                completions.add("get");
                completions.add("remove");
            }
            completions.add("transfer");
            completions.add("leaderboard");
            return completions;
        }
        if (args.length == 2) {
            String partial = args[1].toLowerCase();
            for (Player player : Bukkit.getOnlinePlayers()) {
                String name = player.getName();
                if (!name.toLowerCase().startsWith(partial) || !Shop.hasPermission(sender, true)) continue;
                completions.add(name);
            }
            return completions;
        }
        if (args.length == 3 && Shop.hasPermission(sender, true)) {
            completions.add("<amount>");
        }
        return completions;
    }

    private boolean getBalance(Player player, String[] args) {
        if (args.length < 2) {
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + "Your current balance is " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(player.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
            return true;
        }
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s balance is " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean setBalance(Player player, String[] args) {
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /balance set <player> <amount>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        Economy.setBalance(target.getUniqueId(), Double.parseDouble(args[2]));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s balance is now " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean addBalance(Player player, String[] args) {
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /balance add <player> <amount>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        Economy.addBalance(target.getUniqueId(), Double.parseDouble(args[2]));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s balance is now " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean removeBalance(Player player, String[] args) {
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /balance remove <player> <amount>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        Economy.removeBalance(target.getUniqueId(), Double.parseDouble(args[2]));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s balance is now " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean transferBalance(Player player, String[] args) {
        if (!Shop.hasPermission((CommandSender)player, true)) {
            return true;
        }
        if (args.length < 3) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Usage: /balance transfer <player> <amount>");
            return true;
        }
        Player target = this.plugin.getServer().getPlayer(args[1]);
        if (target == null) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        Economy.addBalance(target.getUniqueId(), Double.parseDouble(args[2]));
        Economy.removeBalance(player.getUniqueId(), Double.parseDouble(args[2]));
        player.sendMessage(String.valueOf(ChatColor.YELLOW) + target.getName() + "'s balance is now " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ". Your balance is now " + String.valueOf(ChatColor.GOLD) + "$" + Economy.getBalance(target.getUniqueId()) + String.valueOf(ChatColor.YELLOW) + ".");
        return true;
    }

    private boolean getBalanceLeaderboard(Player player) {
        List<Map.Entry<UUID, Double>> leaderboard = Economy.getLeaderboard();
        if (leaderboard.isEmpty()) {
            player.sendMessage(String.valueOf(ChatColor.RED) + "No leaderboard data available.");
            return true;
        }
        String title = String.valueOf(ChatColor.GOLD) + String.valueOf(ChatColor.BOLD) + "Top Balances:";
        String separator = String.valueOf(ChatColor.DARK_GRAY) + "=======================";
        player.sendMessage(separator);
        player.sendMessage(title);
        player.sendMessage(separator);
        int rank = 1;
        for (Map.Entry<UUID, Double> entry : leaderboard) {
            String name;
            if (rank > 5) break;
            UUID uuid = entry.getKey();
            double balance = entry.getValue();
            Player onlinePlayer = Bukkit.getPlayer((UUID)uuid);
            if (onlinePlayer != null) {
                name = onlinePlayer.getName();
            } else {
                name = Bukkit.getOfflinePlayer((UUID)uuid).getName();
                if (name == null) {
                    name = "Unknown";
                }
            }
            String formattedBalance = String.format("%,.2f", balance);
            player.sendMessage(String.valueOf(ChatColor.YELLOW) + rank + ". " + name + String.valueOf(ChatColor.GRAY) + " - " + String.valueOf(ChatColor.GOLD) + "$" + formattedBalance);
            ++rank;
        }
        player.sendMessage(separator);
        return true;
    }
}

