/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils.databases;

import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.UUID;

public class Bounties {
    private static Connection connection;

    public static void init() {
        try {
            File dbFile;
            File dbFolder = new File(Main.getInstance().getDataFolder(), "databases");
            if (!dbFolder.exists()) {
                dbFolder.mkdirs();
            }
            if (!(dbFile = new File(dbFolder, "bounties.db")).getParentFile().exists()) {
                dbFile.getParentFile().mkdirs();
            }
            connection = DriverManager.getConnection("jdbc:sqlite:" + dbFile.getAbsolutePath());
            try (Statement stmt = connection.createStatement();){
                stmt.executeUpdate("CREATE TABLE IF NOT EXISTS bounties (uuid TEXT PRIMARY KEY,bounty REAL DEFAULT 0);");
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static double getBounty(UUID uuid) {
        PreparedStatement ps;
        block8: {
            if (connection == null) {
                Bounties.init();
            }
            String sql = "SELECT bounty FROM bounties WHERE uuid = ?";
            try {
                double d;
                ps = connection.prepareStatement(sql);
                try {
                    ps.setString(1, uuid.toString());
                    ResultSet rs = ps.executeQuery();
                    if (!rs.next()) break block8;
                    d = rs.getDouble("bounty");
                    if (ps == null) return d;
                }
                catch (Throwable throwable) {
                    if (ps == null) throw throwable;
                    try {
                        ps.close();
                        throw throwable;
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                ps.close();
                return d;
            }
            catch (SQLException e) {
                e.printStackTrace();
                return 0.0;
            }
        }
        if (ps == null) return 0.0;
        ps.close();
        return 0.0;
    }

    public static void setBounty(UUID uuid, double newBounty) {
        if (connection == null) {
            Bounties.init();
        }
        String sql = "INSERT INTO bounties (uuid, bounty) VALUES (?, ?) ON CONFLICT(uuid) DO UPDATE SET bounty = excluded.bounty;";
        try (PreparedStatement ps = connection.prepareStatement(sql);){
            ps.setString(1, uuid.toString());
            ps.setDouble(2, newBounty);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void addBounty(UUID uuid, double amount) {
        Bounties.setBounty(uuid, Bounties.getBounty(uuid) + amount);
    }

    public static void removeBounty(UUID uuid, double amount) {
        Bounties.setBounty(uuid, Math.max(0.0, Bounties.getBounty(uuid) - amount));
    }

    public static List<Map.Entry<UUID, Double>> getLeaderboard() {
        if (connection == null) {
            Bounties.init();
        }
        ArrayList<Map.Entry<UUID, Double>> leaderboard = new ArrayList<Map.Entry<UUID, Double>>();
        String sql = "SELECT uuid, bounty FROM bounties ORDER BY bounty DESC";
        try (Statement stmt = connection.createStatement();
             ResultSet rs = stmt.executeQuery(sql);){
            while (rs.next()) {
                UUID uuid = UUID.fromString(rs.getString("uuid"));
                double bounty = rs.getDouble("bounty");
                leaderboard.add(new AbstractMap.SimpleEntry<UUID, Double>(uuid, bounty));
            }
        }
        catch (SQLException e) {
            Log.error(e.getMessage());
            e.printStackTrace();
        }
        return leaderboard;
    }

    public static void close() {
        try {
            if (connection != null && !connection.isClosed()) {
                connection.close();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }
}

