/*
 * Decompiled with CFR 0.152.
 */
package dev.xdpxi.xdsutils;

import com.sun.net.httpserver.HttpExchange;
import com.sun.net.httpserver.HttpHandler;
import com.sun.net.httpserver.HttpServer;
import dev.xdpxi.xdsutils.Main;
import dev.xdpxi.xdsutils.utils.Log;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetSocketAddress;

public class WebServer {
    private static HttpServer server;

    public static void startAsync() {
        new Thread(() -> {
            try {
                WebServer.start();
            }
            catch (IOException e) {
                Log.error(String.valueOf(e));
            }
        }, "WebServer-Thread").start();
    }

    public static void start() throws IOException {
        if (server != null) {
            Log.warn("WebServer is already running!");
            return;
        }
        server = HttpServer.create(new InetSocketAddress(Main.port), 0);
        Log.info("Server started at http://localhost:" + Main.port);
        server.createContext("/", new HttpHandler(){

            @Override
            public void handle(HttpExchange exchange) throws IOException {
                InputStream is = WebServer.class.getResourceAsStream("/index.html");
                if (is == null) {
                    String error = "index.html not found in resources!";
                    exchange.sendResponseHeaders(404, error.length());
                    try (OutputStream os = exchange.getResponseBody();){
                        os.write(error.getBytes());
                    }
                    return;
                }
                byte[] response = is.readAllBytes();
                exchange.getResponseHeaders().add("Content-Type", "text/html");
                exchange.sendResponseHeaders(200, response.length);
                try (OutputStream os = exchange.getResponseBody();){
                    os.write(response);
                }
            }
        });
        server.setExecutor(null);
        server.start();
    }

    public static void stop() {
        if (server != null) {
            server.stop(0);
            Log.info("WebServer stopped.");
            server = null;
        } else {
            Log.warn("WebServer is not running.");
        }
    }
}

