/*
 * Decompiled with CFR 0.152.
 */
package de.thetechnicboy.create_wells.jei.animations;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import com.simibubi.create.compat.jei.category.animations.AnimatedKinetics;
import de.thetechnicboy.create_wells.block.ModBlocks;
import de.thetechnicboy.create_wells.block.mechanical_well.MechanicalWellBlock;
import de.thetechnicboy.create_wells.recipe.FluidExtractionRecipe;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.Property;

public class AnimatedMechanicalWell
extends AnimatedKinetics {
    private final ResourceLocation block;
    private final FluidExtractionRecipe.Direction direction;
    private final boolean blockTag;
    private final List<Block> blocks;
    private final Map<String, String> state;

    public AnimatedMechanicalWell(FluidExtractionRecipe.Direction direction) {
        this.direction = direction;
        this.block = null;
        this.blockTag = false;
        this.blocks = null;
        this.state = new HashMap<String, String>();
    }

    public AnimatedMechanicalWell(FluidExtractionRecipe.Direction direction, ResourceLocation block, boolean blockTag, Map<String, String> state) {
        this.direction = direction;
        this.block = block;
        this.blockTag = blockTag;
        this.state = state;
        Optional tagOptional = BuiltInRegistries.BLOCK.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)block));
        this.blocks = tagOptional.isPresent() ? ((HolderSet.Named)tagOptional.get()).stream().map(holder -> (Block)holder.value()).toList() : List.of();
    }

    public void draw(GuiGraphics graphics, int xOffset, int yOffset) {
        PoseStack matrixStack = graphics.pose();
        matrixStack.pushPose();
        matrixStack.translate((float)xOffset, (float)yOffset, 200.0f);
        matrixStack.mulPose(Axis.XP.rotationDegrees(-15.5f));
        matrixStack.mulPose(Axis.YP.rotationDegrees(22.5f));
        FluidExtractionRecipe.Direction _Direction = this.direction != FluidExtractionRecipe.Direction.BOTH ? this.direction : this.getDirectionSwapper();
        BlockState _block = this.getBlock();
        if (_block != null) {
            this.blockElement(_block).atLocal(-1.5, _Direction == FluidExtractionRecipe.Direction.UPSIDE_DOWN ? 0.2 : 2.2, 0.0).scale(23.0).render(graphics);
            this.blockElement((BlockState)((BlockState)((Block)ModBlocks.RED_MECHANICAL_WELL.get()).defaultBlockState().setValue(MechanicalWellBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)MechanicalWellBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(_Direction == FluidExtractionRecipe.Direction.UPSIDE_DOWN))).atLocal(-1.5, 1.2, 0.0).scale(23.0).render(graphics);
            this.blockElement((BlockState)((BlockState)((Block)ModBlocks.RED_MECHANICAL_WELL.get()).defaultBlockState().setValue(MechanicalWellBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)MechanicalWellBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(_Direction == FluidExtractionRecipe.Direction.UPSIDE_DOWN))).atLocal(-1.5, _Direction != FluidExtractionRecipe.Direction.UPSIDE_DOWN ? 0.2 : 2.2, 0.0).scale(23.0).render(graphics);
            this.blockElement(this.shaft(Direction.Axis.Z)).atLocal(-1.5, 1.2, 0.0).rotateBlock(0.0, 0.0, (double)AnimatedMechanicalWell.getCurrentAngle()).scale(23.0).render(graphics);
        } else {
            this.blockElement((BlockState)((BlockState)((Block)ModBlocks.RED_MECHANICAL_WELL.get()).defaultBlockState().setValue(MechanicalWellBlock.HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)MechanicalWellBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(_Direction == FluidExtractionRecipe.Direction.UPSIDE_DOWN))).atLocal(-1.5, _Direction == FluidExtractionRecipe.Direction.UPSIDE_DOWN ? 0.7 : 1.7, 0.0).scale(23.0).render(graphics);
            this.blockElement((BlockState)((BlockState)((Block)ModBlocks.RED_MECHANICAL_WELL.get()).defaultBlockState().setValue(MechanicalWellBlock.HALF, (Comparable)DoubleBlockHalf.UPPER)).setValue((Property)MechanicalWellBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(_Direction == FluidExtractionRecipe.Direction.UPSIDE_DOWN))).atLocal(-1.5, _Direction != FluidExtractionRecipe.Direction.UPSIDE_DOWN ? 0.7 : 1.7, 0.0).scale(23.0).render(graphics);
            this.blockElement(this.shaft(Direction.Axis.Z)).atLocal(-1.5, _Direction == FluidExtractionRecipe.Direction.UPSIDE_DOWN ? 0.7 : 1.7, 0.0).rotateBlock(0.0, 0.0, (double)AnimatedMechanicalWell.getCurrentAngle()).scale(23.0).render(graphics);
        }
        matrixStack.popPose();
    }

    private FluidExtractionRecipe.Direction getDirectionSwapper() {
        float cycle = (AnimationTickHolder.getRenderTime() - (float)(this.offset * 8)) % 80.0f;
        if (cycle < 40.0f) {
            return FluidExtractionRecipe.Direction.NORMAL;
        }
        return FluidExtractionRecipe.Direction.UPSIDE_DOWN;
    }

    private BlockState getBlock() {
        if (this.block == null) {
            return null;
        }
        if (!this.blockTag) {
            Block _block = (Block)BuiltInRegistries.BLOCK.get(this.block);
            if (_block == null) {
                return null;
            }
            BlockState blockState = _block.defaultBlockState();
            for (Map.Entry<String, String> requiredProperty : this.state.entrySet()) {
                String propertyName = requiredProperty.getKey();
                String requiredValue = requiredProperty.getValue();
                block1: for (Property property : blockState.getProperties()) {
                    if (!property.getName().equals(propertyName)) continue;
                    for (Comparable possible : property.getPossibleValues()) {
                        if (!possible.toString().equals(requiredValue)) continue;
                        blockState = AnimatedMechanicalWell.setPropertyUnchecked(blockState, property, possible);
                        continue block1;
                    }
                }
            }
            return blockState;
        }
        if (this.blocks.isEmpty()) {
            return null;
        }
        double cycle = (AnimationTickHolder.getRenderTime() - (float)(this.offset * 8)) % (float)(this.blocks.size() * 20);
        return this.blocks.get((int)(cycle / 20.0)).defaultBlockState();
    }

    private static <T extends Comparable<T>> BlockState setPropertyUnchecked(BlockState state, Property<?> property, Comparable<?> value) {
        Property<?> p = property;
        Comparable<?> v = value;
        return (BlockState)state.setValue(p, v);
    }
}

