/*
 * Decompiled with CFR 0.152.
 */
package de.thetechnicboy.create_wells.recipe;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import de.thetechnicboy.create_wells.CreateWells;
import de.thetechnicboy.create_wells.recipe.AllRecipeTypes;
import de.thetechnicboy.create_wells.recipe.FluidExtractionContainer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.material.Fluid;

public class FluidExtractionRecipe
implements Recipe<FluidExtractionContainer> {
    private static final boolean DEBUG_MODE_PRINTLN = false;
    private final FluidOutput output;
    private final Condition condition;

    public Condition getCondition() {
        return this.condition;
    }

    public FluidOutput getOutput() {
        return this.output;
    }

    private FluidExtractionRecipe(FluidOutput output, Condition condition) {
        this.output = output;
        this.condition = condition;
    }

    public boolean matches(FluidExtractionContainer container, Level level) {
        return true;
    }

    public ItemStack assemble(FluidExtractionContainer container, HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public boolean canCraftInDimensions(int i, int i1) {
        return true;
    }

    public ItemStack getResultItem(HolderLookup.Provider provider) {
        return ItemStack.EMPTY;
    }

    public RecipeSerializer<?> getSerializer() {
        return (RecipeSerializer)AllRecipeTypes.FLUID_EXTRACTION_SERIALIZER.get();
    }

    public RecipeType<?> getType() {
        return (RecipeType)AllRecipeTypes.FLUID_EXTRACTION_TYPE.get();
    }

    public static FluidExtractionRecipe registerRecipe(FluidOutput output, Condition condition) {
        Block block;
        if (output.amount <= 0 || output.fluid == null) {
            CreateWells.LOGGER.error("Something is Wrong with the FLUID Output (speed|amount|fluid) of a recipe");
            return null;
        }
        if (condition.yMin > condition.yMax && condition.yMin > -255 && condition.yMax > -255 || condition.yMin > 511 || condition.yMax > 511) {
            CreateWells.LOGGER.error("Something is Wrong with the HEIGHT in the condition of a recipe");
            return null;
        }
        if (condition.direction == Direction.ERROR) {
            CreateWells.LOGGER.error("Something is Wrong with the DIRECTION in the condition of a recipe");
            return null;
        }
        if (!condition.isBlockTag() && condition.getBlock() != null && (block = (Block)BuiltInRegistries.BLOCK.get(condition.getBlock())).equals(Blocks.AIR)) {
            CreateWells.LOGGER.error("Something is Wrong with the BLOCK in the condition of a recipe");
            return null;
        }
        if (condition.rpm < 0 || condition.rpm > 256) {
            CreateWells.LOGGER.error("Something is Wrong with the RPM in the condition of a recipe");
            return null;
        }
        if (!condition.getState().startsWith("[") || !condition.getState().endsWith("]")) {
            CreateWells.LOGGER.error("Something is Wrong with the STATE in the condition of a recipe");
            return null;
        }
        if (condition.isBlockTag() && !condition.getState().replaceAll(" ", "").equals("[]")) {
            CreateWells.LOGGER.error("STATE and BLOCK-TAG cannot be used together!");
            return null;
        }
        return new FluidExtractionRecipe(output, condition);
    }

    public static class Condition {
        private final Direction direction;
        private final List<ResourceLocation> biome;
        private final List<ResourceLocation> dimension;
        private final int yMin;
        private final int yMax;
        private final String block;
        private final String state;
        private final int rpm;
        public static final Codec<Condition> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Direction.CODEC.optionalFieldOf("direction", (Object)Direction.BOTH).forGetter(Condition::getDirection), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("biome", new ArrayList()).forGetter(Condition::getBiome), (App)Codec.list((Codec)ResourceLocation.CODEC).optionalFieldOf("dimension", new ArrayList()).forGetter(Condition::getDimension), (App)Codec.INT.optionalFieldOf("yMin", (Object)-255).forGetter(Condition::getYMin), (App)Codec.INT.optionalFieldOf("yMax", (Object)-255).forGetter(Condition::getYMax), (App)Codec.STRING.optionalFieldOf("block", (Object)"").forGetter(c -> c.block), (App)Codec.STRING.optionalFieldOf("state", (Object)"[]").forGetter(Condition::getState), (App)Codec.INT.optionalFieldOf("rpm", (Object)0).forGetter(Condition::getRPM)).apply((Applicative)instance, Condition::new));

        public Direction getDirection() {
            return this.direction;
        }

        public List<ResourceLocation> getBiome() {
            return this.biome;
        }

        public List<ResourceLocation> getDimension() {
            return this.dimension;
        }

        public int getYMin() {
            return this.yMin;
        }

        public int getYMax() {
            return this.yMax;
        }

        public ResourceLocation getBlock() {
            if (this.block.isEmpty()) {
                return null;
            }
            if (this.isBlockTag()) {
                return CreateWells.parseRL(this.block.substring(1));
            }
            return CreateWells.parseRL(this.block);
        }

        public boolean isBlockTag() {
            return this.block.startsWith("#");
        }

        public String getState() {
            return this.state;
        }

        public int getRPM() {
            return this.rpm;
        }

        public Condition(Direction direction, List<ResourceLocation> biome, List<ResourceLocation> dimension, int yMin, int yMax, String block, String state, int rpm) {
            this.direction = direction;
            this.biome = biome;
            this.dimension = dimension;
            this.yMin = yMin;
            this.yMax = yMax;
            this.state = state;
            this.rpm = rpm;
            this.block = block;
        }

        public static Condition fromPacket(FriendlyByteBuf buf) {
            String _direction = buf.readUtf();
            Direction direction = _direction.equals("UPSIDE_DOWN") ? Direction.UPSIDE_DOWN : (_direction.equals("NORMAL") ? Direction.NORMAL : (_direction.equals("BOTH") ? Direction.BOTH : Direction.NORMAL));
            int biomesSize = buf.readInt();
            ArrayList<ResourceLocation> biomes = new ArrayList<ResourceLocation>();
            for (int i = 0; i < biomesSize; ++i) {
                biomes.add(buf.readResourceLocation());
            }
            int dimensionsSize = buf.readInt();
            ArrayList<ResourceLocation> dimensions = new ArrayList<ResourceLocation>();
            for (int i = 0; i < dimensionsSize; ++i) {
                dimensions.add(buf.readResourceLocation());
            }
            int yMin = buf.readInt();
            int yMax = buf.readInt();
            String block = buf.readUtf();
            String state = buf.readUtf();
            int rpm = buf.readInt();
            return new Condition(direction, biomes, dimensions, yMin, yMax, block, state, rpm);
        }

        public void writeToPacket(FriendlyByteBuf buf) {
            if (this.direction == Direction.UPSIDE_DOWN) {
                buf.writeUtf("UPSIDE_DOWN");
            } else if (this.direction == Direction.NORMAL) {
                buf.writeUtf("NORMAL");
            } else if (this.direction == Direction.BOTH) {
                buf.writeUtf("BOTH");
            }
            buf.writeInt(this.biome.size());
            for (ResourceLocation biome : this.biome) {
                buf.writeResourceLocation(biome);
            }
            buf.writeInt(this.dimension.size());
            for (ResourceLocation dimension : this.dimension) {
                buf.writeResourceLocation(dimension);
            }
            buf.writeInt(this.yMin);
            buf.writeInt(this.yMax);
            buf.writeUtf(this.block);
            buf.writeUtf(this.state);
            buf.writeInt(this.rpm);
        }

        public Map<String, String> requiredProperties() {
            HashMap<String, String> requiredProperties = new HashMap<String, String>();
            String trimmed = this.getState().trim();
            String propertiesString = trimmed.substring(1, trimmed.length() - 1);
            if (!propertiesString.trim().isEmpty()) {
                String[] pairs;
                for (String pair : pairs = propertiesString.split(",")) {
                    String[] parts;
                    if (!(pair = pair.trim()).contains("=") || (parts = pair.split("=", 2)).length != 2) continue;
                    String key = parts[0].trim();
                    String value = parts[1].trim();
                    requiredProperties.put(key, value);
                }
            }
            return requiredProperties;
        }
    }

    public static class FluidOutput {
        private final Fluid fluid;
        private final int amount;
        public static final Codec<FluidOutput> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)ResourceLocation.CODEC.fieldOf("fluid").forGetter(fo -> BuiltInRegistries.FLUID.getKey((Object)fo.fluid)), (App)Codec.INT.fieldOf("amount").forGetter(FluidOutput::getAmount)).apply((Applicative)instance, (fluidRL, amount) -> new FluidOutput((Fluid)BuiltInRegistries.FLUID.get(fluidRL), (int)amount)));

        public int getAmount() {
            return this.amount;
        }

        public Fluid getFluid() {
            return this.fluid;
        }

        public FluidOutput(Fluid fluid, int amount) {
            this.fluid = fluid;
            this.amount = amount;
        }

        public static FluidOutput fromPacket(FriendlyByteBuf buf) {
            Fluid fluid = (Fluid)BuiltInRegistries.FLUID.get(buf.readResourceLocation());
            int amount = buf.readInt();
            return new FluidOutput(fluid, amount);
        }

        public void writeToPacket(FriendlyByteBuf buf) {
            buf.writeResourceLocation(BuiltInRegistries.FLUID.getKey((Object)this.fluid));
            buf.writeInt(this.amount);
        }
    }

    public static enum Direction {
        BOTH,
        UPSIDE_DOWN,
        NORMAL,
        ERROR;

        public static final Codec<Direction> CODEC;

        static {
            CODEC = Codec.STRING.xmap(s -> {
                try {
                    return Direction.valueOf(s.toUpperCase());
                }
                catch (IllegalArgumentException e) {
                    return ERROR;
                }
            }, Enum::name);
        }
    }
}

