/*
 * Decompiled with CFR 0.152.
 */
package de.thetechnicboy.create_wells.block.mechanical_well;

import com.simibubi.create.content.kinetics.base.DirectionalAxisKineticBlock;
import com.simibubi.create.foundation.block.IBE;
import de.thetechnicboy.create_wells.block.mechanical_well.entity.MechanicalWellEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DoubleBlockHalf;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.NoteBlockInstrument;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.shapes.BooleanOp;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class MechanicalWellBlock
extends DirectionalAxisKineticBlock
implements IBE<MechanicalWellEntity> {
    public static final EnumProperty<Direction.Axis> AXIS = BlockStateProperties.HORIZONTAL_AXIS;
    public static final EnumProperty<DoubleBlockHalf> HALF = BlockStateProperties.DOUBLE_BLOCK_HALF;
    public static final BooleanProperty UPSIDE_DOWN = BooleanProperty.create((String)"upside_down");
    public static final VoxelShape SHAPE_BASE = Shapes.join((VoxelShape)Shapes.block(), (VoxelShape)Block.box((double)3.0, (double)2.0, (double)3.0, (double)13.0, (double)16.0, (double)13.0), (BooleanOp)BooleanOp.ONLY_FIRST);
    public static final VoxelShape SHAPE_INNER_SUPPORT = Shapes.or((VoxelShape)Block.box((double)7.5, (double)0.0, (double)1.0, (double)8.5, (double)15.0, (double)2.0), (VoxelShape[])new VoxelShape[]{Block.box((double)7.5, (double)0.0, (double)14.0, (double)8.5, (double)15.0, (double)15.0), Block.box((double)7.5, (double)7.0, (double)2.0, (double)8.5, (double)8.0, (double)14.0), Block.box((double)5.0, (double)4.5, (double)4.5, (double)11.0, (double)10.5, (double)11.5)});
    public static final VoxelShape SHAPE_ROOF = Shapes.or((VoxelShape)Block.box((double)5.5, (double)12.5, (double)0.0, (double)10.5, (double)15.707, (double)16.0), (VoxelShape[])new VoxelShape[]{Block.box((double)2.75, (double)10.5, (double)0.0, (double)5.5, (double)13.75, (double)16.0), Block.box((double)10.5, (double)10.5, (double)0.0, (double)13.25, (double)13.75, (double)16.0), Block.box((double)0.0, (double)8.0, (double)0.0, (double)2.75, (double)11.25, (double)16.0), Block.box((double)13.25, (double)8.0, (double)0.0, (double)16.0, (double)11.25, (double)16.0), SHAPE_INNER_SUPPORT});

    public MechanicalWellBlock() {
        super(BlockBehaviour.Properties.of().instrument(NoteBlockInstrument.BASEDRUM).strength(1.5f, 6.0f).requiresCorrectToolForDrops());
        this.registerDefaultState((BlockState)((BlockState)((BlockState)((BlockState)this.getStateDefinition().any()).setValue(AXIS, (Comparable)Direction.Axis.X)).setValue(HALF, (Comparable)DoubleBlockHalf.LOWER)).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{AXIS, HALF, UPSIDE_DOWN});
    }

    public BlockState getStateForPlacement(BlockPlaceContext context) {
        Direction.Axis axis;
        Level level = context.getLevel();
        BlockPos pos = context.getClickedPos();
        Direction.Axis axis2 = axis = context.getPlayer().isCrouching() ? context.getHorizontalDirection().getClockWise().getAxis() : context.getHorizontalDirection().getAxis();
        if (pos.getY() < level.getMaxBuildHeight() - 1 && level.getBlockState(pos.above()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(false));
        }
        if (pos.getY() > level.getMinBuildHeight() + 1 && level.getBlockState(pos.below()).canBeReplaced(context)) {
            return (BlockState)((BlockState)this.defaultBlockState().setValue(AXIS, (Comparable)axis)).setValue((Property)UPSIDE_DOWN, (Comparable)Boolean.valueOf(true));
        }
        return null;
    }

    public BlockState updateShape(BlockState state, Direction direction, BlockState neighborState, LevelAccessor level, BlockPos currentPos, BlockPos neighborPos) {
        Direction flippedDir2;
        DoubleBlockHalf half = (DoubleBlockHalf)state.getValue(HALF);
        Direction flippedDir1 = (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? Direction.DOWN : Direction.UP;
        Direction direction2 = flippedDir2 = (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? Direction.UP : Direction.DOWN;
        if ((direction.getAxis() != Direction.Axis.Y || half == DoubleBlockHalf.LOWER != (direction == flippedDir1) || neighborState.is((Block)this) && neighborState.getValue(HALF) != half) && (half != DoubleBlockHalf.LOWER || direction != flippedDir2 || state.canSurvive((LevelReader)level, currentPos))) {
            return state;
        }
        return Blocks.AIR.defaultBlockState();
    }

    public void setPlacedBy(Level level, BlockPos pos, BlockState state, LivingEntity placer, ItemStack stack) {
        level.setBlockAndUpdate(pos.above((Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? -1 : 1), (BlockState)state.setValue(HALF, (Comparable)DoubleBlockHalf.UPPER));
    }

    public BlockState playerWillDestroy(Level level, BlockPos pos, BlockState state, Player player) {
        BlockPos otherPos;
        BlockState otherState;
        if (!level.isClientSide && state.getValue(HALF) == DoubleBlockHalf.UPPER && (otherState = level.getBlockState(otherPos = pos.below((Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? -1 : 1))).is((Block)this) && otherState.getValue(HALF) == DoubleBlockHalf.LOWER) {
            if (player.isCreative()) {
                level.destroyBlock(otherPos, false, (Entity)player);
            } else {
                level.destroyBlock(otherPos, this.canHarvestBlock(state, (BlockGetter)level, pos, player), (Entity)player);
            }
        }
        return super.playerWillDestroy(level, pos, state, player);
    }

    public PushReaction getPistonPushReaction(BlockState state) {
        return PushReaction.IGNORE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    public VoxelShape getShape(BlockState state, BlockGetter level, BlockPos pos, CollisionContext context) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? MechanicalWellBlock.flipShapeUpsideDown(SHAPE_BASE) : SHAPE_BASE;
        }
        if (state.getValue(AXIS) == Direction.Axis.X) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? MechanicalWellBlock.flipShapeUpsideDown(SHAPE_ROOF) : SHAPE_ROOF;
        }
        return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? MechanicalWellBlock.flipShapeUpsideDown(MechanicalWellBlock.flipShapeXZ(SHAPE_ROOF)) : MechanicalWellBlock.flipShapeXZ(SHAPE_ROOF);
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? MechanicalWellBlock.flipShapeUpsideDown(SHAPE_BASE) : SHAPE_BASE;
        }
        if (state.getValue(AXIS) == Direction.Axis.X) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? MechanicalWellBlock.flipShapeUpsideDown(SHAPE_INNER_SUPPORT) : SHAPE_INNER_SUPPORT;
        }
        return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? MechanicalWellBlock.flipShapeUpsideDown(MechanicalWellBlock.flipShapeXZ(SHAPE_INNER_SUPPORT)) : MechanicalWellBlock.flipShapeXZ(SHAPE_INNER_SUPPORT);
    }

    public boolean useShapeForLightOcclusion(BlockState state) {
        return true;
    }

    public VoxelShape getInteractionShape(BlockState state, BlockGetter level, BlockPos pos) {
        if (state.getValue(HALF) == DoubleBlockHalf.LOWER) {
            return Shapes.block();
        }
        if (state.getValue(AXIS) == Direction.Axis.X) {
            return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? MechanicalWellBlock.flipShapeUpsideDown(SHAPE_ROOF) : SHAPE_ROOF;
        }
        return (Boolean)state.getValue((Property)UPSIDE_DOWN) != false ? MechanicalWellBlock.flipShapeUpsideDown(MechanicalWellBlock.flipShapeXZ(SHAPE_ROOF)) : MechanicalWellBlock.flipShapeXZ(SHAPE_ROOF);
    }

    public BlockState rotate(BlockState state, Rotation rotation) {
        switch (rotation) {
            case COUNTERCLOCKWISE_90: 
            case CLOCKWISE_90: {
                switch ((Direction.Axis)state.getValue(AXIS)) {
                    case Z: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.X);
                    }
                    case X: {
                        return (BlockState)state.setValue(AXIS, (Comparable)Direction.Axis.Z);
                    }
                }
                return state;
            }
        }
        return state;
    }

    public static VoxelShape flipShapeXZ(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)minZ, (double)minY, (double)minX, (double)maxZ, (double)maxY, (double)maxX));
        });
        return buffer[1];
    }

    public static VoxelShape flipShapeUpsideDown(VoxelShape shape) {
        VoxelShape[] buffer = new VoxelShape[]{shape, Shapes.empty()};
        buffer[0].forAllBoxes((minX, minY, minZ, maxX, maxY, maxZ) -> {
            buffer[1] = Shapes.or((VoxelShape)buffer[1], (VoxelShape)Shapes.create((double)minX, (double)(1.0 - maxY), (double)minZ, (double)maxX, (double)(1.0 - minY), (double)maxZ));
        });
        return buffer[1];
    }

    public static float getFluidRenderHeight(int amount, int capacity, boolean upsideDown) {
        float height = (float)amount * 14.0f / (float)(16 * capacity) + 0.125f;
        return upsideDown ? 1.0f - height : height;
    }

    public Direction.Axis getRotationAxis(BlockState state) {
        return state.getValue(AXIS) == Direction.Axis.X ? Direction.Axis.Z : Direction.Axis.X;
    }

    public boolean hasShaftTowards(LevelReader world, BlockPos pos, BlockState state, Direction face) {
        return face.getAxis() != state.getValue(AXIS);
    }
}

