/*
 * Decompiled with CFR 0.152.
 */
package de.thetechnicboy.create_wells.block.mechanical_well.entity;

import com.simibubi.create.api.equipment.goggles.IHaveGoggleInformation;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.foundation.blockEntity.SmartBlockEntity;
import com.simibubi.create.foundation.blockEntity.behaviour.BlockEntityBehaviour;
import com.simibubi.create.foundation.blockEntity.behaviour.fluid.SmartFluidTankBehaviour;
import de.thetechnicboy.create_wells.Config;
import de.thetechnicboy.create_wells.block.mechanical_well.MechanicalWellBlock;
import de.thetechnicboy.create_wells.recipe.AllRecipeTypes;
import de.thetechnicboy.create_wells.recipe.FluidExtractionRecipe;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.HolderSet;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.capabilities.ICapabilityProvider;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.capability.IFluidHandler;

public abstract class MechanicalWellEntity
extends KineticBlockEntity
implements IHaveGoggleInformation,
ICapabilityProvider<BlockPos, Direction, IFluidHandler> {
    public static int tankCapacity = (Integer)Config.MECHANICAL_WELL_CAPACITY.get();
    private boolean initialized;
    private SmartFluidTankBehaviour tank;
    private int tickCounter = 0;
    private FluidExtractionRecipe.FluidOutput cachedFluidOutput;

    public MechanicalWellEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean addToGoggleTooltip(List<Component> tooltip, boolean isPlayerSneaking) {
        super.addToGoggleTooltip(tooltip, isPlayerSneaking);
        return this.containedFluidTooltip(tooltip, isPlayerSneaking, (IFluidHandler)this.getLevel().getCapability(Capabilities.FluidHandler.BLOCK, this.getBlockPos(), null));
    }

    public float calculateStressApplied() {
        float impact;
        this.lastStressApplied = impact = (float)((Integer)Config.MECHANICAL_WELL_STRESS.get()).intValue();
        return impact;
    }

    public void addBehaviours(List<BlockEntityBehaviour> behaviour) {
        this.tank = SmartFluidTankBehaviour.single((SmartBlockEntity)this, (int)tankCapacity);
        this.tank.getPrimaryHandler().setValidator(fluid -> true);
        behaviour.add((BlockEntityBehaviour)this.tank);
        super.addBehaviours(behaviour);
    }

    @Nullable
    public IFluidHandler getCapability(BlockPos pos, Direction side) {
        if (this.tank != null) {
            return this.tank.getPrimaryHandler();
        }
        return null;
    }

    public void tick() {
        super.tick();
        if (this.tickCounter % 20 == 0 || this.cachedFluidOutput == null) {
            this.cachedFluidOutput = this.getFluidToFill();
        }
        ++this.tickCounter;
        FluidStack oldFluid = this.tank.getPrimaryHandler().getFluid();
        FluidStack newFluid = new FluidStack(this.cachedFluidOutput.getFluid(), this.cachedFluidOutput.getAmount() + oldFluid.getAmount());
        if (!oldFluid.isEmpty() && oldFluid.getFluid() != newFluid.getFluid()) {
            return;
        }
        if (oldFluid.getAmount() >= tankCapacity) {
            return;
        }
        boolean hasChanged = false;
        if (this.cachedFluidOutput.getAmount() + oldFluid.getAmount() > tankCapacity) {
            this.tank.getPrimaryHandler().setFluid(new FluidStack(this.cachedFluidOutput.getFluid(), tankCapacity));
            hasChanged = true;
        } else if (this.cachedFluidOutput.getAmount() > 0) {
            this.tank.getPrimaryHandler().setFluid(newFluid);
            hasChanged = true;
        }
        if (hasChanged) {
            this.getLevel().sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
            this.setChanged();
        }
    }

    public void onLoad() {
        if (!this.initialized) {
            this.initialized = true;
        }
    }

    protected FluidExtractionRecipe.FluidOutput getFluidToFill() {
        ArrayList _AllRecipes = new ArrayList();
        ArrayList<FluidExtractionRecipe> _Recipes = new ArrayList<FluidExtractionRecipe>();
        FluidExtractionRecipe.FluidOutput OUTPUT = new FluidExtractionRecipe.FluidOutput(FluidStack.EMPTY.getFluid(), 0);
        this.level.getRecipeManager().getAllRecipesFor((RecipeType)AllRecipeTypes.FLUID_EXTRACTION_TYPE.get()).forEach(recipe -> _AllRecipes.add((FluidExtractionRecipe)recipe.value()));
        for (int i = 0; i < _AllRecipes.size(); ++i) {
            FluidExtractionRecipe recipe2 = (FluidExtractionRecipe)_AllRecipes.get(i);
            if (!this.checkConditions(recipe2.getCondition())) continue;
            _Recipes.add(recipe2);
        }
        if (!_Recipes.isEmpty()) {
            OUTPUT = ((FluidExtractionRecipe)_Recipes.get(0)).getOutput();
        }
        return OUTPUT;
    }

    private boolean checkConditions(FluidExtractionRecipe.Condition conditions) {
        boolean Success = true;
        if (this.getYPos() < conditions.getYMin() && conditions.getYMin() != -255) {
            Success = false;
        }
        if (this.getYPos() > conditions.getYMax() && conditions.getYMax() != -255) {
            Success = false;
        }
        if (conditions.getDirection() == FluidExtractionRecipe.Direction.NORMAL && this.isUpsideDown()) {
            Success = false;
        }
        if (conditions.getDirection() == FluidExtractionRecipe.Direction.UPSIDE_DOWN && !this.isUpsideDown()) {
            Success = false;
        }
        if (!conditions.getDimension().isEmpty() && !conditions.getDimension().contains(this.getDimension())) {
            Success = false;
        }
        if (!conditions.getBiome().isEmpty() && !conditions.getBiome().contains(this.getBiome())) {
            Success = false;
        }
        if (!conditions.isBlockTag() && conditions.getBlock() != null && !conditions.getBlock().equals((Object)this.getBelowBlock())) {
            Success = false;
        }
        if (conditions.isBlockTag() && conditions.getBlock() != null) {
            Optional tagOptional = BuiltInRegistries.BLOCK.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)conditions.getBlock()));
            if (tagOptional.isPresent()) {
                Block block;
                List<Block> blocks = ((HolderSet.Named)tagOptional.get()).stream().map(holder -> (Block)holder.value()).toList();
                if (!blocks.contains(block = (Block)BuiltInRegistries.BLOCK.get(this.getBelowBlock()))) {
                    Success = false;
                }
            } else {
                Success = false;
            }
        }
        if (Math.abs(this.getSpeed()) < (float)conditions.getRPM() && conditions.getRPM() != -255) {
            Success = false;
        }
        return Success;
    }

    public boolean isUpsideDown() {
        return (Boolean)this.getBlockState().getValue((Property)MechanicalWellBlock.UPSIDE_DOWN);
    }

    public ResourceLocation getBiome() {
        return this.getLevel().registryAccess().registryOrThrow(Registries.BIOME).getKey((Object)((Biome)this.getLevel().getBiome(this.getBlockPos()).value()));
    }

    public int getYPos() {
        return this.getBlockPos().getY();
    }

    public ResourceLocation getDimension() {
        return this.getLevel().dimension().location();
    }

    public ResourceLocation getBelowBlock() {
        BlockPos otherPos = this.getBlockPos().below(this.isUpsideDown() ? -1 : 1);
        Block block = this.level.getBlockState(otherPos).getBlock();
        return this.getLevel().registryAccess().registryOrThrow(Registries.BLOCK).getKey((Object)block);
    }

    public SmartFluidTankBehaviour getTank() {
        return this.tank;
    }

    public CompoundTag getUpdateTag(HolderLookup.Provider registries) {
        return this.saveWithoutMetadata(registries);
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt, HolderLookup.Provider lookupProvider) {
        boolean wasFull;
        FluidStack oldFluid = this.tank.getPrimaryHandler().getFluid();
        this.handleUpdateTag(pkt.getTag(), lookupProvider);
        FluidStack newFluid = this.tank.getPrimaryHandler().getFluid();
        boolean wasEmpty = newFluid != null && oldFluid == null;
        boolean bl = wasFull = newFluid == null && oldFluid != null;
        if (wasEmpty || wasFull || newFluid != null && newFluid.getAmount() != oldFluid.getAmount()) {
            this.level.sendBlockUpdated(this.getBlockPos(), this.getBlockState(), this.getBlockState(), 3);
        }
    }
}

