/*
 * Decompiled with CFR 0.152.
 */
package de.thetechnicboy.create_wells.client;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.simibubi.create.AllPartialModels;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.ShaftRenderer;
import de.thetechnicboy.create_wells.block.mechanical_well.MechanicalWellBlock;
import de.thetechnicboy.create_wells.block.mechanical_well.entity.MechanicalWellEntity;
import dev.engine_room.flywheel.lib.model.baked.PartialModel;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperByteBuffer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.blockentity.BlockEntityRendererProvider;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.FluidState;
import net.neoforged.neoforge.client.extensions.common.IClientFluidTypeExtensions;
import net.neoforged.neoforge.fluids.FluidStack;
import net.neoforged.neoforge.fluids.FluidType;
import org.joml.Matrix4f;

public class WellRenderer
extends ShaftRenderer<MechanicalWellEntity> {
    public WellRenderer(BlockEntityRendererProvider.Context context) {
        super(context);
    }

    public void renderSafe(MechanicalWellEntity well, float partialTick, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        FluidStack fluid = well.getTank().getPrimaryHandler().getFluid();
        if (!fluid.isEmpty()) {
            this.renderFluid(fluid, well, poseStack, bufferSource, packedLight, packedOverlay);
        }
        this.renderShaft(well, poseStack, bufferSource, packedLight);
    }

    public boolean shouldRenderOffScreen(MechanicalWellEntity be) {
        return true;
    }

    private void renderFluid(FluidStack fluid, MechanicalWellEntity well, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight, int packedOverlay) {
        int rgb;
        int amount = fluid.getAmount();
        int capacity = MechanicalWellEntity.tankCapacity;
        boolean upsideDown = well.isUpsideDown();
        Level level = well.getLevel();
        BlockPos pos = well.getBlockPos();
        FluidType fluidType = fluid.getFluid().getFluidType();
        IClientFluidTypeExtensions fluidEx = IClientFluidTypeExtensions.of((FluidType)fluidType);
        ResourceLocation stillTexture = fluidEx.getStillTexture(fluid);
        if (stillTexture == null) {
            stillTexture = fluidEx.getStillTexture();
        }
        TextureAtlasSprite sprite = (TextureAtlasSprite)Minecraft.getInstance().getTextureAtlas(InventoryMenu.BLOCK_ATLAS).apply(stillTexture);
        int color = this.getFluidColor(fluidEx, fluidType, fluid, level, pos);
        float corner = 0.1875f;
        float height = MechanicalWellBlock.getFluidRenderHeight(amount, capacity, upsideDown);
        float minU = sprite.getU0();
        float maxU = sprite.getU1();
        float minV = sprite.getV0();
        float maxV = sprite.getV1();
        float uvWidth = maxU - minU;
        float uvHeight = maxV - minV;
        float uvStartX = minU + uvWidth * 3.0f / 16.0f;
        float uvEndX = minU + uvWidth * 13.0f / 16.0f;
        float uvStartY = minV + uvHeight * 3.0f / 16.0f;
        float uvEndY = minV + uvHeight * 13.0f / 16.0f;
        VertexConsumer builder = bufferSource.getBuffer(RenderType.translucent());
        Matrix4f matrix = poseStack.last().pose();
        int alpha = color >> 24 & 0xFF;
        if (alpha == 0) {
            alpha = 255;
        }
        if ((rgb = color & 0xFFFFFF) == 0) {
            rgb = 0xFFFFFF;
        }
        color = alpha << 24 | rgb;
        int adjustedLight = 0xF000F0;
        if (upsideDown) {
            builder.addVertex(matrix, 1.0f - corner, height, corner).setColor(color).setUv(uvEndX, uvStartY).setUv2(adjustedLight, packedOverlay).setNormal(0.0f, -1.0f, 0.0f);
            builder.addVertex(matrix, 1.0f - corner, height, 1.0f - corner).setColor(color).setUv(uvEndX, uvEndY).setUv2(adjustedLight, packedOverlay).setNormal(0.0f, -1.0f, 0.0f);
            builder.addVertex(matrix, corner, height, 1.0f - corner).setColor(color).setUv(uvStartX, uvEndY).setUv2(adjustedLight, packedOverlay).setNormal(0.0f, -1.0f, 0.0f);
            builder.addVertex(matrix, corner, height, corner).setColor(color).setUv(uvStartX, uvStartY).setUv2(adjustedLight, packedOverlay).setNormal(0.0f, -1.0f, 0.0f);
        } else {
            builder.addVertex(matrix, corner, height, corner).setColor(color).setUv(uvStartX, uvStartY).setUv2(adjustedLight, packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(matrix, corner, height, 1.0f - corner).setColor(color).setUv(uvStartX, uvEndY).setUv2(adjustedLight, packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(matrix, 1.0f - corner, height, 1.0f - corner).setColor(color).setUv(uvEndX, uvEndY).setUv2(adjustedLight, packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
            builder.addVertex(matrix, 1.0f - corner, height, corner).setColor(color).setUv(uvEndX, uvStartY).setUv2(adjustedLight, packedOverlay).setNormal(0.0f, 1.0f, 0.0f);
        }
    }

    private int getFluidColor(IClientFluidTypeExtensions fluidEx, FluidType fluidType, FluidStack fluid, Level level, BlockPos pos) {
        try {
            FluidState fluidState = fluidType.getStateForPlacement((BlockAndTintGetter)level, pos, fluid);
            int color = fluidEx.getTintColor(fluidState, (BlockAndTintGetter)level, pos);
            if (color != 0 && (color & 0xFFFFFF) != 0) {
                return color;
            }
            color = fluidEx.getTintColor(fluid);
            if (color != 0 && (color & 0xFFFFFF) != 0) {
                return color;
            }
            color = fluidEx.getTintColor();
            if (color != 0 && (color & 0xFFFFFF) != 0) {
                return color;
            }
        }
        catch (Exception e) {
            System.err.println("Error getting fluid color: " + e.getMessage());
        }
        return -1;
    }

    private void renderShaft(MechanicalWellEntity well, PoseStack poseStack, MultiBufferSource bufferSource, int packedLight) {
        VertexConsumer vb = bufferSource.getBuffer(RenderType.solid());
        int packedLightmapCoords = LevelRenderer.getLightColor((BlockAndTintGetter)well.getLevel(), (BlockPos)well.getBlockPos());
        SuperByteBuffer shaft = CachedBuffers.partial((PartialModel)AllPartialModels.SHAFT, (BlockState)well.getBlockState());
        Direction.Axis axis = WellRenderer.getRotationAxisOf((KineticBlockEntity)well);
        ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)shaft.rotateCentered(axis == Direction.Axis.Z ? 0.0f : 1.5707964f, Direction.NORTH)).rotateCentered(axis == Direction.Axis.X ? 0.0f : 1.5707964f, Direction.EAST)).translate(0.0f, 0.0f, 0.0f)).rotateCentered(WellRenderer.getAngleForBe((KineticBlockEntity)well, (BlockPos)well.getBlockPos(), (Direction.Axis)axis), Direction.UP)).light(packedLightmapCoords).renderInto(poseStack, vb);
    }
}

