/*
 * Decompiled with CFR 0.152.
 */
package de.thetechnicboy.create_wells.jei;

import com.simibubi.create.compat.jei.category.CreateRecipeCategory;
import com.simibubi.create.foundation.gui.AllGuiTextures;
import de.thetechnicboy.create_wells.jei.animations.AnimatedMechanicalWell;
import de.thetechnicboy.create_wells.recipe.FluidExtractionRecipe;
import java.util.ArrayList;
import java.util.List;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.builder.IRecipeSlotBuilder;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.neoforge.NeoForgeTypes;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.core.Holder;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.core.registries.Registries;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.neoforge.fluids.FluidStack;

public class FluidExtractionCategory
extends CreateRecipeCategory<FluidExtractionRecipe> {
    public FluidExtractionCategory(CreateRecipeCategory.Info<FluidExtractionRecipe> info) {
        super(info);
        System.out.println("FLUID Extraction Category");
    }

    public void setRecipe(IRecipeLayoutBuilder builder, FluidExtractionRecipe recipe, IFocusGroup focuses) {
        if (recipe.getCondition().getBlock() != null) {
            if (recipe.getCondition().isBlockTag()) {
                List blocks = BuiltInRegistries.BLOCK.getTag(TagKey.create((ResourceKey)Registries.BLOCK, (ResourceLocation)recipe.getCondition().getBlock())).map(tag -> tag.stream().map(Holder::value).toList()).orElse(List.of());
                ArrayList<ItemStack> items = new ArrayList<ItemStack>();
                if (!blocks.isEmpty()) {
                    blocks.forEach(b -> items.add(b.getCloneItemStack(null, null, null, null, null)));
                } else {
                    ItemStack stack = new ItemStack((ItemLike)Items.STRUCTURE_VOID);
                    stack.set(DataComponents.CUSTOM_NAME, (Object)Component.literal((String)("Tag '#" + String.valueOf(recipe.getCondition().getBlock()) + "' is empty!")));
                    items.add(stack);
                }
                builder.addSlot(RecipeIngredientRole.INPUT, 3, this.getBackground().getHeight() / 2 - 7).setBackground(FluidExtractionCategory.getRenderedSlot(), -1, -1).addItemStacks(items);
            } else {
                builder.addSlot(RecipeIngredientRole.INPUT, 3, this.getBackground().getHeight() / 2 - 7).setBackground(FluidExtractionCategory.getRenderedSlot(), -1, -1).addItemStack(((Block)BuiltInRegistries.BLOCK.get(recipe.getCondition().getBlock())).getCloneItemStack(null, null, null, null, null));
            }
        }
        int outputAmount = recipe.getOutput().getAmount();
        FluidStack fluidStack = new FluidStack(recipe.getOutput().getFluid(), outputAmount);
        ((IRecipeSlotBuilder)builder.addSlot(RecipeIngredientRole.OUTPUT, this.getWidth() / 2 - 20, this.getBackground().getHeight() - 20).setBackground(FluidExtractionCategory.getRenderedSlot(), -1, -1).addIngredient((IIngredientType)NeoForgeTypes.FLUID_STACK, (Object)fluidStack)).addRichTooltipCallback((view, tooltip) -> {
            if (outputAmount < 1000) {
                tooltip.add((FormattedText)Component.literal((String)(outputAmount + "mB/tick")));
            }
            if (outputAmount >= 1000) {
                tooltip.add((FormattedText)Component.literal((String)(Float.toString((float)outputAmount / 1000.0f) + "B/tick")));
            }
        });
    }

    public void draw(FluidExtractionRecipe recipe, IRecipeSlotsView recipeSlotsView, GuiGraphics graphics, double mouseX, double mouseY) {
        FluidExtractionRecipe.Condition condition = recipe.getCondition();
        String text = String.valueOf(condition.getYMin() == -255 ? "-\u221e" : Integer.valueOf(condition.getYMin())) + " -> " + String.valueOf(condition.getYMax() == -255 ? "+\u221e" : Integer.valueOf(condition.getYMax()));
        int Color = 0x575757;
        graphics.drawString(Minecraft.getInstance().font, "Height:", this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 - 37, Color, false);
        graphics.drawString(Minecraft.getInstance().font, "  " + text, this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 - 27, Color, false);
        graphics.drawString(Minecraft.getInstance().font, "Dimension:", this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 - 17, Color, false);
        if (!condition.getDimension().isEmpty()) {
            graphics.drawString(Minecraft.getInstance().font, "  " + condition.getDimension().get((int)(AnimationTickHolder.getRenderTime() % (float)(condition.getDimension().size() * 30)) / 30).getPath(), this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 - 7, Color, false);
        } else {
            graphics.drawString(Minecraft.getInstance().font, "  Not Important", this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 - 7, Color, false);
        }
        graphics.drawString(Minecraft.getInstance().font, "Biome:", this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 + 3, Color, false);
        if (!condition.getBiome().isEmpty()) {
            graphics.drawString(Minecraft.getInstance().font, "  " + condition.getBiome().get((int)((AnimationTickHolder.getRenderTime() + 15.0f) % (float)(condition.getBiome().size() * 30)) / 30).getPath(), this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 + 13, Color, false);
        } else {
            graphics.drawString(Minecraft.getInstance().font, "  Not Important", this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 + 13, Color, false);
        }
        graphics.drawString(Minecraft.getInstance().font, "RPM:", this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 + 23, Color, false);
        if (condition.getRPM() != 0) {
            graphics.drawString(Minecraft.getInstance().font, "  >= " + condition.getRPM(), this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 + 33, Color, false);
        } else {
            graphics.drawString(Minecraft.getInstance().font, "  Not Important", this.getBackground().getWidth() / 2 + 2, this.getBackground().getHeight() / 2 + 33, Color, false);
        }
        AnimatedMechanicalWell well = recipe.getCondition().getBlock() != null ? new AnimatedMechanicalWell(recipe.getCondition().getDirection(), recipe.getCondition().getBlock(), recipe.getCondition().isBlockTag()) : new AnimatedMechanicalWell(recipe.getCondition().getDirection());
        well.draw(graphics, this.getBackground().getWidth() / 2 - 29, 22);
        AllGuiTextures.JEI_DOWN_ARROW.render(graphics, this.getWidth() / 2 - 26, this.getHeight() / 2);
    }
}

