/*
 * Decompiled with CFR 0.152.
 */
package com.cosmo.items;

import com.cosmo.CosmicVailComponents;
import com.cosmo.entity.custom.WeeperEntity;
import com.cosmo.util.MonarchSwordComponent;
import java.util.List;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1829;
import net.minecraft.class_1832;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2561;
import net.minecraft.class_3222;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import org.jetbrains.annotations.Nullable;

public class MonarchsBlade
extends class_1829 {
    private static final String STANCE_KEY = "MonarchStance";

    public MonarchsBlade(class_1832 toolMaterial, int attackDamage, float attackSpeed, class_1792.class_1793 settings) {
        super(toolMaterial, attackDamage, attackSpeed, settings);
    }

    public void method_7851(class_1799 stack, @Nullable class_1937 world, List<class_2561> tooltip, class_1836 context) {
        tooltip.add((class_2561)class_2561.method_43470((String)"Forged from the veil between light and void. Stronger in darkness."));
        int stance = stack.method_7948().method_10550(STANCE_KEY);
        tooltip.add((class_2561)class_2561.method_43470((String)("\u00a78Current Stance: " + this.getStanceName(stance))));
        tooltip.add((class_2561)class_2561.method_43470((String)"\u00a77Crouch Right-click to shift stance"));
        super.method_7851(stack, world, tooltip, context);
    }

    public static int getStance(class_1799 stack) {
        return stack.method_7948().method_10550(STANCE_KEY);
    }

    public class_1271<class_1799> method_7836(class_1937 world, class_1657 user, class_1268 hand) {
        class_1799 stack = user.method_5998(hand);
        int stance = stack.method_7948().method_10550(STANCE_KEY);
        if (user.method_5715()) {
            stance = (stance + 1) % 3;
            stack.method_7948().method_10569(STANCE_KEY, stance);
            if (!world.field_9236) {
                world.method_8396(null, user.method_24515(), class_3417.field_15119, class_3419.field_15248, 1.0f, 1.0f);
                user.method_7353((class_2561)class_2561.method_43470((String)("\u00a77Stance: " + this.getStanceName(stance))), true);
            }
        } else if (user instanceof class_3222) {
            class_3222 player = (class_3222)user;
            switch (stance) {
                case 1: {
                    MonarchSwordComponent component = (MonarchSwordComponent)CosmicVailComponents.MonarchSwordComponent.get((Object)user);
                    if (component.isLightOnCooldown()) break;
                    user.method_6092(new class_1293(class_1294.field_5904, 60, 1));
                    user.method_5783(class_3417.field_14550, 1.0f, 1.8f);
                    component.setLightCooldown(120);
                    break;
                }
                case 2: {
                    MonarchSwordComponent component = (MonarchSwordComponent)CosmicVailComponents.MonarchSwordComponent.get((Object)user);
                    if (component.isDarkOnCooldown()) break;
                    user.method_6092(new class_1293(class_1294.field_5910, 80, 2));
                    user.method_5643(user.method_48923().method_48831(), 2.0f);
                    user.method_5783(class_3417.field_14792, 1.0f, 0.8f);
                    component.setDarkCooldown(140);
                    break;
                }
                default: {
                    MonarchSwordComponent component = (MonarchSwordComponent)CosmicVailComponents.MonarchSwordComponent.get((Object)user);
                    if (component.isBalancedOnCooldown()) break;
                    user.method_6092(new class_1293(class_1294.field_5907, 100, 1));
                    user.method_5783(class_3417.field_26980, 1.0f, 1.0f);
                    component.setBalancedCooldown(180);
                }
            }
        }
        return class_1271.method_29237((Object)stack, (boolean)world.method_8608());
    }

    private String getStanceName(int stance) {
        return switch (stance) {
            case 1 -> "\u00a7eLight";
            case 2 -> "\u00a75Dark";
            default -> "\u00a77Balanced";
        };
    }

    public boolean method_7873(class_1799 stack, class_1309 target, class_1309 attacker) {
        class_1937 world = attacker.method_37908();
        float brightness = (float)world.method_22339(class_2338.method_49638((class_2374)attacker.method_19538())) / 15.0f;
        float darkPower = 1.0f - brightness;
        if (!(target instanceof WeeperEntity)) {
            target.method_5643(world.method_48963().method_48812(attacker), this.method_8020() * (1.0f + darkPower * 0.5f));
        } else {
            class_1657 player;
            WeeperEntity weeper = (WeeperEntity)target;
            if (attacker instanceof class_1657 && !weeper.isOwner(player = (class_1657)attacker)) {
                target.method_5643(world.method_48963().method_48812(attacker), this.method_8020() * (1.0f + darkPower * 0.5f));
            }
        }
        if (attacker.method_5624() || attacker.field_6017 > 0.0f) {
            target.method_6092(new class_1293(class_1294.field_5919, 60, 0));
        }
        if (world.field_9236) {
            world.method_8406((class_2394)class_2398.field_11251, target.method_23317(), target.method_23318() + 1.0, target.method_23321(), 0.0, 0.02, 0.0);
        }
        return super.method_7873(stack, target, attacker);
    }
}

