/*
 * Decompiled with CFR 0.152.
 */
package com.cosmo.util;

import com.cosmo.CosmicVail;
import com.cosmo.CosmicVailComponents;
import com.cosmo.entity.custom.WeeperEntity;
import com.cosmo.init.BlockInit;
import com.cosmo.init.EntityInit;
import com.cosmo.init.ItemInit;
import com.cosmo.world.dimension.DimensionInit;
import dev.onyxstudios.cca.api.v3.component.sync.AutoSyncedComponent;
import dev.onyxstudios.cca.api.v3.component.tick.CommonTickingComponent;
import net.minecraft.class_1297;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_3218;
import net.minecraft.class_3730;

public class ShiftedComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 player;
    private boolean shiftToggled;
    private int remainingTrapTicks = 0;
    private int shiftedTimer = 0;
    private int weeperTimer = 0;
    private boolean shadowImbued;

    public ShiftedComponent(class_1657 player) {
        this.player = player;
        this.shiftToggled = false;
    }

    public boolean shouldSeeThrough() {
        return this.shiftedTimer > 0 && this.shiftToggled || this.player.method_6118(class_1304.field_6169).method_31574(ItemInit.SHADOW_HELMET) || class_1890.method_8222((class_1799)this.player.method_6118(class_1304.field_6169)).containsKey(CosmicVail.ShadowSight) || this.remainingTrapTicks > 0 || this.player.method_37908().method_8320(this.player.method_24515().method_10074()).method_27852(BlockInit.ShadowTransporter) || this.player.method_37908().method_8320(this.player.method_24515().method_10074()).method_27852(BlockInit.ShadowPortal);
    }

    public boolean isShifted() {
        return this.shiftedTimer > 0 && this.shiftToggled || this.remainingTrapTicks > 0 || this.player.method_37908().method_8320(this.player.method_24515().method_10074()).method_27852(BlockInit.ShadowTransporter) || this.player.method_37908().method_8320(this.player.method_24515().method_10074()).method_27852(BlockInit.ShadowPortal);
    }

    public boolean isFullyShifted() {
        return this.shiftedTimer > 0 && this.shiftToggled || this.remainingTrapTicks > 0;
    }

    public static boolean shiftedCheck(class_1297 entity, class_1297 entity1) {
        WeeperEntity weeper;
        if (entity instanceof class_1657) {
            class_1657 player1 = (class_1657)entity;
            if (class_1890.method_8222((class_1799)player1.method_6118(class_1304.field_6169)).containsKey(CosmicVail.ShadowSight) || player1.method_6118(class_1304.field_6169).method_31574(ItemInit.SHADOW_HELMET)) {
                return true;
            }
            boolean inShadowRealm = player1.method_37908().method_27983().equals(DimensionInit.SHADOW_REALM_LEVEL_KEY);
            boolean playerShifted = ((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player1)).isShifted();
            if (entity1 instanceof class_1657) {
                class_1657 player2 = (class_1657)entity1;
                boolean targetShifted = ((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player2)).isShifted();
                return playerShifted == targetShifted;
            }
            if (entity1 instanceof WeeperEntity) {
                WeeperEntity weeper2 = (WeeperEntity)entity1;
                return playerShifted != inShadowRealm || weeper2.isOwner(player1) || weeper2.isForcedTarget((class_1309)player1);
            }
            return !playerShifted;
        }
        if (entity instanceof WeeperEntity) {
            WeeperEntity weeper3 = (WeeperEntity)entity;
            if (!weeper3.hasOwner() && !weeper3.hasForcedTarget()) {
                boolean inShadowRealm = weeper3.method_37908().method_27983().equals(DimensionInit.SHADOW_REALM_LEVEL_KEY);
                if (entity1 instanceof class_1657) {
                    class_1657 player = (class_1657)entity1;
                    if (((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player)).shouldSeeThrough()) {
                        return true;
                    }
                    boolean targetShifted = ((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player)).isShifted();
                    if (!inShadowRealm && targetShifted) {
                        return true;
                    }
                    return inShadowRealm && !targetShifted;
                }
                if (entity1 instanceof WeeperEntity) {
                    WeeperEntity weeper1 = (WeeperEntity)entity1;
                    return true;
                }
                return false;
            }
            return true;
        }
        if (entity1 instanceof class_1657) {
            class_1657 player = (class_1657)entity1;
            return ((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player)).shouldSeeThrough() || !((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player)).isShifted();
        }
        if (entity1 instanceof WeeperEntity && (weeper = (WeeperEntity)entity1).hasOwner()) {
            return true;
        }
        return !(entity1 instanceof WeeperEntity);
    }

    public static boolean isPlayerShifted(class_1657 player) {
        return ((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player)).isShifted();
    }

    public static boolean isInShadowRealm(class_1297 entity) {
        return entity.method_37908().method_27983().equals(DimensionInit.SHADOW_REALM_LEVEL_KEY);
    }

    public static boolean playerMatchesWeeperPlane(class_1657 player) {
        boolean shifted = ShiftedComponent.isPlayerShifted(player);
        boolean inShadowRealm = ShiftedComponent.isInShadowRealm((class_1297)player);
        return shifted && !inShadowRealm || !shifted && inShadowRealm;
    }

    public static boolean playerMatchesPlayerPlane(class_1657 player, class_1657 otherPlayer) {
        boolean shifted = ShiftedComponent.isPlayerShifted(player);
        boolean otherShifted = ShiftedComponent.isPlayerShifted(otherPlayer);
        return shifted && otherShifted || !shifted && !otherShifted;
    }

    public static boolean playerVisibleToNormalEntity(class_1657 player) {
        return !ShiftedComponent.isPlayerShifted(player);
    }

    public static boolean canSeePlayer(class_1297 viewer, class_1297 target) {
        if (viewer instanceof class_1657) {
            class_1657 player = (class_1657)viewer;
            if (target instanceof WeeperEntity) {
                return ShiftedComponent.playerMatchesWeeperPlane(player);
            }
            if (target instanceof class_1657) {
                class_1657 player1 = (class_1657)target;
                return ShiftedComponent.playerMatchesPlayerPlane(player, player1);
            }
            return ShiftedComponent.playerVisibleToNormalEntity(player);
        }
        if (viewer instanceof WeeperEntity) {
            if (target instanceof class_1657) {
                class_1657 player = (class_1657)target;
                return ShiftedComponent.playerMatchesWeeperPlane(player);
            }
            return target instanceof WeeperEntity;
        }
        if (target instanceof class_1657) {
            class_1657 player = (class_1657)target;
            return ShiftedComponent.playerVisibleToNormalEntity(player);
        }
        return !(target instanceof WeeperEntity);
    }

    public void setRemainingTrapTicks(int ticks) {
        this.weeperTimer = 200;
        this.remainingTrapTicks = ticks;
        CosmicVailComponents.SHIFTED.sync((Object)this.player);
    }

    public void toggleShifted() {
        this.weeperTimer = 200;
        this.shiftToggled = !this.shiftToggled;
        CosmicVailComponents.SHIFTED.sync((Object)this.player);
    }

    public void setShiftedTimer(int value) {
        this.weeperTimer = 200;
        this.shiftedTimer = value;
        CosmicVailComponents.SHIFTED.sync((Object)this.player);
    }

    public void readFromNbt(class_2487 nbtCompound) {
        this.remainingTrapTicks = nbtCompound.method_10550("RemainingTrapTicks");
        this.shiftedTimer = nbtCompound.method_10550("shiftedTimer");
        this.shiftToggled = nbtCompound.method_10577("value");
        this.shadowImbued = nbtCompound.method_10577("imbued");
    }

    public void writeToNbt(class_2487 nbtCompound) {
        nbtCompound.method_10569("RemainingTrapTicks", this.remainingTrapTicks);
        nbtCompound.method_10569("shiftedTimer", this.shiftedTimer);
        nbtCompound.method_10556("value", this.shiftToggled);
        nbtCompound.method_10556("imbued", this.shadowImbued);
    }

    public void tick() {
        if (this.shiftToggled && !this.player.method_31548().method_7379(new class_1799((class_1935)ItemInit.ShadowMirror))) {
            this.shiftToggled = false;
        }
        if (this.isFullyShifted() && this.weeperTimer > 0) {
            --this.weeperTimer;
        } else if (this.isFullyShifted() && this.weeperTimer <= 0) {
            if (!this.player.method_37908().method_8608()) {
                WeeperEntity weeper = (WeeperEntity)EntityInit.WEEPER.method_47821((class_3218)this.player.method_37908(), this.player.method_24515(), class_3730.field_16467);
                this.player.method_37908().method_8649((class_1297)weeper);
                if (weeper != null) {
                    weeper.setForcedTarget(this.player);
                }
            }
            this.weeperTimer = 200;
            CosmicVailComponents.SHIFTED.sync((Object)this.player);
        }
        if (this.shiftedTimer > 0 && this.shiftToggled) {
            --this.shiftedTimer;
            CosmicVailComponents.SHIFTED.sync((Object)this.player);
        }
        if (this.shiftedTimer <= 0 && this.shiftToggled && !this.player.method_7357().method_7904(ItemInit.ShadowMirror)) {
            this.player.method_7357().method_7906(ItemInit.ShadowMirror, 200);
            this.shiftToggled = false;
        }
        if (this.remainingTrapTicks > 0) {
            --this.remainingTrapTicks;
        } else {
            this.remainingTrapTicks = 0;
            CosmicVailComponents.SHIFTED.sync((Object)this.player);
        }
    }

    public float getShiftedTimer() {
        return (float)this.shiftedTimer / 1000.0f;
    }

    public void setShadowImbued() {
        this.shadowImbued = !this.shadowImbued;
        CosmicVailComponents.SHIFTED.sync((Object)this.player);
    }

    public boolean shadowImbued() {
        return this.shadowImbued;
    }
}

