/*
 * Decompiled with CFR 0.152.
 */
package com.cosmo.util;

import java.util.Random;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.server.MinecraftServer;

public class TeleportUtils {
    private static final Random RANDOM = new Random();

    public static boolean teleportPlayerToDimension(class_3222 player, MinecraftServer server, class_5321<class_1937> targetDimension) {
        class_3218 targetWorld = server.method_3847(targetDimension);
        if (targetWorld == null) {
            return false;
        }
        class_2338 origin = player.method_24515();
        int dx = RANDOM.nextInt(201) - 100;
        int dz = RANDOM.nextInt(201) - 100;
        class_2338 candidatePos = origin.method_10069(dx, 0, dz);
        int minY = targetWorld.method_31607() + 1;
        int maxY = targetWorld.method_31600() - 2;
        int randomY = minY + RANDOM.nextInt(maxY - minY + 1);
        candidatePos = candidatePos.method_33096(randomY);
        if ((candidatePos = TeleportUtils.findSafePosition(targetWorld, candidatePos)) == null) {
            return false;
        }
        player.method_14251(targetWorld, (double)candidatePos.method_10263() + 0.5, (double)candidatePos.method_10264(), (double)candidatePos.method_10260() + 0.5, player.method_36454(), player.method_36455());
        player.field_6017 = 0.0f;
        return true;
    }

    public static class_2338 findSafePosition(class_3218 world, class_2338 pos) {
        int y;
        int minY = world.method_31607() + 1;
        int maxY = world.method_31600() - 2;
        for (y = pos.method_10264(); y <= maxY; ++y) {
            if (!TeleportUtils.isSafeAt(world, pos.method_33096(y))) continue;
            return pos.method_33096(y);
        }
        for (y = pos.method_10264() - 1; y >= minY; --y) {
            if (!TeleportUtils.isSafeAt(world, pos.method_33096(y))) continue;
            return pos.method_33096(y);
        }
        return null;
    }

    private static boolean isSafeAt(class_3218 world, class_2338 pos) {
        boolean solidGround = world.method_8320(pos.method_10074()).method_26212((class_1922)world, pos.method_10074());
        boolean spaceEmpty = world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215();
        return solidGround && spaceEmpty;
    }

    public static boolean teleportPlayerToDimension(class_3222 serverPlayerEntity, MinecraftServer server, class_2338 spawnPointPosition, class_5321<class_1937> registryKey) {
        class_3218 targetWorld = server.method_3847(registryKey);
        if (targetWorld == null || spawnPointPosition == null) {
            targetWorld = server.method_3847(class_1937.field_25179);
            spawnPointPosition = server.method_30002().method_43126();
        }
        serverPlayerEntity.method_14251(targetWorld, (double)spawnPointPosition.method_10263() + 0.5, (double)spawnPointPosition.method_10264(), (double)spawnPointPosition.method_10260() + 0.5, serverPlayerEntity.method_36454(), serverPlayerEntity.method_36455());
        serverPlayerEntity.field_6017 = 0.0f;
        return true;
    }
}

