/*
 * Decompiled with CFR 0.152.
 */
package com.cosmo.entity.custom;

import com.cosmo.CosmicVailComponents;
import com.cosmo.init.ItemInit;
import com.cosmo.util.ShiftedComponent;
import com.cosmo.world.dimension.DimensionInit;
import java.util.EnumSet;
import java.util.Optional;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1267;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1366;
import net.minecraft.class_1376;
import net.minecraft.class_1394;
import net.minecraft.class_1399;
import net.minecraft.class_14;
import net.minecraft.class_1405;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1409;
import net.minecraft.class_1588;
import net.minecraft.class_1657;
import net.minecraft.class_1920;
import net.minecraft.class_1922;
import net.minecraft.class_1928;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2397;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3321;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3730;
import net.minecraft.class_4050;
import net.minecraft.class_4051;
import net.minecraft.class_4538;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_7;
import net.minecraft.class_7094;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;

public class WeeperEntity
extends class_1314 {
    public final class_7094 idleAnimationState = new class_7094();
    public final class_7094 ChaseingAnimationState = new class_7094();
    private int idleAnimationTimeout = 0;
    protected static final class_2940<Optional<UUID>> TARGET_UUID = class_2945.method_12791(WeeperEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> CHASING = class_2945.method_12791(WeeperEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Optional<UUID>> OWNER_UUID = class_2945.method_12791(WeeperEntity.class, (class_2941)class_2943.field_13313);
    private static final class_2940<Boolean> SITTING = class_2945.method_12791(WeeperEntity.class, (class_2941)class_2943.field_13323);

    public WeeperEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
    }

    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(TARGET_UUID, Optional.empty());
        this.field_6011.method_12784(CHASING, (Object)false);
        this.field_6011.method_12784(OWNER_UUID, Optional.empty());
        this.field_6011.method_12784(SITTING, (Object)false);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        if (this.getForcedTargetUuid() != null) {
            nbt.method_25927("ForcedTarget", this.getForcedTargetUuid());
        }
        if (this.getOwnerUuid() != null) {
            nbt.method_25927("Owner", this.getOwnerUuid());
            nbt.method_10556("IsTamed", true);
        } else {
            nbt.method_10556("IsTamed", false);
        }
        nbt.method_10556("Sitting", this.isSitting());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        if (nbt.method_25928("ForcedTarget")) {
            UUID forced = nbt.method_25926("ForcedTarget");
            this.setForcedTargetUuid(forced);
        } else if (nbt.method_10545("ForcedTarget")) {
            String s = nbt.method_10558("ForcedTarget");
            UUID forced = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)s);
            if (forced != null) {
                this.setForcedTargetUuid(forced);
            }
        }
        if (nbt.method_25928("Owner")) {
            UUID owner = nbt.method_25926("Owner");
            this.setOwnerUuid(owner);
            this.method_5971();
        } else if (nbt.method_10545("Owner")) {
            String ownerName = nbt.method_10558("Owner");
            UUID ownerUuid = class_3321.method_14546((MinecraftServer)this.method_5682(), (String)ownerName);
            if (ownerUuid != null) {
                this.setOwnerUuid(ownerUuid);
                this.method_5971();
            }
        }
        if (nbt.method_10545("Sitting")) {
            this.setSitting(nbt.method_10577("Sitting"));
        }
    }

    @Nullable
    public UUID getForcedTargetUuid() {
        return ((Optional)this.field_6011.method_12789(TARGET_UUID)).orElse(null);
    }

    public boolean hasForcedTarget() {
        return this.getForcedTarget() != null;
    }

    public void setForcedTargetUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(TARGET_UUID, Optional.ofNullable(uuid));
    }

    public void setForcedTarget(class_1657 player) {
        this.setForcedTargetUuid(player.method_5667());
    }

    @Nullable
    public class_1309 getForcedTarget() {
        UUID uUID = this.getForcedTargetUuid();
        return uUID == null ? null : this.method_37908().method_18470(uUID);
    }

    @Nullable
    public UUID getOwnerUuid() {
        return ((Optional)this.field_6011.method_12789(OWNER_UUID)).orElse(null);
    }

    public void setOwnerUuid(@Nullable UUID uuid) {
        this.field_6011.method_12778(OWNER_UUID, Optional.ofNullable(uuid));
        if (uuid != null) {
            this.method_5971();
        }
    }

    @Nullable
    public class_1657 getOwner() {
        UUID uuid = this.getOwnerUuid();
        if (uuid == null) {
            return null;
        }
        class_1937 world = this.method_37908();
        if (world == null) {
            return null;
        }
        return world.method_18470(uuid);
    }

    public void setOwner(class_1657 player) {
        if (player != null) {
            this.setOwnerUuid(player.method_5667());
        } else {
            this.setOwnerUuid(null);
        }
    }

    public boolean isOwner(class_1657 player) {
        if (player == null) {
            return false;
        }
        UUID ownerUuid = this.getOwnerUuid();
        return ownerUuid != null && ownerUuid.equals(player.method_5667());
    }

    public boolean isSitting() {
        return (Boolean)this.field_6011.method_12789(SITTING);
    }

    public void setSitting(boolean sit) {
        this.field_6011.method_12778(SITTING, (Object)sit);
        if (sit) {
            this.method_5942().method_6340();
        }
    }

    public void method_6078(class_1282 damageSource) {
        if (!this.method_37908().field_9236 && this.method_37908().method_8450().method_8355(class_1928.field_19398) && this.getOwner() instanceof class_3222) {
            this.getOwner().method_43496(this.method_6066().method_5548());
        }
        super.method_6078(damageSource);
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (this.isOwner(player)) {
            this.setSitting(!this.isSitting());
            this.field_6282 = false;
            this.method_5942().method_6340();
            this.method_5980(null);
            return class_1269.field_5812;
        }
        return super.method_5992(player, hand);
    }

    public void method_6007() {
        super.method_6007();
    }

    public void method_6087(class_1297 entity) {
        if (ShiftedComponent.canSeePlayer((class_1297)this, entity)) {
            super.method_6087(entity);
        }
    }

    public boolean method_5863() {
        class_1657 owner = this.getOwner();
        class_1309 target = this.getForcedTarget();
        if (this.method_37908().field_9236 && class_310.method_1551().field_1724 != null && class_310.method_1551().field_1687 != null && !class_310.method_1551().field_1687.method_27983().equals(DimensionInit.SHADOW_REALM_LEVEL_KEY)) {
            return ((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)class_310.method_1551().field_1724)).shouldSeeThrough() || class_310.method_1551().field_1724 == target || class_310.method_1551().field_1724 == owner;
        }
        return true;
    }

    protected static boolean isLightLevelValidForNaturalSpawn(class_1920 world, class_2338 pos) {
        return world.method_22335(pos, 0) > 8;
    }

    public void method_5697(class_1297 entity) {
        if (ShiftedComponent.canSeePlayer((class_1297)this, entity)) {
            super.method_5697(entity);
        }
    }

    public void method_5980(@Nullable class_1309 target) {
        class_1657 player;
        if (target instanceof class_1657 && this.isOwner(player = (class_1657)target)) {
            super.method_5980(null);
            return;
        }
        if (this.hasForcedTarget()) {
            super.method_5980(this.getForcedTarget());
            this.field_6011.method_12778(CHASING, (Object)true);
        } else {
            super.method_5980(target);
            this.field_6011.method_12778(CHASING, (Object)(target != null && target.method_5805() ? 1 : 0));
        }
    }

    public boolean isChasing() {
        return (Boolean)this.field_6011.method_12789(CHASING);
    }

    private void setupAnimationStates() {
        if (this.method_5968() != null) {
            this.idleAnimationState.method_41325();
            this.ChaseingAnimationState.method_41322(this.field_6012);
        } else {
            if (this.idleAnimationTimeout <= 0) {
                this.idleAnimationTimeout = 40;
                this.idleAnimationState.method_41322(this.field_6012);
            } else {
                --this.idleAnimationTimeout;
            }
            this.ChaseingAnimationState.method_41325();
        }
    }

    protected void method_48565(float limbDistance) {
        float f = this.method_18376() == class_4050.field_18076 ? Math.min(limbDistance * 6.0f, 1.0f) : 0.0f;
        this.field_42108.method_48568(f, 0.2f);
    }

    public void method_5773() {
        super.method_5773();
        if (this.method_37908().field_9236) {
            this.setupAnimationStates();
        }
    }

    public boolean method_5756(class_1657 player) {
        if (!(player.method_37908() == null || player.method_37908().method_27983().equals(DimensionInit.SHADOW_REALM_LEVEL_KEY) || ((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player)).isShifted() || this.isOwner(player) || this.isForcedTarget((class_1309)player))) {
            return true;
        }
        return super.method_5756(player);
    }

    protected void method_5623(double fallDistance, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new SitGoalWrapper(this));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(8, (class_1352)new class_1361((class_1308)this, class_1657.class, 100.0f));
        this.field_6201.method_6277(8, (class_1352)new class_1376((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new class_1399((class_1314)this, new Class[0]));
        this.field_6201.method_6277(2, (class_1352)new class_1394((class_1314)this, 1.0, 0.0f));
        this.field_6201.method_6277(0, (class_1352)new WeeperFollowOwnerGoal(this, 3.0, 10.0f, 2.0f, true));
        this.initCustomGoals();
    }

    protected void initCustomGoals() {
        this.field_6201.method_6277(1, (class_1352)new class_1366((class_1314)this, 3.0, false));
        this.field_6201.method_6277(1, (class_1352)new AttackWithOwnerGoalWeeper(this));
        this.field_6185.method_6277(2, new WeeperActiveTargetGoal<class_1657>(this, class_1657.class, true));
    }

    public static class_5132.class_5133 createWeeperAttributes() {
        return class_1588.method_26918().method_26868(class_5134.field_23716, 30.0).method_26868(class_5134.field_23719, (double)0.2f).method_26868(class_5134.field_23724, 0.5).method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23721, 4.0);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (this.method_37908().method_8608()) {
            if (class_310.method_1551().field_1724 == null) {
                return;
            }
            if (((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)class_310.method_1551().field_1724)).shouldSeeThrough()) {
                class_2498 blockSoundGroup = state.method_26231();
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), blockSoundGroup.method_10594(), class_3419.field_15256, blockSoundGroup.method_10597() * 0.15f, blockSoundGroup.method_10599(), true);
            }
        }
    }

    public void method_5966() {
        if (this.method_37908().method_8608()) {
            class_3414 soundEvent;
            if (class_310.method_1551().field_1724 == null) {
                return;
            }
            if (((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)class_310.method_1551().field_1724)).shouldSeeThrough() && (soundEvent = this.method_5994()) != null) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, class_3419.field_15256, this.method_6107(), this.method_6017(), true);
            }
        }
    }

    @Nullable
    protected class_3414 method_5994() {
        return class_3417.field_14696;
    }

    protected void method_6013(class_1282 source) {
        if (this.method_37908().method_8608()) {
            class_3414 soundEvent;
            if (class_310.method_1551().field_1724 == null) {
                return;
            }
            if (((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)class_310.method_1551().field_1724)).shouldSeeThrough() && (soundEvent = this.method_6011(source)) != null) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, class_3419.field_15256, this.method_6107(), this.method_6017(), true);
            }
        }
    }

    @Nullable
    protected class_3414 method_6011(class_1282 source) {
        return class_3417.field_14797;
    }

    protected void method_51295() {
        if (this.method_37908().method_8608()) {
            class_3414 soundEvent;
            if (class_310.method_1551().field_1724 == null) {
                return;
            }
            if (((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)class_310.method_1551().field_1724)).shouldSeeThrough() && (soundEvent = this.method_5737()) != null) {
                this.method_37908().method_8486(this.method_23317(), this.method_23318(), this.method_23321(), soundEvent, class_3419.field_15256, this.method_6107(), this.method_6017(), true);
            }
        }
    }

    public boolean hasOwner() {
        return this.getOwnerUuid() != null;
    }

    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_6047().method_31574(ItemInit.MonarchsSword) && this.isOwner(player)) {
            class_1937 class_19372 = this.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                serverWorld.method_14199((class_2394)class_2398.field_11201, this.method_23317(), this.method_23318(), this.method_23321(), 10, 0.0, 0.0, 0.0, 0.0);
            }
            this.method_6025(4.0f);
            return false;
        }
        return super.method_5643(source, amount);
    }

    public boolean method_18395(class_1309 target) {
        class_1657 player;
        if (this.getOwner() != null && !this.getOwner().method_5805()) {
            return false;
        }
        if (this.getOwner() != null) {
            return super.method_18395(target);
        }
        if (target == this.getForcedTarget()) {
            return true;
        }
        if (target instanceof class_1657 && (player = (class_1657)target).method_37908() != null && !player.method_37908().method_27983().equals(DimensionInit.SHADOW_REALM_LEVEL_KEY)) {
            if (((ShiftedComponent)CosmicVailComponents.SHIFTED.get((Object)player)).shouldSeeThrough() && !this.isOwner(player)) {
                return this.method_37908().method_8407() != class_1267.field_5801 && target.method_33190();
            }
            return false;
        }
        return super.method_18395(target);
    }

    public static boolean canSpawnInDark(class_1299<? extends WeeperEntity> type, class_5425 world, class_3730 spawnReason, class_2338 pos, class_5819 random) {
        return WeeperEntity.isSpawnDark(world, pos, random) && WeeperEntity.method_20636(type, (class_1936)world, (class_3730)spawnReason, (class_2338)pos, (class_5819)random);
    }

    public static boolean isSpawnDark(class_5425 world, class_2338 pos, class_5819 random) {
        if (world.method_8314(class_1944.field_9284, pos) > random.method_43048(32)) {
            return false;
        }
        class_2874 dimensionType = world.method_8597();
        int i = dimensionType.method_44223();
        if (i < 15 && world.method_8314(class_1944.field_9282, pos) > i) {
            return false;
        }
        int j = world.method_8410().method_8546() ? world.method_22346(pos, 10) : world.method_22339(pos);
        return j <= dimensionType.method_44222().method_35008(random);
    }

    public boolean isForcedTarget(class_1309 entity) {
        return entity == this.getForcedTarget();
    }

    protected void method_5958() {
        class_1309 class_13092 = this.getForcedTarget();
        if (class_13092 instanceof class_3222) {
            class_3222 player = (class_3222)class_13092;
            class_3218 playerWorld = player.method_51469();
            if (!player.field_13987.method_48106()) {
                this.method_31472();
                return;
            }
            if (playerWorld != this.method_37908()) {
                this.method_31472();
                return;
            }
        }
        if (this.hasForcedTarget() && !this.getForcedTarget().method_5805()) {
            this.method_31472();
            return;
        }
        super.method_5958();
    }

    public static class SitGoalWrapper
    extends class_1352 {
        private final WeeperEntity mob;

        public SitGoalWrapper(WeeperEntity mob) {
            this.mob = mob;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18407, class_1352.class_4134.field_18405));
        }

        public boolean method_6264() {
            return this.mob.isSitting();
        }

        public void method_6269() {
            this.mob.method_5942().method_6340();
        }

        public boolean method_6266() {
            return this.mob.isSitting();
        }
    }

    public static class WeeperFollowOwnerGoal
    extends class_1352 {
        public static final int TELEPORT_DISTANCE = 12;
        private static final int HORIZONTAL_RANGE = 2;
        private static final int HORIZONTAL_VARIATION = 3;
        private static final int VERTICAL_VARIATION = 1;
        private final WeeperEntity tameable;
        private class_1309 owner;
        private final class_4538 world;
        private final double speed;
        private final class_1408 navigation;
        private int updateCountdownTicks;
        private final float maxDistance;
        private final float minDistance;
        private float oldWaterPathfindingPenalty;
        private final boolean leavesAllowed;

        public WeeperFollowOwnerGoal(WeeperEntity tameable, double speed, float minDistance, float maxDistance, boolean leavesAllowed) {
            this.tameable = tameable;
            this.world = tameable.method_37908();
            this.speed = speed;
            this.navigation = tameable.method_5942();
            this.minDistance = minDistance;
            this.maxDistance = maxDistance;
            this.leavesAllowed = leavesAllowed;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
            if (!(tameable.method_5942() instanceof class_1409) && !(tameable.method_5942() instanceof class_1407)) {
                throw new IllegalArgumentException("Unsupported mob type for FollowOwnerGoal");
            }
        }

        public boolean method_6264() {
            class_1657 livingEntity = this.tameable.getOwner();
            if (livingEntity == null) {
                return false;
            }
            if (livingEntity.method_7325()) {
                return false;
            }
            if (this.cannotFollow()) {
                return false;
            }
            if (this.tameable.method_5858((class_1297)livingEntity) < (double)(this.minDistance * this.minDistance)) {
                return false;
            }
            this.owner = livingEntity;
            return true;
        }

        public boolean method_6266() {
            if (this.navigation.method_6357()) {
                return false;
            }
            if (this.cannotFollow()) {
                return false;
            }
            return !(this.tameable.method_5858((class_1297)this.owner) <= (double)(this.maxDistance * this.maxDistance));
        }

        private boolean cannotFollow() {
            return this.tameable.isSitting() || this.tameable.method_5765() || this.tameable.method_5934();
        }

        public void method_6269() {
            this.updateCountdownTicks = 0;
            this.oldWaterPathfindingPenalty = this.tameable.method_5944(class_7.field_18);
            this.tameable.method_5941(class_7.field_18, 0.0f);
        }

        public void method_6270() {
            this.owner = null;
            this.navigation.method_6340();
            this.tameable.method_5941(class_7.field_18, this.oldWaterPathfindingPenalty);
        }

        public void method_6268() {
            this.tameable.method_5988().method_6226((class_1297)this.owner, 10.0f, (float)this.tameable.method_5978());
            if (--this.updateCountdownTicks <= 0) {
                this.updateCountdownTicks = this.method_38847(10);
                if (this.tameable.method_5858((class_1297)this.owner) >= 144.0) {
                    this.tryTeleport();
                } else {
                    this.navigation.method_6335((class_1297)this.owner, this.speed);
                }
            }
        }

        private void tryTeleport() {
            class_2338 blockPos = this.owner.method_24515();
            for (int i = 0; i < 10; ++i) {
                int j = this.getRandomInt(-3, 3);
                int k = this.getRandomInt(-1, 1);
                int l = this.getRandomInt(-3, 3);
                boolean bl = this.tryTeleportTo(blockPos.method_10263() + j, blockPos.method_10264() + k, blockPos.method_10260() + l);
                if (!bl) continue;
                return;
            }
        }

        private boolean tryTeleportTo(int x, int y, int z) {
            if (Math.abs((double)x - this.owner.method_23317()) < 2.0 && Math.abs((double)z - this.owner.method_23321()) < 2.0) {
                return false;
            }
            if (!this.canTeleportTo(new class_2338(x, y, z))) {
                return false;
            }
            this.tameable.method_5808((double)x + 0.5, y, (double)z + 0.5, this.tameable.method_36454(), this.tameable.method_36455());
            this.navigation.method_6340();
            return true;
        }

        private boolean canTeleportTo(class_2338 pos) {
            class_7 pathNodeType = class_14.method_23476((class_1922)this.world, (class_2338.class_2339)pos.method_25503());
            if (pathNodeType != class_7.field_12) {
                return false;
            }
            class_2680 blockState = this.world.method_8320(pos.method_10074());
            if (!this.leavesAllowed && blockState.method_26204() instanceof class_2397) {
                return false;
            }
            class_2338 blockPos = pos.method_10059((class_2382)this.tameable.method_24515());
            return this.world.method_8587((class_1297)this.tameable, this.tameable.method_5829().method_996(blockPos));
        }

        private int getRandomInt(int min, int max) {
            return this.tameable.method_6051().method_43048(max - min + 1) + min;
        }
    }

    public static class AttackWithOwnerGoalWeeper
    extends class_1405 {
        private final WeeperEntity tameable;
        private class_1309 attacking;
        private int lastAttackTime;

        public AttackWithOwnerGoalWeeper(WeeperEntity tameable) {
            super((class_1308)tameable, false);
            this.tameable = tameable;
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
        }

        public boolean method_6264() {
            if (this.tameable.getOwner() != null && !this.tameable.isSitting()) {
                class_1657 livingEntity = this.tameable.getOwner();
                if (livingEntity == null) {
                    return false;
                }
                this.attacking = livingEntity.method_6052();
                int i = livingEntity.method_6083();
                return i != this.lastAttackTime && this.method_6328(this.attacking, class_4051.field_18092);
            }
            return false;
        }

        public void method_6269() {
            this.field_6660.method_5980(this.attacking);
            class_1657 livingEntity = this.tameable.getOwner();
            if (livingEntity != null) {
                this.lastAttackTime = livingEntity.method_6083();
            }
            super.method_6269();
        }
    }

    public static class WeeperActiveTargetGoal<T extends class_1309>
    extends class_1405 {
        private static final int DEFAULT_RECIPROCAL_CHANCE = 10;
        protected final Class<T> targetClass;
        protected final int reciprocalChance;
        @Nullable
        protected class_1309 targetEntity;
        protected class_4051 targetPredicate;

        public WeeperActiveTargetGoal(WeeperEntity mob, Class<T> targetClass, boolean checkVisibility) {
            this(mob, targetClass, 10, checkVisibility, false, null);
        }

        public WeeperActiveTargetGoal(WeeperEntity mob, Class<T> targetClass, boolean checkVisibility, Predicate<class_1309> targetPredicate) {
            this(mob, targetClass, 10, checkVisibility, false, targetPredicate);
        }

        public WeeperActiveTargetGoal(WeeperEntity mob, Class<T> targetClass, boolean checkVisibility, boolean checkCanNavigate) {
            this(mob, targetClass, 10, checkVisibility, checkCanNavigate, null);
        }

        public WeeperActiveTargetGoal(WeeperEntity mob, Class<T> targetClass, int reciprocalChance, boolean checkVisibility, boolean checkCanNavigate, @Nullable Predicate<class_1309> targetPredicate) {
            super((class_1308)mob, checkVisibility, checkCanNavigate);
            this.targetClass = targetClass;
            this.reciprocalChance = WeeperActiveTargetGoal.method_38848((int)reciprocalChance);
            this.method_6265(EnumSet.of(class_1352.class_4134.field_18408));
            this.targetPredicate = class_4051.method_36625().method_18418(this.method_6326()).method_18420(targetPredicate);
        }

        public boolean method_6264() {
            WeeperEntity weeper;
            class_1308 class_13082 = this.field_6660;
            if (class_13082 instanceof WeeperEntity && (weeper = (WeeperEntity)class_13082).hasOwner()) {
                return false;
            }
            if (this.reciprocalChance > 0 && this.field_6660.method_6051().method_43048(this.reciprocalChance) != 0) {
                return false;
            }
            this.findClosestTarget();
            return this.targetEntity != null;
        }

        protected class_238 getSearchBox(double distance) {
            return this.field_6660.method_5829().method_1009(distance, 4.0, distance);
        }

        protected void findClosestTarget() {
            if (this.targetClass != class_1657.class && this.targetClass != class_3222.class) {
                WeeperEntity weeper;
                class_1308 class_13082 = this.field_6660;
                if (class_13082 instanceof WeeperEntity && (weeper = (WeeperEntity)class_13082).hasForcedTarget()) {
                    this.targetEntity = weeper.getForcedTarget();
                }
                this.targetEntity = this.field_6660.method_37908().method_18468(this.field_6660.method_37908().method_8390(this.targetClass, this.getSearchBox(this.method_6326()), livingEntity -> true), this.targetPredicate, (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321());
            } else {
                this.targetEntity = this.field_6660.method_37908().method_18463(this.targetPredicate, (class_1309)this.field_6660, this.field_6660.method_23317(), this.field_6660.method_23320(), this.field_6660.method_23321());
            }
        }

        public void method_6269() {
            this.field_6660.method_5980(this.targetEntity);
            super.method_6269();
        }

        public void setTargetEntity(@Nullable class_1309 targetEntity) {
            this.targetEntity = targetEntity;
        }
    }
}

