/*
 * Decompiled with CFR 0.152.
 */
package com.cosmo.world.generator;

import com.cosmo.init.BlockInit;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import net.minecraft.class_1923;
import net.minecraft.class_1966;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2791;
import net.minecraft.class_2794;
import net.minecraft.class_2893;
import net.minecraft.class_2902;
import net.minecraft.class_3233;
import net.minecraft.class_3756;
import net.minecraft.class_4543;
import net.minecraft.class_4966;
import net.minecraft.class_5138;
import net.minecraft.class_5539;
import net.minecraft.class_5819;
import net.minecraft.class_6748;
import net.minecraft.class_7138;

public class ShadowRealmChunkGenerator
extends class_2794 {
    public static final Codec<ShadowRealmChunkGenerator> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1966.field_24713.fieldOf("biome_source").forGetter(class_2794::method_12098), (App)Codec.INT.fieldOf("world_height").forGetter(ShadowRealmChunkGenerator::method_12104)).apply((Applicative)instance, ShadowRealmChunkGenerator::new));
    private final int worldHeight;
    private final class_3756 heightNoise;
    private final class_3756 floorNoise;
    private final class_5819 random;

    public ShadowRealmChunkGenerator(class_1966 biomeSource, int worldHeight) {
        super(biomeSource);
        this.worldHeight = worldHeight;
        long seed = 12345L;
        this.random = class_5819.method_43049((long)seed);
        this.heightNoise = new class_3756(this.random);
        class_5819 random_floor = class_5819.method_43049((long)seed);
        long seedCave = 98765L;
        class_5819 randomCave = class_5819.method_43049((long)seedCave);
        class_5819 randomLargeCave = class_5819.method_43049((long)seedCave);
        this.floorNoise = new class_3756(random_floor);
        new class_3756(randomCave);
        new class_3756(randomLargeCave);
    }

    protected Codec<? extends class_2794> method_28506() {
        return CODEC;
    }

    public void method_12108(class_3233 chunkRegion, long seed, class_7138 noiseConfig, class_4543 biomeAccess, class_5138 structureAccessor, class_2791 chunk, class_2893.class_2894 carverStep) {
    }

    public void method_12110(class_3233 region, class_5138 structures, class_7138 noiseConfig, class_2791 chunk) {
    }

    public CompletableFuture<class_2791> method_38275(Executor executor, class_7138 noiseConfig, class_6748 blender, class_5138 structureAccessor, class_2791 chunk) {
        return super.method_38275(executor, noiseConfig, blender, structureAccessor, chunk);
    }

    public void method_12107(class_3233 region) {
    }

    public int method_12104() {
        return this.worldHeight;
    }

    public CompletableFuture<class_2791> method_12088(Executor executor, class_6748 blender, class_7138 noiseConfig, class_5138 structureAccessor, class_2791 chunk) {
        class_1923 chunkPos = chunk.method_12004();
        class_2338.class_2339 blockPos = new class_2338.class_2339();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                int y;
                int worldX = chunkPos.method_8326() + x;
                int worldZ = chunkPos.method_8328() + z;
                double heightNoiseVal = this.heightNoise.method_33658((double)worldX * 0.03, 0.0, (double)worldZ * 0.03);
                int surfaceY = (int)(heightNoiseVal * 5.0);
                double floorNoiseVal = this.floorNoise.method_33658((double)worldX * 0.02, 0.0, (double)worldZ * 0.02);
                int floorY = chunk.method_31607();
                for (y = 80 + surfaceY; y > 70 + surfaceY; --y) {
                    blockPos.method_10103(worldX, y, worldZ);
                    this.placeNoiseBlocks(chunk, (class_2338)blockPos, worldX, worldZ);
                }
                for (y = 45 + surfaceY; y > 40 + surfaceY; --y) {
                    blockPos.method_10103(worldX, y, worldZ);
                    this.placeNoiseBlocks(chunk, (class_2338)blockPos, worldX, worldZ);
                }
                for (y = 10 + surfaceY; y > 5 + surfaceY; --y) {
                    blockPos.method_10103(worldX, y, worldZ);
                    this.placeNoiseBlocks(chunk, (class_2338)blockPos, worldX, worldZ);
                }
                for (y = -25 + surfaceY; y > -30 + surfaceY; --y) {
                    blockPos.method_10103(worldX, y, worldZ);
                    this.placeNoiseBlocks(chunk, (class_2338)blockPos, worldX, worldZ);
                }
                for (y = floorY; y < floorY + (int)(floorNoiseVal * 3.0) + 10; ++y) {
                    blockPos.method_10103(worldX, y, worldZ);
                    this.placeNoiseBlocks(chunk, (class_2338)blockPos, worldX, worldZ);
                }
                chunk.method_12010(new class_2338(worldX, floorY, worldZ), class_2246.field_9987.method_9564(), false);
            }
        }
        return CompletableFuture.completedFuture(chunk);
    }

    public int method_16398() {
        return -65;
    }

    private void placeNoiseBlocks(class_2791 chunk, class_2338 blockPos, float worldX, float worldZ) {
        double floor_noiseScale = 0.05;
        double floor_noiseValue = this.floorNoise.method_33658((double)worldX * floor_noiseScale, (double)blockPos.method_10264() * floor_noiseScale, (double)worldZ * floor_noiseScale);
        double floor_noise_val = floor_noiseValue + (double)this.random.method_39332(-1, 1) / 10.0;
        if (floor_noise_val > 0.0) {
            chunk.method_12010(blockPos, BlockInit.RedShadowRock.method_9564(), false);
        } else if (floor_noise_val > -0.2) {
            chunk.method_12010(blockPos, BlockInit.DarkShadowRock.method_9564(), false);
        } else {
            chunk.method_12010(blockPos, BlockInit.LightShadowRock.method_9564(), false);
        }
    }

    public int method_33730() {
        return 0;
    }

    public int method_16397(int x, int z, class_2902.class_2903 heightmap, class_5539 world, class_7138 noiseConfig) {
        double heightNoiseVal = this.heightNoise.method_33658((double)x * 0.03, 0.0, (double)z * 0.03);
        int surfaceY = (int)(heightNoiseVal * 5.0);
        return 80 + surfaceY;
    }

    public class_4966 method_26261(int x, int z, class_5539 world, class_7138 noiseConfig) {
        return null;
    }

    public void method_40450(List<String> text, class_7138 noiseConfig, class_2338 pos) {
    }
}

