/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.entity.ai.pathing.CachedPathHolder;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesCriterias;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.faboslav.friendsandfoes.common.util.MovementUtil;
import com.faboslav.friendsandfoes.common.util.RandomGenerator;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.faboslav.friendsandfoes.common.versions.VersionedInteractionResult;
import com.faboslav.friendsandfoes.common.versions.VersionedProfilerProvider;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import java.util.function.Predicate;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1313;
import net.minecraft.class_1315;
import net.minecraft.class_1321;
import net.minecraft.class_1331;
import net.minecraft.class_1407;
import net.minecraft.class_1408;
import net.minecraft.class_1429;
import net.minecraft.class_1432;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2131;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2392;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2400;
import net.minecraft.class_241;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3414;
import net.minecraft.class_3611;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4174;
import net.minecraft.class_4208;
import net.minecraft.class_4209;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5803;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_9334;
import org.jetbrains.annotations.Nullable;

public final class GlareEntity
extends class_1321
implements class_1432,
AnimatedEntity {
    public static final float ADULT_SCALE = 0.8f;
    public static final float BABY_SCALE = 0.4f;
    private static final class_2382 ITEM_PICKUP_RANGE_EXPANDER = new class_2382(1, 1, 1);
    public static final Predicate<class_1542> PICKABLE_FOOD_FILTER;
    private static final int GRUMPY_BITMASK = 2;
    private static final float MOVEMENT_SPEED = 0.1f;
    public static final int MIN_EYE_ANIMATION_TICK_AMOUNT = 10;
    public static final int LIGHT_THRESHOLD = 5;
    private static final class_2940<Byte> GLARE_FLAGS;
    private class_241 targetEyesPositionOffset;
    public CachedPathHolder cachedPathHolder = new CachedPathHolder();
    private AnimationContextTracker animationContextTracker;

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<AnimationHolder> getTrackedAnimations() {
        return new ArrayList<AnimationHolder>();
    }

    @Override
    public AnimationHolder getMovementAnimation() {
        return null;
    }

    @Override
    public int getCurrentAnimationTick() {
        return 0;
    }

    @Override
    public void setCurrentAnimationTick(int currentAnimationTick) {
    }

    @Override
    @Nullable
    public AnimationHolder getAnimationByPose() {
        return null;
    }

    public GlareEntity(class_1299<? extends GlareEntity> entityType, class_1937 world) {
        super(entityType, world);
        this.method_6173(false, false);
        this.field_6207 = new GlareMoveControl(this, 24, true);
        this.method_5941(class_7.field_9, -1.0f);
        this.method_5941(class_7.field_18, -1.0f);
        this.method_5941(class_7.field_14, -1.0f);
        this.method_5941(class_7.field_4, 16.0f);
        this.method_5941(class_7.field_21516, -1.0f);
        this.method_5941(class_7.field_10, -1.0f);
        this.method_5952(true);
        this.targetEyesPositionOffset = new class_241(0.0f, 0.0f);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        GlareBrain.setDarkSpotLocatingCooldown(this);
        GlareBrain.setLocatingGlowBerriesCooldown(this);
        GlareBrain.setItemPickupCooldown(this);
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(GLARE_FLAGS, (Object)0);
    }

    private boolean hasGlareFlag(int bitmask) {
        return ((Byte)this.field_6011.method_12789(GLARE_FLAGS) & bitmask) != 0;
    }

    private void setGlareFlag(int bitmask, boolean value) {
        byte glareFlags = (Byte)this.field_6011.method_12789(GLARE_FLAGS);
        if (value) {
            this.field_6011.method_12778(GLARE_FLAGS, (Object)((byte)(glareFlags | bitmask)));
        } else {
            this.field_6011.method_12778(GLARE_FLAGS, (Object)((byte)(glareFlags & ~bitmask)));
        }
    }

    public static boolean canSpawn(class_1299<GlareEntity> glareEntityEntityType, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 blockPos, class_5819 random) {
        class_2680 blockState = serverWorldAccess.method_8320(blockPos.method_10074());
        boolean isBelowSurfaceLevel = blockPos.method_10264() < 63;
        boolean isSkyHidden = !serverWorldAccess.method_8311(blockPos);
        boolean isBlockPosLightEnough = serverWorldAccess.method_22346(blockPos, 0) > 5;
        boolean isRelatedBlock = blockState.method_26164(FriendsAndFoesTags.GLARES_SPAWNABLE_ON);
        return isBelowSurfaceLevel && isRelatedBlock && isSkyHidden && isBlockPosLightEnough;
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().method_8608() && this.method_5805() && this.field_6012 % 10 == 0) {
            this.method_6025(1.0f);
        }
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableGlare) {
            this.method_31472();
        }
        super.method_5773();
        this.updateTargetEyesPositionOffset();
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = VersionedProfilerProvider.getProfiler((class_1297)this);
        profiler.method_15396("glareBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("glareMemoryUpdate");
        GlareBrain.updateMemories(this);
        profiler.method_15407();
        profiler.method_15396("glareActivityUpdate");
        GlareBrain.updateActivities(this);
        profiler.method_15407();
        super.method_5958(level);
    }

    public void method_6091(class_243 movementInput) {
        if (!this.method_5787()) {
            return;
        }
        if (this.method_5799()) {
            this.method_5724(0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021((double)0.8f));
        } else if (this.method_5771()) {
            this.method_5724(0.02f, movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021(0.5));
        } else {
            this.method_5724(this.method_6029(), movementInput);
            this.method_5784(class_1313.field_6308, this.method_18798());
            this.method_18799(this.method_18798().method_1021((double)0.91f));
        }
    }

    protected class_2382 method_42646() {
        return ITEM_PICKUP_RANGE_EXPANDER;
    }

    public boolean method_20820(class_3218 level, class_1799 itemStack) {
        return !itemStack.method_7960() && itemStack.method_7909() == class_1802.field_28659 && super.method_20820(level, itemStack);
    }

    public boolean method_5936() {
        return !this.isItemPickupCoolingDown() && !this.isHoldingItem();
    }

    public boolean isHoldingItem() {
        return !this.method_5998(class_1268.field_5808).method_7960();
    }

    private boolean isItemPickupCoolingDown() {
        return this.method_18868().method_18876(class_4140.field_38397, class_4141.field_18456);
    }

    private void dropItem(class_1799 stack) {
        class_1542 itemEntity = new class_1542(this.method_37908(), this.method_23317(), this.method_23318(), this.method_23321(), stack);
        this.method_37908().method_8649((class_1297)itemEntity);
    }

    protected void method_5949(class_3218 level, class_1542 item) {
        class_1799 itemStack = item.method_6983();
        if (this.method_5939(itemStack) && PICKABLE_FOOD_FILTER.test(item)) {
            int i = itemStack.method_7947();
            if (i > 1) {
                this.dropItem(itemStack.method_7971(i - 1));
            }
            class_2392 particleEffect = new class_2392(class_2398.field_11218, itemStack);
            class_4174 foodComponent = (class_4174)itemStack.method_57824(class_9334.field_50075);
            float foodNutritionMultiplier = foodComponent != null ? (float)foodComponent.comp_2491() : 1.0f;
            this.method_6025(2.0f * foodNutritionMultiplier);
            this.playEatSound(itemStack);
            ParticleSpawner.spawnParticles((class_1309)this, (class_2394)particleEffect, 7, 0.1);
            GlareBrain.setItemPickupCooldown(this);
            item.method_31472();
        }
    }

    public class_241 getTargetEyesPositionOffset() {
        return this.targetEyesPositionOffset;
    }

    public void setTargetEyesPositionOffset(float xEyePositionOffset, float yEyePositionOffset) {
        this.targetEyesPositionOffset = new class_241(xEyePositionOffset, yEyePositionOffset);
    }

    private void updateTargetEyesPositionOffset() {
        if (this.field_6012 % 10 != 0 || this.method_59922().method_39332(0, 2) != 0) {
            return;
        }
        this.setTargetEyesPositionOffset(-0.5f + this.method_59922().method_43057(), -0.4f + this.method_59922().method_43057() * 0.8f);
    }

    public static class_5132.class_5133 createGlareAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 10.0).method_26868(class_5134.field_23720, (double)0.1f).method_26868(class_5134.field_23719, (double)0.1f).method_26868(class_5134.field_52450, 10.0).method_26868(class_5134.field_23717, 48.0);
    }

    protected class_1408 method_5965(class_1937 world) {
        class_1407 flyingPathNavigation = new class_1407((class_1308)this, world){

            public boolean method_6333(class_2338 pos) {
                return !this.field_6677.method_8320(pos.method_10074()).method_26215() && !this.field_6677.method_8320(pos.method_10074()).method_51176();
            }

            public void method_6360() {
                if (GlareEntity.this.method_24345() || GlareEntity.this.isGrumpy()) {
                    return;
                }
                super.method_6360();
            }
        };
        flyingPathNavigation.method_6332(false);
        flyingPathNavigation.method_6354(false);
        flyingPathNavigation.method_61439(48.0f);
        return flyingPathNavigation;
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return GlareBrain.create(dynamic);
    }

    public class_4095<GlareEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_18409() {
        super.method_18409();
        class_4209.method_19774((class_1309)this);
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
    }

    protected class_3414 method_5994() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_GLARE_AMBIENT.get();
    }

    public void method_5966() {
        class_3414 soundEvent = this.method_5994();
        this.method_5783(soundEvent, 0.025f, RandomGenerator.generateFloat(0.85f, 1.25f));
    }

    private class_3414 getGrumpinessSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_GLARE_GRUMPINESS.get();
    }

    public void playGrumpinessSound() {
        class_3414 soundEvent = this.getGrumpinessSound();
        this.method_5783(soundEvent, 0.05f, RandomGenerator.generateFloat(1.2f, 1.3f));
    }

    private class_3414 getGrumpinessShortSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_GLARE_GRUMPINESS_SHORT.get();
    }

    public void playGrumpinessShortSound() {
        class_3414 soundEvent = this.getGrumpinessShortSound();
        this.method_5783(soundEvent, 0.05f, RandomGenerator.generateFloat(1.2f, 1.3f));
    }

    private class_3414 getRustleSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_GLARE_RUSTLE.get();
    }

    public void playRustleSound() {
        class_3414 soundEvent = this.getRustleSound();
        this.method_5783(soundEvent, 0.1f, 0.1f);
    }

    private class_3414 getShakeSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_GLARE_SHAKE.get();
    }

    public void playShakeSound() {
        class_3414 soundEvent = this.getShakeSound();
        this.method_5783(soundEvent, 0.1f, 0.1f);
    }

    public class_3414 getEatSound(class_1799 stack) {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_GLARE_EAT.get();
    }

    public void playEatSound(class_1799 stack) {
        class_3414 soundEvent = this.getEatSound(stack);
        this.method_5783(soundEvent, 1.0f, 1.0f);
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_GLARE_HURT.get();
    }

    protected void method_6013(class_1282 source) {
        this.field_6191 = -this.method_5970();
        this.method_5783(this.method_6011(source), 1.0f, 0.5f);
    }

    protected class_3414 method_6002() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_GLARE_DEATH.get();
    }

    protected float method_6107() {
        return 1.0f;
    }

    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        class_1799 itemStack = player.method_5998(hand);
        class_1792 itemInHand = itemStack.method_7909();
        boolean interactionResult = false;
        if (itemInHand == class_1802.field_28659) {
            if (this.method_6181() && this.method_6032() < this.method_6063() && !this.method_6481(itemStack)) {
                interactionResult = this.tryToHealWithGlowBerries(player, itemStack);
            } else if (!this.method_6181()) {
                interactionResult = this.tryToTameWithGlowBerries(player, itemStack);
            }
        }
        if (interactionResult) {
            this.method_32875((class_6880)class_5712.field_28725, (class_1297)this);
            return VersionedInteractionResult.success((class_1297)this);
        }
        class_1269 actionResult = super.method_5992(player, hand);
        if (this.method_6171((class_1309)player) && !actionResult.method_23665()) {
            this.method_24346(!this.method_24345());
            if (this.method_24345()) {
                MovementUtil.stopMovement((class_1308)this);
            }
            return class_1269.field_5812;
        }
        return actionResult;
    }

    private boolean tryToHealWithGlowBerries(class_1657 player, class_1799 itemStack) {
        if (this.method_6032() == this.method_6063()) {
            return false;
        }
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            class_4174 foodComponent = (class_4174)itemStack.method_57824(class_9334.field_50075);
            if (foodComponent == null) {
                return false;
            }
            this.method_6025(2.0f * (float)foodComponent.comp_2491());
            this.playEatSound(itemStack);
            itemStack.method_57008(1, (class_1309)player);
            class_2392 particleEffect = new class_2392(class_2398.field_11218, itemStack);
            ParticleSpawner.spawnParticles((class_1309)this, (class_2394)particleEffect, 7, 0.1);
        }
        return true;
    }

    private boolean tryToTameWithGlowBerries(class_1657 player, class_1799 itemStack) {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
            this.playEatSound(itemStack);
            if (this.method_59922().method_43048(3) == 0) {
                this.method_6170(player);
                this.method_37908().method_8421((class_1297)this, (byte)7);
            } else {
                this.method_37908().method_8421((class_1297)this, (byte)6);
            }
        }
        return true;
    }

    public boolean method_24345() {
        return this.method_6172();
    }

    public void method_24346(boolean isSitting) {
        super.method_24346(isSitting);
        super.method_6179(isSitting);
    }

    @Nullable
    public class_4208 getGlowBerriesPos() {
        return this.method_18868().method_46873((class_4140)FriendsAndFoesMemoryModuleTypes.GLARE_GLOW_BERRIES_POS.get()).orElse(null);
    }

    public boolean canEatGlowBerriesAt(class_2338 pos) {
        class_2680 blockState = this.method_37908().method_8320(pos);
        return class_5803.method_33618((class_2680)blockState);
    }

    @Nullable
    public class_4208 getDarkSpotPos() {
        return this.method_18868().method_46873((class_4140)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get()).orElse(null);
    }

    public boolean isDarkSpotDark(class_2338 pos) {
        return this.method_37908().method_8314(class_1944.field_9282, pos) == 0;
    }

    public boolean method_6581() {
        return !this.method_24828();
    }

    protected void method_6010(class_6862<class_3611> tagKey) {
        this.method_18799(this.method_18798().method_1031(0.0, 0.01, 0.0));
    }

    public boolean method_5747(float fallDistance, float damageMultiplier, class_1282 damageSource) {
        return false;
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    public float method_17825() {
        return this.method_6109() ? 0.4f : 0.8f;
    }

    public boolean canBeLeashedBy(class_1657 player) {
        return !this.method_60953();
    }

    protected void method_6180(boolean positive) {
        class_2400 particleEffect = positive ? class_2398.field_11201 : class_2398.field_11251;
        for (int i = 0; i < 7; ++i) {
            double d = this.method_59922().method_43059() * 0.02;
            double e = this.method_59922().method_43059() * 0.02;
            double f = this.method_59922().method_43059() * 0.02;
            this.method_37908().method_8406((class_2394)particleEffect, this.method_23322(1.0), this.method_23319() + 0.5, this.method_23325(1.0), d, e, f);
        }
    }

    protected void method_56996() {
        if (this.method_6181()) {
            this.method_5996(class_5134.field_23716).method_6192(30.0);
            this.method_6033(this.method_6063());
        } else {
            this.method_5996(class_5134.field_23716).method_6192(10.0);
        }
    }

    public void method_6170(class_1657 owner) {
        this.method_6173(true, true);
        this.method_6174(owner.method_5667());
        if (owner instanceof class_3222) {
            ((class_2131)FriendsAndFoesCriterias.TAME_GLARE.get()).method_9132((class_3222)owner, (class_1429)this);
        }
    }

    public boolean method_6481(class_1799 itemStack) {
        return GlareBrain.getTemptations().test(itemStack);
    }

    @Nullable
    public class_1296 method_5613(class_3218 serverWorld, class_1296 entity) {
        GlareEntity glareEntity = (GlareEntity)((class_1299)FriendsAndFoesEntityTypes.GLARE.get()).method_5883((class_1937)serverWorld, class_3730.field_16466);
        GlareBrain.setDarkSpotLocatingCooldown(this);
        GlareBrain.setLocatingGlowBerriesCooldown(this);
        GlareBrain.setItemPickupCooldown(this);
        if (this.method_6181()) {
            glareEntity.method_6174(this.method_6139());
            glareEntity.method_6173(true, true);
        }
        return glareEntity;
    }

    public boolean method_6474(class_1429 other) {
        if (other == this || !this.method_6181() || !(other instanceof GlareEntity)) {
            return false;
        }
        GlareEntity glare = (GlareEntity)other;
        if (!glare.method_6181() || glare.method_6172()) {
            return false;
        }
        return this.method_6479() && glare.method_6479();
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        if (!level.method_8608()) {
            this.method_24346(false);
            this.method_5942().method_6344(0.0);
            this.method_5942().method_6340();
        }
        return super.method_64397(level, damageSource, amount);
    }

    public float method_6029() {
        if (this.method_6109()) {
            return 0.05f;
        }
        return 0.1f;
    }

    public void setGrumpy(boolean grumpy) {
        this.setGlareFlag(2, grumpy);
    }

    public boolean isGrumpy() {
        return this.hasGlareFlag(2);
    }

    static {
        GLARE_FLAGS = class_2945.method_12791(GlareEntity.class, (class_2941)class_2943.field_13319);
        PICKABLE_FOOD_FILTER = itemEntity -> itemEntity.method_6983().method_31573(FriendsAndFoesTags.GLARE_FOOD_ITEMS) && itemEntity.method_5805() && !itemEntity.method_6977();
    }

    final class GlareMoveControl
    extends class_1331 {
        public GlareMoveControl(GlareEntity glare, int maxPitchChange, boolean noGravity) {
            super((class_1308)glare, maxPitchChange, noGravity);
        }

        public void method_6240() {
            if (GlareEntity.this.method_24345()) {
                return;
            }
            super.method_6240();
        }
    }
}

