/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import com.faboslav.friendsandfoes.common.versions.VersionedNbt;
import java.util.UUID;
import net.minecraft.class_1068;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_1664;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_5425;
import net.minecraft.class_640;
import net.minecraft.class_8685;
import org.jetbrains.annotations.Nullable;

public final class PlayerIllusionEntity
extends class_1308 {
    private static final String TICKS_UNTIL_DESPAWN_NBT_NAME = "TicksUntilDespawn";
    private static final class_2940<Integer> TICKS_UNTIL_DESPAWN;
    private static final String PLAYER_UUID_NBT_NAME = "PlayerUuid";
    private static final class_2940<Byte> PLAYER_MODEL_PARTS;
    @Nullable
    private class_1657 player;
    @Nullable
    private UUID playerUUID;
    @Nullable
    private class_640 playerListEntry;
    public double prevCapeX;
    public double prevCapeY;
    public double prevCapeZ;
    public double capeX;
    public double capeY;
    public double capeZ;
    public float prevStrideDistance;
    public float strideDistance;

    public PlayerIllusionEntity(class_1299<? extends class_1308> entityType, class_1937 world) {
        super(entityType, world);
    }

    @Nullable
    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        if (spawnReason == VersionedEntitySpawnReason.COMMAND) {
            this.setTicksUntilDespawn(600);
        }
        return super.method_5943(world, difficulty, spawnReason, entityData);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(PLAYER_MODEL_PARTS, (Object)0);
        builder.method_56912(TICKS_UNTIL_DESPAWN, (Object)0);
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10569(TICKS_UNTIL_DESPAWN_NBT_NAME, this.getTicksUntilDespawn());
        VersionedNbt.putUUID(nbt, PLAYER_UUID_NBT_NAME, this.getPlayerUuid());
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.setPlayerUuid(VersionedNbt.getUUID(nbt, PLAYER_UUID_NBT_NAME));
        this.setTicksUntilDespawn(VersionedNbt.getInt(nbt, TICKS_UNTIL_DESPAWN_NBT_NAME, 0));
    }

    public boolean method_6054() {
        return false;
    }

    protected boolean method_27071() {
        return false;
    }

    public boolean method_5733() {
        return false;
    }

    public void method_6007() {
        boolean isPlayerNonExistingOrDead;
        super.method_6007();
        if (this.getTicksUntilDespawn() > 0) {
            this.setTicksUntilDespawn(this.getTicksUntilDespawn() - 1);
        }
        boolean bl = isPlayerNonExistingOrDead = this.getPlayer() != null && !this.getPlayer().method_5805();
        if (this.getTicksUntilDespawn() == 0 || isPlayerNonExistingOrDead) {
            this.discardIllusion();
        }
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        this.discardIllusion();
        return true;
    }

    public boolean isPartVisible(class_1664 modelPart) {
        return ((Byte)this.method_5841().method_12789(PLAYER_MODEL_PARTS) & modelPart.method_7430()) == modelPart.method_7430();
    }

    public class_8685 getSkinTextures() {
        class_640 playerListEntry = this.getPlayerListEntry();
        if (playerListEntry != null) {
            return playerListEntry.method_52810();
        }
        UUID uuid = this.getPlayerUuid();
        if (uuid == null) {
            uuid = this.method_5667();
        }
        return class_1068.method_4648((UUID)uuid);
    }

    public class_243 lerpVelocity(float tickDelta) {
        return class_243.field_1353.method_35590(this.method_18798(), (double)tickDelta);
    }

    @Nullable
    private class_640 getPlayerListEntry() {
        if (this.playerListEntry == null) {
            UUID uuid = this.getPlayerUuid();
            if (uuid == null) {
                uuid = this.method_5667();
            }
            this.playerListEntry = class_310.method_1551().method_1562().method_2871(uuid);
        }
        return this.playerListEntry;
    }

    @Nullable
    public UUID getPlayerUuid() {
        return this.playerUUID;
    }

    public void setPlayerUuid(@Nullable UUID uuid) {
        this.playerUUID = uuid;
    }

    @Nullable
    public class_1657 getPlayer() {
        return this.player;
    }

    public void setPlayer(class_1657 player) {
        this.player = player;
    }

    public int getTicksUntilDespawn() {
        return (Integer)this.field_6011.method_12789(TICKS_UNTIL_DESPAWN);
    }

    public void setTicksUntilDespawn(int ticksUntilDespawn) {
        this.field_6011.method_12778(TICKS_UNTIL_DESPAWN, (Object)ticksUntilDespawn);
    }

    private void discardIllusion() {
        this.playMirrorSound();
        this.spawnCloudParticles();
        this.method_31472();
    }

    private void playMirrorSound() {
        this.method_5783((class_3414)FriendsAndFoesSoundEvents.ENTITY_PLAYER_MIRROR_MOVE.get(), this.method_6107(), this.method_6017());
    }

    public boolean tryToTeleport(int x, int y, int z) {
        int worldBottomY = this.method_37908().method_31607();
        int logicalHeight = ((class_3218)this.method_37908()).method_32819();
        double bottomY = Math.max(y -= 8, worldBottomY);
        double topY = Math.min(bottomY + 16.0, (double)(logicalHeight - 1));
        for (int i = 0; i < 16; ++i) {
            boolean teleportResult = this.method_6082(x, y = (int)class_3532.method_15350((double)(y + 1), (double)bottomY, (double)topY), z, false);
            if (!teleportResult) continue;
            return true;
        }
        return false;
    }

    public void spawnCloudParticles() {
        this.spawnParticles(class_2398.field_11204, 16);
    }

    private <T extends class_2394> void spawnParticles(T particleType, int amount) {
        if (this.method_37908().method_8608()) {
            return;
        }
        for (int i = 0; i < amount; ++i) {
            ((class_3218)this.method_5770()).method_65096(particleType, this.method_23322(0.5), this.method_23319() + 0.5, this.method_23325(0.5), 1, 0.0, 0.0, 0.0, 0.0);
        }
    }

    static {
        PLAYER_MODEL_PARTS = class_2945.method_12791(PlayerIllusionEntity.class, (class_2941)class_2943.field_13319);
        TICKS_UNTIL_DESPAWN = class_2945.method_12791(PlayerIllusionEntity.class, (class_2941)class_2943.field_13327);
    }
}

