/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.goal.bee;

import com.faboslav.friendsandfoes.common.entity.MoobloomEntity;
import com.faboslav.friendsandfoes.common.mixin.BeeEntityAccessor;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.class_1297;
import net.minecraft.class_1352;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_4466;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;

public final class BeePollinateMoobloomGoal
extends class_1352 {
    private final class_4466 bee;
    private final BeeEntityAccessor beeEntityAccessor;
    private MoobloomEntity moobloom;
    private boolean running;
    private int ticks = 0;
    private int pollinationTicks = 0;
    private int lastPollinationTick = 0;

    public BeePollinateMoobloomGoal(class_4466 bee, BeeEntityAccessor beeEntityAccessor) {
        this.bee = bee;
        this.beeEntityAccessor = beeEntityAccessor;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.beeEntityAccessor.getTicksUntilCanPollinate() > 0) {
            return false;
        }
        if (this.bee.method_29511()) {
            return false;
        }
        if (this.bee.method_21784()) {
            return false;
        }
        if (this.bee.method_37908().method_8419()) {
            return false;
        }
        if (this.bee.method_59922().method_43057() < 0.5f) {
            return false;
        }
        if (this.bee.field_21079.method_23346()) {
            return false;
        }
        MoobloomEntity moobloom = this.findMoobloom();
        if (moobloom == null) {
            return false;
        }
        this.moobloom = moobloom;
        class_243 moobloomPollinationPos = this.getMoobloomPollinationPos();
        this.bee.method_5942().method_6337(moobloomPollinationPos.method_10216(), moobloomPollinationPos.method_10214(), moobloomPollinationPos.method_10215(), (double)1.2f);
        return true;
    }

    public boolean method_6266() {
        if (!this.isRunning()) {
            return false;
        }
        if (this.bee.method_29511()) {
            return false;
        }
        if (this.bee.method_5770().method_8419()) {
            return false;
        }
        if (this.completedPollination()) {
            return this.bee.method_59922().method_43057() < 0.2f;
        }
        if (this.getMoobloom() == null) {
            return false;
        }
        return this.moobloom.method_5805();
    }

    public void method_6269() {
        this.pollinationTicks = 0;
        this.ticks = 0;
        this.lastPollinationTick = 0;
        this.setIsRunning(true);
        this.bee.method_21780();
    }

    public void cancel() {
        this.setIsRunning(false);
    }

    public void method_6270() {
        if (this.completedPollination()) {
            this.pollinate();
            this.beeEntityAccessor.invokeSetHasNectar(true);
        }
        this.setIsRunning(false);
        this.bee.method_5942().method_6340();
        this.beeEntityAccessor.setTicksUntilCanPollinate(200);
    }

    public void method_6268() {
        ++this.ticks;
        if (this.ticks > 600) {
            this.setMoobloom(null);
            return;
        }
        class_243 moobloomPollinationPos = this.getMoobloomPollinationPos();
        double dinstanceToMoobloom = this.bee.method_19538().method_1022(moobloomPollinationPos);
        if (dinstanceToMoobloom >= 0.5) {
            this.bee.method_5962().method_6239(moobloomPollinationPos.method_10216(), moobloomPollinationPos.method_10214(), moobloomPollinationPos.method_10215(), 0.9);
            this.bee.method_5988().method_20248(moobloomPollinationPos.method_10216(), this.getMoobloom().method_23318(), moobloomPollinationPos.method_10215());
        }
        if (dinstanceToMoobloom <= 1.5) {
            ++this.pollinationTicks;
            if (this.bee.method_59922().method_43057() < 0.05f && this.pollinationTicks > this.lastPollinationTick + 60) {
                this.lastPollinationTick = this.pollinationTicks;
                this.bee.method_5783(class_3417.field_20607, 1.0f, 1.0f);
            }
        }
    }

    private void pollinate() {
        class_5819 random = this.bee.method_59922();
        for (int i = 0; i < 7; ++i) {
            double d = random.method_43059() * 0.02;
            double e = random.method_43059() * 0.02;
            double f = random.method_43059() * 0.02;
            ((class_3218)this.bee.method_37908()).method_65096((class_2394)class_2398.field_11201, this.bee.method_23322(1.0), this.bee.method_23319() + 0.5, this.bee.method_23325(1.0), 1, d, e, f, 1.0);
        }
    }

    @Nullable
    private MoobloomEntity findMoobloom() {
        List moobloomEntities = this.bee.method_37908().method_8390(MoobloomEntity.class, this.bee.method_5829().method_1014(32.0), livingEntity -> true);
        double d = Double.MAX_VALUE;
        MoobloomEntity closestMoobloomEntity = null;
        for (MoobloomEntity moobloomEntity : moobloomEntities) {
            if (moobloomEntity.method_6109() || !(this.bee.method_5858((class_1297)moobloomEntity) < d)) continue;
            closestMoobloomEntity = moobloomEntity;
            d = this.bee.method_5858((class_1297)moobloomEntity);
        }
        return closestMoobloomEntity;
    }

    private class_243 getMoobloomPollinationPos() {
        double moobloomPollinationYPos = this.getMoobloom().method_23318() + (double)this.getMoobloom().method_17682() * 1.5;
        return new class_243(this.getMoobloom().method_23317(), moobloomPollinationYPos, this.getMoobloom().method_23321());
    }

    private boolean completedPollination() {
        return this.pollinationTicks > 200;
    }

    private boolean isRunning() {
        return this.running;
    }

    private void setIsRunning(boolean isRunning) {
        this.running = isRunning;
    }

    public MoobloomEntity getMoobloom() {
        return this.moobloom;
    }

    public void setMoobloom(MoobloomEntity moobloomEntity) {
        this.moobloom = moobloomEntity;
    }
}

