/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.api;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.api.MoobloomVariant;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesBlocks;
import com.faboslav.friendsandfoes.common.tag.FriendsAndFoesTags;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.class_1792;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4309;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7654;
import org.jetbrains.annotations.Nullable;

public final class MoobloomVariantManager
extends class_4309<MoobloomVariant> {
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().setLenient().disableHtmlEscaping().excludeFieldsWithoutExposeAnnotation().create();
    private static final MoobloomVariant DEFAULT_MOOBLOOM_VARIANT = new MoobloomVariant("buttercup", (class_2248)FriendsAndFoesBlocks.BUTTERCUP.get(), FriendsAndFoesTags.HAS_MOOBLOOMS);
    public static final MoobloomVariantManager MOOBLOOM_VARIANT_MANAGER = new MoobloomVariantManager();
    private List<MoobloomVariant> moobloomVariants = new ArrayList<MoobloomVariant>(){
        {
            this.add(DEFAULT_MOOBLOOM_VARIANT);
        }
    };

    private MoobloomVariantManager() {
        super(MoobloomVariant.CODEC, class_7654.method_45114((String)"moobloom_variants"));
    }

    protected void apply(Map<class_2960, MoobloomVariant> moobloomVariants, class_3300 resourceManager, class_3695 profiler) {
        this.apply(moobloomVariants);
    }

    public void apply(Map<class_2960, MoobloomVariant> moobloomVariants) {
        this.moobloomVariants.clear();
        this.moobloomVariants.add(DEFAULT_MOOBLOOM_VARIANT);
        for (Map.Entry<class_2960, MoobloomVariant> entry : moobloomVariants.entrySet()) {
            MoobloomVariant moobloomVariant = entry.getValue();
            this.moobloomVariants.add(new MoobloomVariant(moobloomVariant.getName(), (class_2248)moobloomVariant.getFlower(), moobloomVariant.getBiomes()));
        }
        FriendsAndFoes.getLogger().info("Loaded {} moobloom variants", (Object)this.moobloomVariants.size());
    }

    public void setMoobloomVariants(List<MoobloomVariant> moobloomVariants) {
        this.moobloomVariants = moobloomVariants;
    }

    public List<MoobloomVariant> getMoobloomVariants() {
        return this.moobloomVariants;
    }

    public MoobloomVariant getDefaultMoobloomVariant() {
        return DEFAULT_MOOBLOOM_VARIANT;
    }

    public MoobloomVariant getRandomMoobloomVariant(class_5819 random) {
        Object[] values = this.getMoobloomVariants().toArray();
        int min = 0;
        int max = values.length - 1;
        return (MoobloomVariant)values[random.method_43048(max - min + 1) + min];
    }

    @Nullable
    public MoobloomVariant getMoobloomVariantByName(String name) {
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (!Objects.equals(moobloomVariant.getName(), name)) continue;
            return moobloomVariant;
        }
        return null;
    }

    @Nullable
    public MoobloomVariant getRandomBiomeSpecificMoobloomVariant(class_5425 serverWorldAccess, class_2338 blockPos) {
        ArrayList<MoobloomVariant> possibleMoobloomVariants = new ArrayList<MoobloomVariant>();
        class_6880 biome = serverWorldAccess.method_23753(blockPos);
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (!biome.method_40220(moobloomVariant.getBiomes())) continue;
            possibleMoobloomVariants.add(moobloomVariant);
        }
        if (possibleMoobloomVariants.isEmpty()) {
            return null;
        }
        return (MoobloomVariant)possibleMoobloomVariants.get(serverWorldAccess.method_8409().method_43048(possibleMoobloomVariants.size()));
    }

    @Nullable
    public MoobloomVariant getByFlowerItem(class_1792 flowerItem) {
        for (MoobloomVariant moobloomVariant : this.getMoobloomVariants()) {
            if (moobloomVariant.getFlowerAsItem() != flowerItem) continue;
            return moobloomVariant;
        }
        return null;
    }
}

