/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity;

import com.faboslav.friendsandfoes.common.FriendsAndFoes;
import com.faboslav.friendsandfoes.common.entity.ai.brain.RascalBrain;
import com.faboslav.friendsandfoes.common.entity.animation.AnimatedEntity;
import com.faboslav.friendsandfoes.common.entity.animation.RascalAnimations;
import com.faboslav.friendsandfoes.common.entity.animation.animator.context.AnimationContextTracker;
import com.faboslav.friendsandfoes.common.entity.animation.animator.loader.json.AnimationHolder;
import com.faboslav.friendsandfoes.common.entity.pose.FriendsAndFoesEntityPose;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesEntityDataSerializers;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesSoundEvents;
import com.faboslav.friendsandfoes.common.util.RandomGenerator;
import com.faboslav.friendsandfoes.common.util.particle.ParticleSpawner;
import com.faboslav.friendsandfoes.common.versions.VersionedEntitySpawnReason;
import com.faboslav.friendsandfoes.common.versions.VersionedProfilerProvider;
import com.mojang.serialization.Dynamic;
import java.util.ArrayList;
import net.minecraft.class_1266;
import net.minecraft.class_1282;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1315;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2378;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3195;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3481;
import net.minecraft.class_3695;
import net.minecraft.class_3730;
import net.minecraft.class_4095;
import net.minecraft.class_4140;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5138;
import net.minecraft.class_5425;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7;
import net.minecraft.class_7045;
import net.minecraft.class_7924;
import org.jetbrains.annotations.Nullable;

public final class RascalEntity
extends class_1296
implements AnimatedEntity {
    private AnimationContextTracker animationContextTracker;
    private static final class_2940<Integer> POSE_TICKS = class_2945.method_12791(RascalEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<FriendsAndFoesEntityPose> ENTITY_POSE = class_2945.method_12791(RascalEntity.class, FriendsAndFoesEntityDataSerializers.ENTITY_POSE);
    private static final class_2940<Integer> CAUGHT_COUNT = class_2945.method_12791(RascalEntity.class, (class_2941)class_2943.field_13327);
    private boolean ambientSounds;

    public RascalEntity(class_1299<? extends class_1296> entityType, class_1937 world) {
        super(entityType, world);
        this.setEntityPose(FriendsAndFoesEntityPose.IDLE);
        this.enableAmbientSounds();
        this.method_5941(class_7.field_21, 0.0f);
        this.method_5941(class_7.field_25418, 0.0f);
        this.method_5941(class_7.field_18, 0.0f);
        this.method_5941(class_7.field_4, 0.0f);
    }

    public class_1315 method_5943(class_5425 world, class_1266 difficulty, class_3730 spawnReason, @Nullable class_1315 entityData) {
        class_1315 superEntityData = super.method_5943(world, difficulty, spawnReason, entityData);
        this.setEntityPose(FriendsAndFoesEntityPose.IDLE);
        RascalBrain.setNodCooldown(this);
        return superEntityData;
    }

    public static boolean canSpawn(class_1299<? extends class_1308> rascalEntityType, class_5425 serverWorldAccess, class_3730 spawnReason, class_2338 blockPos, class_5819 random) {
        if (spawnReason == VersionedEntitySpawnReason.NATURAL) {
            class_3218 serverWorld = serverWorldAccess.method_8410();
            class_2378 structureRegistry = serverWorldAccess.method_30349().method_30530(class_7924.field_41246);
            class_5138 structureAccessor = serverWorld.method_27056();
            if (!(blockPos.method_10264() <= 63 && !serverWorldAccess.method_8311(blockPos) && serverWorldAccess.method_22346(blockPos, 0) != 0 && (serverWorldAccess.method_8320(blockPos.method_10074()).method_26164(class_3481.field_15471) || serverWorldAccess.method_8320(blockPos.method_10084()).method_26164(class_3481.field_15471) || serverWorldAccess.method_8320(blockPos.method_10095()).method_26164(class_3481.field_15471) || serverWorldAccess.method_8320(blockPos.method_10067()).method_26164(class_3481.field_15471) || serverWorldAccess.method_8320(blockPos.method_10072()).method_26164(class_3481.field_15471) || serverWorldAccess.method_8320(blockPos.method_10078()).method_26164(class_3481.field_15471)))) {
                return false;
            }
            for (class_6880 structure : structureRegistry.method_46735(class_7045.field_37046)) {
                if (!structureAccessor.method_38854(blockPos, (class_3195)structure.comp_349()).method_16657()) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    @Override
    public AnimationContextTracker getAnimationContextTracker() {
        if (this.animationContextTracker == null) {
            this.animationContextTracker = new AnimationContextTracker();
            for (AnimationHolder animation : this.getTrackedAnimations()) {
                this.animationContextTracker.add(animation);
            }
        }
        return this.animationContextTracker;
    }

    @Override
    public ArrayList<AnimationHolder> getTrackedAnimations() {
        return RascalAnimations.ANIMATIONS;
    }

    @Override
    public AnimationHolder getMovementAnimation() {
        return RascalAnimations.WALK;
    }

    @Override
    public int getCurrentAnimationTick() {
        return (Integer)this.field_6011.method_12789(POSE_TICKS);
    }

    @Override
    public void setCurrentAnimationTick(int keyframeAnimationTicks) {
        this.field_6011.method_12778(POSE_TICKS, (Object)keyframeAnimationTicks);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(POSE_TICKS, (Object)0);
        builder.method_56912(ENTITY_POSE, (Object)FriendsAndFoesEntityPose.IDLE);
        builder.method_56912(CAUGHT_COUNT, (Object)0);
    }

    @Nullable
    public class_1296 method_5613(class_3218 world, class_1296 entity) {
        return null;
    }

    protected class_4095<?> method_18867(Dynamic<?> dynamic) {
        return RascalBrain.create(dynamic);
    }

    public class_4095<RascalEntity> method_18868() {
        return super.method_18868();
    }

    protected void method_5958(class_3218 level) {
        class_3695 profiler = VersionedProfilerProvider.getProfiler((class_1297)this);
        profiler.method_15396("rascalBrain");
        this.method_18868().method_19542(level, (class_1309)this);
        profiler.method_15407();
        profiler.method_15396("rascalActivityUpdate");
        RascalBrain.updateActivities(this);
        profiler.method_15407();
        super.method_5958(level);
    }

    public static class_5132.class_5133 createRascalAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23719, 0.55).method_26868(class_5134.field_23718, 1.0);
    }

    public void method_5773() {
        if (!FriendsAndFoes.getConfig().enableRascal) {
            this.method_31472();
        }
        class_1293 invisibilityStatusEffect = this.method_6112(class_1294.field_5905);
        if (this.isHidden() && invisibilityStatusEffect != null && invisibilityStatusEffect.method_5584() == 1) {
            this.playReappearSound();
        }
        this.updateKeyframeAnimations();
        super.method_5773();
    }

    private void updateKeyframeAnimations() {
        AnimationHolder animationToStart;
        if (!this.method_73183().method_8608()) {
            this.updateCurrentAnimationTick();
        }
        if ((animationToStart = this.getAnimationByPose()) != null) {
            this.tryToStartAnimation(animationToStart);
        }
    }

    @Override
    @Nullable
    public AnimationHolder getAnimationByPose() {
        AnimationHolder animation = null;
        if (this.isInEntityPose(FriendsAndFoesEntityPose.IDLE) && !this.isMoving()) {
            animation = RascalAnimations.IDLE;
        } else if (this.isInEntityPose(FriendsAndFoesEntityPose.NOD)) {
            animation = RascalAnimations.NOD;
        } else if (this.isInEntityPose(FriendsAndFoesEntityPose.GIVE_REWARD)) {
            animation = RascalAnimations.GIVE_REWARD;
        }
        return animation;
    }

    private void tryToStartAnimation(AnimationHolder animationToStart) {
        if (this.isKeyframeAnimationRunning(animationToStart)) {
            return;
        }
        if (!this.method_73183().method_8608()) {
            this.setCurrentAnimationTick(animationToStart.get().lengthInTicks());
        }
        this.startKeyframeAnimation(animationToStart);
    }

    private void startKeyframeAnimation(AnimationHolder animationToStart) {
        for (AnimationHolder animation : this.getTrackedAnimations()) {
            if (animation == animationToStart) continue;
            this.stopKeyframeAnimation(animation);
        }
        this.startKeyframeAnimation(animationToStart, this.field_6012);
    }

    public void setEntityPose(FriendsAndFoesEntityPose pose) {
        if (this.method_73183().method_8608()) {
            return;
        }
        this.field_6011.method_12778(ENTITY_POSE, (Object)pose);
    }

    public FriendsAndFoesEntityPose getEntityPose() {
        return (FriendsAndFoesEntityPose)((Object)this.field_6011.method_12789(ENTITY_POSE));
    }

    public boolean isInEntityPose(FriendsAndFoesEntityPose pose) {
        return this.getEntityPose() == pose;
    }

    public void startNodAnimation() {
        if (this.isInEntityPose(FriendsAndFoesEntityPose.NOD)) {
            return;
        }
        this.playNodSound();
        this.method_32876((class_6880)class_5712.field_45148);
        this.setEntityPose(FriendsAndFoesEntityPose.NOD);
    }

    public void startGiveRewardAnimation() {
        if (this.isInEntityPose(FriendsAndFoesEntityPose.GIVE_REWARD)) {
            return;
        }
        this.playRewardSound();
        this.method_32876((class_6880)class_5712.field_45148);
        this.setEntityPose(FriendsAndFoesEntityPose.GIVE_REWARD);
    }

    public boolean method_64397(class_3218 level, class_1282 damageSource, float amount) {
        class_1297 attacker = damageSource.method_5529();
        if (!(attacker instanceof class_1657) || this.method_16914()) {
            return super.method_64397(level, damageSource, amount);
        }
        this.method_6013(damageSource);
        this.playDisappearSound();
        this.spawnCloudParticles();
        this.spawnAngerParticles();
        this.method_31472();
        return false;
    }

    public class_3414 getNodSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_RASCAL_NOD.get();
    }

    public void playNodSound() {
        this.method_5783(this.getNodSound(), 1.0f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    public class_3414 getRewardSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_RASCAL_REWARD.get();
    }

    public void playRewardSound() {
        this.method_5783(this.getRewardSound(), 1.0f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    public class_3414 getBadRewardSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_RASCAL_REWARD_BAD.get();
    }

    public void playBadRewardSound() {
        this.method_5783(this.getBadRewardSound(), 1.0f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    protected class_3414 method_5994() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_RASCAL_AMBIENT.get();
    }

    public void method_5966() {
        if (this.isHidden() || !this.ambientSounds) {
            return;
        }
        class_3414 soundEvent = this.method_5994();
        this.method_5783(soundEvent, 1.5f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    protected class_3414 method_6011(class_1282 source) {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_RASCAL_HURT.get();
    }

    protected void method_6013(class_1282 source) {
        this.field_6191 = -this.method_5970();
        this.method_5783(this.method_6011(source), 1.0f, RandomGenerator.generateFloat(1.15f, 1.3f));
    }

    public class_3414 getDisappearSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_RASCAL_DISAPPEAR.get();
    }

    public void playDisappearSound() {
        class_3414 soundEvent = this.getDisappearSound();
        this.method_5783(soundEvent, 2.0f, RandomGenerator.generateFloat(1.5f, 1.6f));
    }

    public class_3414 getReappearSound() {
        return (class_3414)FriendsAndFoesSoundEvents.ENTITY_RASCAL_REAPPEAR.get();
    }

    public void playReappearSound() {
        class_3414 soundEvent = this.getReappearSound();
        this.method_5783(soundEvent, 2.0f, RandomGenerator.generateFloat(1.5f, 1.6f));
    }

    protected void method_5712(class_2338 pos, class_2680 state) {
        if (this.isHidden() || state.method_51176()) {
            return;
        }
        super.method_5712(pos, state);
    }

    public boolean isHidden() {
        return this.method_18868().method_46873(class_4140.field_22357).orElse(null) instanceof class_1657;
    }

    public boolean isMoving() {
        return this.method_24828() && this.method_18798().method_1027() >= 1.0E-4;
    }

    public int getCaughtCount() {
        return (Integer)this.field_6011.method_12789(CAUGHT_COUNT);
    }

    public void addToCaughtCount() {
        this.field_6011.method_12778(CAUGHT_COUNT, (Object)(this.getCaughtCount() + 1));
    }

    public boolean shouldGiveReward() {
        return this.getCaughtCount() == 3;
    }

    public boolean disableAmbientSounds() {
        this.ambientSounds = false;
        return false;
    }

    public boolean enableAmbientSounds() {
        this.ambientSounds = true;
        return true;
    }

    public void spawnCloudParticles() {
        ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_11204, 16, 0.1);
    }

    public void spawnAngerParticles() {
        ParticleSpawner.spawnParticles((class_1309)this, (class_2394)class_2398.field_11231, 16, 0.1);
    }
}

