/*
 * Decompiled with CFR 0.152.
 */
package com.faboslav.friendsandfoes.common.entity.ai.brain.task.glare;

import com.faboslav.friendsandfoes.common.entity.GlareEntity;
import com.faboslav.friendsandfoes.common.entity.ai.brain.GlareBrain;
import com.faboslav.friendsandfoes.common.init.FriendsAndFoesMemoryModuleTypes;
import java.util.ArrayList;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_3218;
import net.minecraft.class_4097;
import net.minecraft.class_4140;
import net.minecraft.class_4141;
import net.minecraft.class_4208;
import net.minecraft.class_4802;
import net.minecraft.class_5321;
import org.jetbrains.annotations.Nullable;

public final class GlareLocateDarkSpotTask
extends class_4097<GlareEntity> {
    public GlareLocateDarkSpotTask() {
        super(Map.of((class_4140)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_LOCATING_COOLDOWN.get(), class_4141.field_18457, (class_4140)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), class_4141.field_18457), 1);
    }

    protected boolean checkExtraStartConditions(class_3218 world, GlareEntity glare) {
        return GlareLocateDarkSpotTask.canLocateDarkSpot(glare);
    }

    protected void start(class_3218 world, GlareEntity glare, long time) {
        class_2338 darkSpotPos = this.findRandomDarkSpot(glare);
        if (darkSpotPos == null) {
            GlareBrain.setDarkSpotLocatingCooldown(glare, class_4802.method_24505((int)10, (int)10));
            return;
        }
        class_5321 registryKey = glare.method_37908().method_27983();
        glare.method_18868().method_18878((class_4140)FriendsAndFoesMemoryModuleTypes.GLARE_DARK_SPOT_POS.get(), (Object)class_4208.method_19443((class_5321)registryKey, (class_2338)darkSpotPos));
    }

    private ArrayList<class_2338> findDarkSpots(GlareEntity glare) {
        class_3218 serverWorld = (class_3218)glare.method_37908();
        class_2338 blockPos = glare.method_24515();
        ArrayList<class_2338> darkSpots = new ArrayList<class_2338>();
        int searchDistance = 16;
        int i = 0;
        while ((double)i <= (double)searchDistance) {
            int j = 0;
            while ((double)j < (double)searchDistance) {
                int k = 0;
                while (k <= j) {
                    int l;
                    int n = l = k < j && k > -j ? j : 0;
                    while (l <= j) {
                        boolean isBlockAccessible;
                        class_2338.class_2339 possibleDarkSpotBlockPos = new class_2338.class_2339();
                        possibleDarkSpotBlockPos.method_25504((class_2382)blockPos, k, i - 1, l);
                        boolean isBlockWithinDistance = blockPos.method_19771((class_2382)possibleDarkSpotBlockPos, (double)searchDistance);
                        boolean isSpotDarkEnough = glare.method_37908().method_8314(class_1944.field_9282, (class_2338)possibleDarkSpotBlockPos) == 0;
                        boolean isBlockSolidSurface = serverWorld.method_8320(possibleDarkSpotBlockPos.method_10074()).method_26168((class_1922)serverWorld, (class_2338)possibleDarkSpotBlockPos, (class_1297)glare);
                        boolean bl = isBlockAccessible = serverWorld.method_22347((class_2338)possibleDarkSpotBlockPos) && serverWorld.method_22347(possibleDarkSpotBlockPos.method_10084());
                        if (isBlockWithinDistance && isBlockSolidSurface && isBlockAccessible && isSpotDarkEnough) {
                            darkSpots.add((class_2338)possibleDarkSpotBlockPos);
                        }
                        l = l > 0 ? -l : 1 - l;
                    }
                    k = k > 0 ? -k : 1 - k;
                }
                ++j;
            }
            i = i > 0 ? -i : 1 - i;
        }
        return darkSpots;
    }

    @Nullable
    private class_2338 findRandomDarkSpot(GlareEntity glare) {
        ArrayList<class_2338> darkSpots = this.findDarkSpots(glare);
        if (darkSpots.isEmpty()) {
            return null;
        }
        return darkSpots.get(glare.method_59922().method_43048(darkSpots.size()));
    }

    public static boolean canLocateDarkSpot(GlareEntity glare) {
        class_1937 level = glare.method_37908();
        boolean isDay = level.method_8530();
        boolean canSeeSky = level.method_8311(glare.method_24515());
        return !glare.method_60953() && !glare.method_24345() && !glare.method_5765() && !glare.method_6109() && glare.method_6181() && (!isDay || !canSeeSky);
    }
}

