/*
 * Decompiled with CFR 0.152.
 */
package com.minelittlepony.mson.api.export;

import com.google.gson.JsonElement;
import com.google.gson.Strictness;
import com.google.gson.internal.Streams;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Stack;
import org.jetbrains.annotations.Nullable;

public abstract class ModelSerializer<T>
implements AutoCloseable {
    public abstract JsonElement writeToJsonElement(T var1);

    public String writeToString(T content) {
        try {
            return this.writeIndented(this.writeToJsonElement(content), new StringWriter()).toString();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public void writeToFile(Path path, T content) throws IOException {
        Files.createDirectories(path.getParent(), new FileAttribute[0]);
        try (BufferedWriter w = Files.newBufferedWriter(path, new OpenOption[0]);){
            this.writeIndented(this.writeToJsonElement(content), w).flush();
        }
    }

    private <W extends Writer> W writeIndented(JsonElement json, W writer) throws IOException {
        Streams.write((JsonElement)json, (JsonWriter)new JsWriter(writer));
        return writer;
    }

    private static class JsWriter
    extends JsonWriter {
        private static final String INDENT = "  ";
        private static final String NO_INDENT = "";
        private String currentIndent = "  ";
        private final Stack<String> indentStack = new Stack();

        public JsWriter(Writer out) {
            super(out);
            this.setStrictness(Strictness.LENIENT);
            this.setIndent(this.currentIndent);
        }

        public JsonWriter beginArray() throws IOException {
            super.beginArray();
            return this.pushIndent(NO_INDENT);
        }

        public JsonWriter endArray() throws IOException {
            super.endArray();
            return this.popIndent();
        }

        public JsonWriter beginObject() throws IOException {
            super.beginObject();
            return this.pushIndent(INDENT);
        }

        public JsonWriter endObject() throws IOException {
            super.endObject();
            return this.popIndent();
        }

        private JsonWriter pushIndent(@Nullable String indent) {
            this.indentStack.push(this.currentIndent);
            this.currentIndent = indent;
            this.setIndent(indent);
            return this;
        }

        private JsonWriter popIndent() {
            this.currentIndent = this.indentStack.pop();
            this.setIndent(this.currentIndent);
            return this;
        }
    }
}

